/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.jersey;

import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.api.model.AbstractSubResourceLocator;
import com.sun.jersey.core.reflection.AnnotatedMethod;
import com.sun.jersey.server.impl.modelapi.annotation.IntrospectionModeller;
import java.util.HashSet;
import java.util.Set;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.ProxyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvisedResourceFactory<T>
extends ProxyFactory {
    private final boolean advising;

    private AdvisedResourceFactory() {
        this.advising = true;
    }

    public AdvisedResourceFactory(Class<T> resourceClass) {
        AbstractResource resource = IntrospectionModeller.createResource(resourceClass);
        if (!resource.isRootResource()) {
            this.advising = false;
        } else {
            this.advising = true;
            Set<Class> definingClasses = this.getDefiningClasses(resource);
            if (!this.dynamicProxySupportable(definingClasses)) {
                this.setProxyTargetClass(true);
            } else {
                this.setInterfaces(definingClasses.toArray(new Class[definingClasses.size()]));
            }
        }
    }

    protected boolean dynamicProxySupportable(Set<Class> definingClasses) {
        for (Class definingClass : definingClasses) {
            if (definingClass.isInterface()) continue;
            return false;
        }
        return true;
    }

    public Object createAdvisedResource(T bareResource) {
        if (!this.advising) {
            return bareResource;
        }
        AdvisedResourceFactory<T> local = new AdvisedResourceFactory<T>();
        local.copyConfigurationFrom((AdvisedSupport)this);
        local.setTarget(bareResource);
        return local.getProxy();
    }

    protected Set<Class> getDefiningClasses(AbstractResource resourceClass) {
        HashSet<Class> definingClasses = new HashSet<Class>();
        for (AbstractResourceMethod resourceMethod : resourceClass.getResourceMethods()) {
            definingClasses.add(new AnnotatedMethod(resourceMethod.getMethod()).getMethod().getDeclaringClass());
        }
        for (AbstractResourceMethod resourceMethod : resourceClass.getSubResourceMethods()) {
            definingClasses.add(new AnnotatedMethod(resourceMethod.getMethod()).getMethod().getDeclaringClass());
        }
        for (AbstractSubResourceLocator locator : resourceClass.getSubResourceLocators()) {
            definingClasses.add(new AnnotatedMethod(locator.getMethod()).getMethod().getDeclaringClass());
        }
        return definingClasses;
    }
}

