/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.dbforms.util.Util;

public class TimeUtil {
    private static Log logCat = LogFactory.getLog((String)(class$org$dbforms$util$TimeUtil == null ? (class$org$dbforms$util$TimeUtil = TimeUtil.class$("org.dbforms.util.TimeUtil")) : class$org$dbforms$util$TimeUtil).getName());
    static final int SECSPERDAY = 86400;
    private static String reISO8601 = "(\\d\\d\\d\\d)(-(\\d\\d)(-(\\d\\d))?)?([T| ]?(\\d\\d):(\\d\\d)(:((\\d\\d)(\\.(\\d+))?)?)?(Z|([+-]\\d\\d:\\d\\d)|([A-Z]{3}))?)?";
    static /* synthetic */ Class class$org$dbforms$util$TimeUtil;

    public static final String seconds2String(String seconds) {
        if (Util.isNull(seconds)) {
            return "";
        }
        return TimeUtil.seconds2String(Integer.valueOf(seconds));
    }

    public static final String seconds2String(Integer seconds) {
        return TimeUtil.seconds2String((long)seconds.intValue());
    }

    public static final String seconds2String(Long seconds) {
        return TimeUtil.seconds2String((long)seconds);
    }

    public static final String seconds2String(long seconds) {
        String zeit;
        long d = seconds / 86400L;
        long h = (seconds -= d * 86400L) / 3600L;
        long m = (seconds -= h * 60L * 60L) / 60L;
        seconds -= m * 60L;
        if (d > 0L) {
            Object[] o = new Object[]{new Long(d), new Long(h), new Long(m), new Long(seconds)};
            zeit = Util.sprintf("%i:%02i:%02i:%02i", o);
        } else {
            Object[] o = new Object[]{new Long(h), new Long(m), new Long(seconds)};
            zeit = Util.sprintf("%i:%02i:%02i", o);
        }
        return zeit;
    }

    public static Date findEndOfDay(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.add(5, 1);
        return cal.getTime();
    }

    public static Calendar parseDate(SimpleDateFormat format, String s) {
        StringBuffer sDate = new StringBuffer();
        StringBuffer sTime = new StringBuffer();
        StringBuffer fDate = new StringBuffer();
        StringBuffer fTime = new StringBuffer();
        TimeUtil.splitDate(s, sDate, sTime);
        TimeUtil.splitDate(format.toPattern(), fDate, fTime);
        SimpleDateFormat f = (SimpleDateFormat)format.clone();
        Calendar dDate = TimeUtil.saveParseDate(f, fDate.toString(), sDate.toString());
        long date = dDate.getTime().getTime();
        f.setTimeZone(dDate.getTimeZone());
        long time = TimeUtil.saveParseTime(f, fTime.toString(), sTime.toString());
        long offset = dDate.getTimeZone().getRawOffset();
        if (!Util.isNull(sTime.toString())) {
            time += offset;
        }
        Calendar c = format.getCalendar();
        Date dateAsDate = new Date(date += time);
        c.setTime(dateAsDate);
        logCat.info((Object)("parsed " + s + " to " + format.format(c.getTime())));
        return c;
    }

    public static Date parseISO8601Date(String s) {
        ISO8601 iso = TimeUtil.parseISO8601(s);
        if (iso != null) {
            TimeZone tz = null;
            if (iso.tz != null && iso.tz.length() != 0) {
                tz = iso.tz.equals("Z") ? TimeZone.getTimeZone("GMT") : (iso.tz.length() == 3 ? TimeZone.getTimeZone(iso.tz) : TimeZone.getTimeZone("GMT" + iso.tz));
            }
            GregorianCalendar cal = new GregorianCalendar(iso.year, iso.month - 1, iso.day, iso.hour, iso.min, iso.sec);
            if (tz != null) {
                ((Calendar)cal).setTimeZone(tz);
            }
            return cal.getTime();
        }
        return null;
    }

    private static ISO8601 parseISO8601(String s) {
        try {
            RE re = new RE(reISO8601);
            if (re.match(s)) {
                ISO8601 iso = new ISO8601();
                iso.year = TimeUtil.toInt(re.getParen(1));
                iso.month = TimeUtil.toInt(re.getParen(3));
                iso.day = TimeUtil.toInt(re.getParen(5));
                iso.hour = TimeUtil.toInt(re.getParen(7));
                iso.min = TimeUtil.toInt(re.getParen(8));
                iso.sec = TimeUtil.toInt(re.getParen(11));
                iso.frac = TimeUtil.toInt(re.getParen(13));
                iso.tz = re.getParen(14);
                return iso;
            }
        }
        catch (RESyntaxException ree) {
            ree.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Calendar saveParseDate(SimpleDateFormat format, String formatString, String s) throws NumberFormatException {
        Calendar cal;
        Date d = null;
        Calendar now = Calendar.getInstance();
        if (!Util.isNull(s)) {
            if (!Util.isNull(formatString)) {
                format.applyPattern(formatString);
            }
            try {
                d = format.parse(s);
            }
            catch (Exception e) {
                logCat.error((Object)e);
                SimpleDateFormat f = (SimpleDateFormat)format.clone();
                f.applyPattern("yyyy-MM-dd");
                try {
                    d = f.parse(s);
                }
                catch (Exception ex) {
                    logCat.error((Object)ex);
                }
            }
            cal = format.getCalendar();
            if (d != null) {
                cal.setTime(d);
            } else {
                Calendar calendar = cal;
                synchronized (calendar) {
                    try {
                        cal.wait(5L);
                    }
                    catch (Exception ex) {
                        logCat.error((Object)ex);
                    }
                }
            }
            if (!(cal.isSet(5) || cal.isSet(2) || cal.isSet(1))) {
                throw new NumberFormatException("wrong date format");
            }
            if (!cal.isSet(5)) {
                cal.set(5, now.get(5));
            }
            if (!cal.isSet(2)) {
                cal.set(2, now.get(2));
            }
            if (!cal.isSet(1)) {
                cal.set(1, now.get(1));
            }
            if (cal.get(1) < 30) {
                cal.set(1, cal.get(1) + 2000);
            } else if (cal.get(1) < 100) {
                cal.set(1, cal.get(1) + 1900);
            }
        } else {
            cal = now;
        }
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized long saveParseTime(SimpleDateFormat format, String formatString, String s) {
        Date d = null;
        if (!Util.isNull(s)) {
            if (!Util.isNull(formatString)) {
                format.applyPattern(formatString);
            }
            try {
                d = format.parse(s);
            }
            catch (Exception e) {
                logCat.error((Object)e);
                SimpleDateFormat f = (SimpleDateFormat)format.clone();
                f.applyPattern("HH:mm:ss");
                try {
                    d = f.parse(s);
                }
                catch (Exception ex) {
                    logCat.error((Object)ex);
                }
            }
            Calendar cal = format.getCalendar();
            if (d != null) {
                cal.setTime(d);
            } else {
                Calendar calendar = cal;
                synchronized (calendar) {
                    try {
                        cal.wait(5L);
                    }
                    catch (Exception ex) {
                        logCat.error((Object)ex);
                    }
                }
            }
            if (!(cal.isSet(11) || cal.isSet(12) || cal.isSet(13))) {
                throw new NumberFormatException("wrong time format");
            }
            if (!cal.isSet(11)) {
                cal.set(11, 0);
            }
            if (!cal.isSet(12)) {
                cal.set(12, 0);
            }
            if (!cal.isSet(13)) {
                cal.set(13, 0);
            }
            return cal.getTime().getTime();
        }
        return 0L;
    }

    public static void splitDate(String format, StringBuffer sDate, StringBuffer sTime) {
        sDate.setLength(0);
        sTime.setLength(0);
        int i = format.lastIndexOf(58);
        if (i > -1) {
            if ((i = format.lastIndexOf(32, i)) > -1) {
                sDate.append(format.substring(0, i));
                sTime.append(format.substring(i + 1));
            } else {
                sTime.append(format);
            }
        } else {
            sDate.append(format);
        }
    }

    private static int toInt(String x) {
        if (x == null) {
            return 0;
        }
        try {
            return Integer.parseInt(x);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ISO8601 {
        public String tz;
        public int day;
        public int frac;
        public int hour;
        public int min;
        public int month;
        public int sec;
        public int year;

        private ISO8601() {
        }
    }
}

