/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.resource.util;

import de.destatis.core.resource.ResourceStorageException;
import de.destatis.core.resource.util.FileSystemResourceStorage;
import de.destatis.core.resource.util.SDFResourceConstants;
import java.io.File;

public class SDFFileSystemResourceStorage
extends FileSystemResourceStorage {
    public SDFFileSystemResourceStorage(File directory) throws ResourceStorageException {
        super(directory);
        this.setFileSuffix(".xml");
        this.setResourceIdPattern(SDFResourceConstants.SDF_RESOURCE_ID_PATTERN);
    }

    @Override
    protected String getResourceIdFromFileName(String fileName) {
        String resourceId = super.getResourceIdFromFileName(fileName);
        if (resourceId.length() == 20) {
            resourceId = "1" + resourceId;
        }
        return resourceId;
    }

    @Override
    protected File getStoredResourceFile(String resourceId) {
        File resourceFile = super.getStoredResourceFile(resourceId);
        if (resourceFile == null) {
            String fileName = resourceId.substring(1);
            resourceFile = new File(this.directory, fileName = fileName + ".xml");
            if (!resourceFile.isFile()) {
                resourceFile = null;
            }
        }
        return resourceFile;
    }
}

