/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.resource;

import java.util.HashMap;
import java.util.Map;

public final class NoResourceFoundException
extends Exception {
    public static final int NO_RESOURCE = 0;
    public static final int NO_RESOURCE_FOR_STAT_ID = 1;
    public static final int NO_RESOURCE_FOR_REPORTING_PERIOD_TYPE = 2;
    public static final int NO_RESOURCE_FOR_REPORTING_PERIOD = 3;
    public static final int NO_RESOURCE_FOR_COLLECTOR = 4;
    private static Map MESSAGES = new HashMap();
    private int reason;

    public NoResourceFoundException(int reason) {
        this.reason = reason;
    }

    public int getReason() {
        return this.reason;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (message == null) {
            message = this.getDefaultMessage();
        }
        return message;
    }

    private String getDefaultMessage() {
        String message = (String)MESSAGES.get(new Integer(this.reason));
        if (message == null) {
            message = "Keine Ressource gefunden (" + this.reason + ").";
        }
        return message;
    }

    static {
        MESSAGES.put(new Integer(0), "Keine Ressource vorhanden.");
        MESSAGES.put(new Integer(1), "Keine Ressource f\u00fcr StatistikId vorhanden.");
        MESSAGES.put(new Integer(2), "Keine Ressource f\u00fcr Berichtszeitraumtyp vorhanden.");
        MESSAGES.put(new Integer(3), "Keine Ressource f\u00fcr Berichtszeitraum vorhanden.");
        MESSAGES.put(new Integer(4), "Keine Ressource f\u00fcr Berichtsempf\u00e4nger vorhanden.");
    }
}

