/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor.util;

import de.destatis.core.map.FieldBinding;
import de.destatis.core.map.editor.util.AbstractTableCreator;
import java.io.IOException;
import java.io.Writer;

public abstract class HtmlPreviewCreator
extends AbstractTableCreator {
    protected static final String EVEN_BG_COLOR = "#f0f0f0";
    protected static final String ODD_BG_COLOR = "#e0e0e0";
    protected Writer writer;

    public HtmlPreviewCreator(Writer writer) {
        this.writer = writer;
    }

    @Override
    protected Object createRecordValue(FieldBinding fieldBinding, int offset, String currentStructure) {
        String result = null;
        StringBuffer buffer = new StringBuffer();
        int position = fieldBinding.getPosition() + offset;
        buffer.append("<td nowrap style=\"background-color: " + (position % 2 == 0 ? EVEN_BG_COLOR : ODD_BG_COLOR) + ";\"><span style=\"color: gray;\">");
        buffer.append(position);
        buffer.append("</span>&nbsp;&nbsp;");
        if (currentStructure != null && currentStructure.length() > 0) {
            buffer.append(currentStructure);
        }
        buffer.append(fieldBinding.getId());
        buffer.append("</td>");
        result = buffer.toString();
        return result;
    }

    protected void writeHtmlTableColumns(Writer writer, Object[] record, String evenBackgroundColor, String oddBackgroundColor) throws IOException {
        int len = record.length;
        for (int i = 0; i < len; ++i) {
            Object html = record[i];
            if (html == null) {
                int position = i + 1;
                writer.write("<td nowrap style=\"background-color: " + (position % 2 == 0 ? evenBackgroundColor : oddBackgroundColor) + ";\"><span style=\"color: gray;\">");
                writer.write(String.valueOf(position));
                writer.write("</span>&nbsp;&nbsp;&lt;undefiniert&gt;</td>");
                continue;
            }
            writer.write(html.toString());
        }
    }
}

