/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map;

import de.destatis.core.map.BindingGroup;
import de.destatis.core.map.MappingParser;
import de.destatis.core.map.MappingXmlConstants;
import de.destatis.core.map.MetaMappingParser;
import de.destatis.core.map.model.BindingImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class MappingsParser {
    public BindingGroup parse(File file) throws ParserConfigurationException, SAXException, FactoryConfigurationError, IOException {
        return this.parse(file, MappingXmlConstants.ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BindingGroup parse(File file, String encoding) throws ParserConfigurationException, SAXException, FactoryConfigurationError, IOException {
        BindingGroup mapping;
        FileInputStream fIn = null;
        try {
            fIn = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fIn, encoding));
            mapping = this.parse(reader);
            try {
                ((Reader)reader).close();
                fIn = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (fIn != null) {
                try {
                    fIn.close();
                }
                catch (Exception e) {}
            }
        }
        return mapping;
    }

    public BindingGroup parse(Reader reader) throws ParserConfigurationException, SAXException, FactoryConfigurationError, IOException {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        XmlParser xmlParser = new XmlParser();
        parser.parse(new InputSource(reader), (DefaultHandler)xmlParser);
        return xmlParser.getMapping();
    }

    private static class XmlParser
    extends DefaultHandler {
        private MetaMappingParser.XmlParser metaMappingHandler = null;
        private MappingParser.XmlParser sdfMappingHandler = null;
        private DefaultHandler delegate = null;

        public BindingGroup getMapping() {
            BindingImpl mapping = null;
            if (this.metaMappingHandler != null) {
                mapping = this.metaMappingHandler.getMapping();
            } else if (this.sdfMappingHandler != null) {
                mapping = this.sdfMappingHandler.getMapping();
            }
            return mapping;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.delegate != null) {
                this.delegate.startElement(uri, localName, qName, attributes);
            } else if (MappingXmlConstants.TAG_MAPPING.equals(qName)) {
                this.sdfMappingHandler = new MappingParser.XmlParser();
                this.delegate = this.sdfMappingHandler;
                this.delegate.startElement(uri, localName, qName, attributes);
            } else if (MappingXmlConstants.TAG_META_MAPPING.equals(qName)) {
                this.metaMappingHandler = new MetaMappingParser.XmlParser();
                this.delegate = this.metaMappingHandler;
                this.delegate.startElement(uri, localName, qName, attributes);
            } else {
                throw new SAXException("Unbekanntes Format: " + qName);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.delegate == null) {
                throw new SAXException("Unbekanntes Format: " + qName);
            }
            this.delegate.endElement(uri, localName, qName);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.delegate != null) {
                this.delegate.characters(ch, start, length);
            }
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            if (this.delegate == null) {
                throw e;
            }
            this.delegate.warning(e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            if (this.delegate == null) {
                throw e;
            }
            this.delegate.error(e);
        }
    }
}

