/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map;

import de.destatis.core.map.Binding;
import de.destatis.core.map.BindingGroup;
import de.destatis.core.map.FieldBinding;
import de.destatis.core.map.FieldGroupBinding;
import de.destatis.core.map.FieldSetBinding;
import de.destatis.core.map.Mapping;
import de.destatis.core.map.MappingXmlConstants;
import de.destatis.core.map.model.HelpFeatureBinding;
import de.destatis.core.map.model.HelpFeatureConfigValue;
import de.destatis.core.map.model.SelectorBinding;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MappingParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mapping parse(File file) throws ParserConfigurationException, SAXException, FactoryConfigurationError, IOException {
        Mapping mapping;
        FileInputStream fIn = null;
        try {
            fIn = new FileInputStream(file);
            mapping = this.parse(fIn);
            try {
                fIn.close();
                fIn = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (fIn != null) {
                try {
                    fIn.close();
                }
                catch (Throwable e) {}
            }
        }
        return mapping;
    }

    public Mapping parse(InputStream in) throws ParserConfigurationException, SAXException, FactoryConfigurationError, IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, MappingXmlConstants.ENCODING));
        Mapping mapping = this.parse(reader);
        return mapping;
    }

    public Mapping parse(Reader reader) throws ParserConfigurationException, SAXException, FactoryConfigurationError, IOException {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        XmlParser xmlParser = new XmlParser();
        parser.parse(new InputSource(reader), (DefaultHandler)xmlParser);
        return xmlParser.getMapping();
    }

    protected static class XmlParser
    extends DefaultHandler {
        private StringBuffer buffer = new StringBuffer();
        private Mapping mapping = null;
        private BindingGroup currentBindingGroup = null;
        protected Binding currentBinding = null;

        public Mapping getMapping() {
            return this.mapping;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.buffer.delete(0, this.buffer.length());
            if (MappingXmlConstants.TAG_MAPPING.equals(qName)) {
                String resourceId = attributes.getValue(MappingXmlConstants.ATTR_RESOURCE_ID);
                if (resourceId == null || resourceId.length() == 0) {
                    throw new SAXException("Keine Ressource-ID angegeben.");
                }
                String name = attributes.getValue(MappingXmlConstants.ATTR_NAME);
                if (name == null || name.length() == 0) {
                    name = resourceId;
                }
                String customName = attributes.getValue(MappingXmlConstants.ATTR_CUSTOM_NAME);
                String helpFeatureStr = attributes.getValue(MappingXmlConstants.ATTR_HELP_FEATURE_CONFIG);
                short helpFeatureShort = Short.parseShort(helpFeatureStr);
                HelpFeatureConfigValue helpFeatureConfig = HelpFeatureConfigValue.getValueById(helpFeatureShort);
                String creationDateStr = attributes.getValue(MappingXmlConstants.ATTR_CREATION_DATE);
                String creationTimeStr = attributes.getValue(MappingXmlConstants.ATTR_CREATION_TIME);
                Date creationDate = null;
                if (creationDateStr != null && creationTimeStr != null) {
                    SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyyHH:mm:ss");
                    try {
                        creationDate = format.parse(creationDateStr + creationTimeStr);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                this.mapping = new Mapping(resourceId, name);
                this.mapping.setCustomName(customName);
                this.mapping.setCreationDate(creationDate);
                this.mapping.setHelpFeatureConfig(helpFeatureConfig);
                this.currentBindingGroup = this.mapping;
                this.currentBinding = this.mapping;
                return;
            }
            if (MappingXmlConstants.TAG_FIELD_BINDING.equals(qName)) {
                String defaultValue;
                String position;
                this.checkMappingCreated();
                String field = attributes.getValue(MappingXmlConstants.ATTR_FIELD);
                if (field == null || field.length() <= 0) throw new SAXException("Kein Feldname angegeben.");
                FieldBinding fieldBinding = this.currentBindingGroup == this.mapping ? new HelpFeatureBinding(field) : new FieldBinding(field);
                String customName = attributes.getValue(MappingXmlConstants.ATTR_CUSTOM_NAME);
                if (customName != null) {
                    fieldBinding.setCustomName(customName);
                }
                if ((position = attributes.getValue(MappingXmlConstants.ATTR_POSITION)) != null) {
                    fieldBinding.setPosition(new Integer(position.trim()));
                }
                if ((defaultValue = attributes.getValue(MappingXmlConstants.ATTR_DEFAULT_VALUE)) != null) {
                    fieldBinding.setDefaultValue(defaultValue);
                }
                this.currentBindingGroup.addBinding(fieldBinding);
                this.currentBinding = fieldBinding;
                return;
            } else if (MappingXmlConstants.TAG_SELECTOR_BINDING.equals(qName)) {
                String defaultValue;
                String position;
                this.checkMappingCreated();
                if (this.currentBindingGroup != this.mapping) {
                    throw new SAXException("Selektorbindings d\u00fcrfen nur unterhalb des Mappings vorkommen.");
                }
                String field = attributes.getValue(MappingXmlConstants.ATTR_FIELD);
                if (field == null || field.length() <= 0) throw new SAXException("Kein Feldname angegeben.");
                SelectorBinding selectorBinding = new SelectorBinding(field);
                String customName = attributes.getValue(MappingXmlConstants.ATTR_CUSTOM_NAME);
                if (customName != null) {
                    selectorBinding.setCustomName(customName);
                }
                if ((position = attributes.getValue(MappingXmlConstants.ATTR_POSITION)) != null) {
                    selectorBinding.setPosition(new Integer(position.trim()));
                }
                if ((defaultValue = attributes.getValue(MappingXmlConstants.ATTR_DEFAULT_VALUE)) != null) {
                    selectorBinding.setDefaultValue(defaultValue);
                }
                this.currentBindingGroup.addBinding(selectorBinding);
                this.currentBinding = selectorBinding;
                return;
            } else if (MappingXmlConstants.TAG_FIELD_GROUP_BINDING.equals(qName)) {
                String quantity;
                this.checkMappingCreated();
                String fieldGroup = attributes.getValue(MappingXmlConstants.ATTR_FIELD_GROUP);
                if (fieldGroup == null || fieldGroup.length() <= 0) throw new SAXException("Kein Feldgruppenname angegeben.");
                FieldGroupBinding fieldGroupBinding = new FieldGroupBinding(fieldGroup);
                String customName = attributes.getValue(MappingXmlConstants.ATTR_CUSTOM_NAME);
                if (customName != null) {
                    fieldGroupBinding.setCustomName(customName);
                }
                if ((quantity = attributes.getValue(MappingXmlConstants.ATTR_QUANTITY)) != null) {
                    fieldGroupBinding.setSize(new Integer(quantity.trim()));
                }
                this.currentBindingGroup.addBinding(fieldGroupBinding);
                this.currentBindingGroup = fieldGroupBinding;
                this.currentBinding = fieldGroupBinding;
                return;
            } else {
                if (!MappingXmlConstants.TAG_FIELD_SET_BINDING.equals(qName)) return;
                this.checkMappingCreated();
                String fieldSet = attributes.getValue(MappingXmlConstants.ATTR_FIELD_SET);
                if (fieldSet == null || fieldSet.length() <= 0) throw new SAXException("Kein Satzname angegeben.");
                FieldSetBinding fieldSetBinding = new FieldSetBinding(fieldSet);
                this.currentBindingGroup.addBinding(fieldSetBinding);
                this.currentBindingGroup = fieldSetBinding;
                this.currentBinding = fieldSetBinding;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.checkMappingCreated();
            if (MappingXmlConstants.TAG_FIELD_GROUP_BINDING.equals(qName) || MappingXmlConstants.TAG_FIELD_SET_BINDING.equals(qName)) {
                this.currentBindingGroup = this.currentBindingGroup.getParent();
                this.currentBinding = this.currentBindingGroup;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.buffer.append(ch, start, length);
        }

        private void checkMappingCreated() throws SAXException {
            if (this.mapping == null) {
                throw new SAXException("Mapping wurde noch nicht erstellt. Falsches Format?");
            }
        }
    }
}

