/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.versions;

import com.atlassian.clover.versions.ComparableVersion;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryVersion
implements Comparable<LibraryVersion> {
    private Integer majorVersion;
    private Integer minorVersion;
    private Integer incrementalVersion;
    private Integer buildNumber;
    private String qualifier;
    private ComparableVersion comparable;

    public LibraryVersion(String version) {
        this.parseVersion(version);
    }

    public int hashCode() {
        return 11 + this.comparable.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LibraryVersion)) {
            return false;
        }
        return this.compareTo((LibraryVersion)other) == 0;
    }

    @Override
    public int compareTo(LibraryVersion otherVersion) {
        return this.comparable.compareTo(otherVersion.comparable);
    }

    public int getMajorVersion() {
        return this.majorVersion != null ? this.majorVersion : 0;
    }

    public int getMinorVersion() {
        return this.minorVersion != null ? this.minorVersion : 0;
    }

    public int getIncrementalVersion() {
        return this.incrementalVersion != null ? this.incrementalVersion : 0;
    }

    public int getBuildNumber() {
        return this.buildNumber != null ? this.buildNumber : 0;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public final void parseVersion(String version) {
        String part1;
        this.comparable = new ComparableVersion(version);
        int index = version.indexOf("-");
        String part2 = null;
        if (index < 0) {
            part1 = version;
        } else {
            part1 = version.substring(0, index);
            part2 = version.substring(index + 1);
        }
        if (part2 != null) {
            try {
                if (part2.length() == 1 || !part2.startsWith("0")) {
                    this.buildNumber = Integer.valueOf(part2);
                } else {
                    this.qualifier = part2;
                }
            }
            catch (NumberFormatException e) {
                this.qualifier = part2;
            }
        }
        if (part1.indexOf(".") < 0 && !part1.startsWith("0")) {
            try {
                this.majorVersion = Integer.valueOf(part1);
            }
            catch (NumberFormatException e) {
                this.qualifier = version;
                this.buildNumber = null;
            }
        } else {
            boolean fallback = false;
            StringTokenizer tok = new StringTokenizer(part1, ".");
            try {
                this.majorVersion = LibraryVersion.getNextIntegerToken(tok);
                if (tok.hasMoreTokens()) {
                    this.minorVersion = LibraryVersion.getNextIntegerToken(tok);
                }
                if (tok.hasMoreTokens()) {
                    this.incrementalVersion = LibraryVersion.getNextIntegerToken(tok);
                }
                if (tok.hasMoreTokens()) {
                    fallback = true;
                }
                if (part1.indexOf("..") >= 0 || part1.startsWith(".") || part1.endsWith(".")) {
                    fallback = true;
                }
            }
            catch (NumberFormatException e) {
                fallback = true;
            }
            if (fallback) {
                this.qualifier = version;
                this.majorVersion = null;
                this.minorVersion = null;
                this.incrementalVersion = null;
                this.buildNumber = null;
            }
        }
    }

    private static Integer getNextIntegerToken(StringTokenizer tok) {
        String s = tok.nextToken();
        if (s.length() > 1 && s.startsWith("0")) {
            throw new NumberFormatException("Number part has a leading 0: '" + s + "'");
        }
        return Integer.valueOf(s);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.majorVersion != null) {
            buf.append(this.majorVersion);
        }
        if (this.minorVersion != null) {
            buf.append(".");
            buf.append(this.minorVersion);
        }
        if (this.incrementalVersion != null) {
            buf.append(".");
            buf.append(this.incrementalVersion);
        }
        if (this.buildNumber != null) {
            buf.append("-");
            buf.append(this.buildNumber);
        } else if (this.qualifier != null) {
            if (buf.length() > 0) {
                buf.append("-");
            }
            buf.append(this.qualifier);
        }
        return buf.toString();
    }
}

