/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.remote;

import com.atlassian.clover.ErrorInfo;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class RpcMessage
implements Serializable {
    public static final long serialVersionUID = 1L;
    private final Integer methodId;
    private final Object[] methodArgs;
    public static final int METHOD_START = 1;
    public static final int METHOD_END = 2;
    private static final Map<Integer, MethodDescriptor> METHODS = new HashMap<Integer, MethodDescriptor>();

    public RpcMessage(Integer methodId, Object ... methodArgs) {
        this.methodId = methodId;
        this.methodArgs = methodArgs;
    }

    public RpcMessage() {
        this.methodId = null;
        this.methodArgs = null;
    }

    public String getName() {
        MethodDescriptor desc = METHODS.get(this.methodId);
        return desc.name;
    }

    public Object[] getMethodArgs() {
        return this.methodArgs;
    }

    static {
        METHODS.put(1, new MethodDescriptor("allRecordersSliceStart", String.class, Integer.TYPE, Long.TYPE));
        METHODS.put(2, new MethodDescriptor("allRecordersSliceEnd", String.class, String.class, Integer.TYPE, Integer.TYPE, ErrorInfo.class));
    }

    static class MethodDescriptor {
        final String name;
        final Class[] argTypes;

        MethodDescriptor(String name, Class ... argTypes) {
            this.name = name;
            this.argTypes = argTypes;
        }
    }
}

