/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant;

import com.atlassian.clover.Contract;
import com.atlassian.clover.Logger;
import com.atlassian.clover.ant.tasks.AntInstrumentationConfig;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntInstrUtils {
    public static final String JAVA_IO_TMPDIR = "java.io.tmpdir";

    public static String getProp(Project project, String key, String defaultValue) {
        Contract.pre(key != null);
        String prop = project.getProperty(key);
        if (prop == null) {
            prop = defaultValue;
        }
        return prop;
    }

    public static PatternSet calcInstrPatternSet(Project project) {
        AntInstrumentationConfig config;
        String includes = AntInstrUtils.getProp(project, "clover.includes", "");
        String excludes = AntInstrUtils.getProp(project, "clover.excludes", "");
        PatternSet instrPatternSet = null;
        if (includes.length() > 0 || excludes.length() > 0) {
            instrPatternSet = new PatternSet();
            if (includes.length() > 0) {
                instrPatternSet.setIncludes(includes);
            } else {
                instrPatternSet.setIncludes("**");
            }
            if (excludes.length() > 0) {
                instrPatternSet.setExcludes(excludes);
            }
        }
        if ((config = AntInstrumentationConfig.getFrom(project)) != null && config.getInstrPattern() != null) {
            if (instrPatternSet != null) {
                Logger.getInstance().warn("Sub-element <files> of <clover-setup> overrides clover.includes/excludes properties.");
            }
            instrPatternSet = config.getInstrPattern();
        }
        return instrPatternSet;
    }

    public static List<FileSet> calcInstrFileSets(Project project) {
        AntInstrumentationConfig config = AntInstrumentationConfig.getFrom(project);
        return config != null ? config.getInstrFilesets() : null;
    }

    public static File createInstrDir(File basedir) throws CloverException {
        File tmpDir;
        try {
            String property = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(AntInstrUtils.JAVA_IO_TMPDIR);
                }
            });
            if (property == null) {
                throw new CloverException("No java.io.tmpdir system property set. Please ensure this property is set before executing Clover.");
            }
            File tempDir = new File(property);
            if (!tempDir.exists()) {
                throw new CloverException("The java.io.tmpdir directory '" + tempDir + "' does not exist. Please ensure this is created.");
            }
            if (!tempDir.canRead()) {
                throw new CloverException("The java.io.tmpdir directory '" + tempDir + "' can not be read from. Please ensure it has appropriate permissions.");
            }
            if (!tempDir.canWrite()) {
                throw new CloverException("The java.io.tmpdir directory '" + tempDir + "' can not be written to. Please ensure it has appropriate permissions.");
            }
            if (basedir != null) {
                if (!basedir.isDirectory() && !basedir.mkdirs()) {
                    throw new CloverException("Failed to create temp directory '" + basedir + "'");
                }
                tmpDir = File.createTempFile("clover", null, basedir);
            } else {
                tmpDir = File.createTempFile("clover", null);
            }
            tmpDir.delete();
            if (!tmpDir.mkdirs() && !tmpDir.isDirectory()) {
                throw new CloverException("Failed to create temp directory: '" + basedir + "'");
            }
        }
        catch (IOException e) {
            throw new CloverException("Failed to create temp directory: '" + basedir + "'", e);
        }
        return tmpDir;
    }

    public static void cleanUpInstrDir(File tmpDir, boolean preserveInstr) {
        if (!preserveInstr && tmpDir != null) {
            FileUtils.deltree(tmpDir);
        }
    }

    public static void sieveSourceForInstrumentation(Project project, Path srcPath, PatternSet instrPatternSet, List<FileSet> instrFileSetsList, Collection<File> toCompile, Collection<File> toCopy, Collection<File> toInstrument) {
        if (instrFileSetsList == null && instrPatternSet == null) {
            Logger.getInstance().verbose("No <files/> nor <fileset/> elements found in <clover-setup/> - instrumenting all source found.");
            toCopy.clear();
            toInstrument.addAll(toCompile);
        } else if (instrPatternSet != null) {
            Logger.getInstance().verbose("<files/> element found in <clover-setup/> - filtering source found in" + Arrays.asList(srcPath.list()));
            for (String srcDir : srcPath.list()) {
                AntInstrUtils.sieveSrcPath(project, instrPatternSet, toCompile, toCopy, toInstrument, srcDir);
            }
        } else {
            Logger.getInstance().verbose("<fileset/> element(s) found in <clover-setup/>");
            for (FileSet fileSet : instrFileSetsList) {
                DirectoryScanner ds = fileSet.getDirectoryScanner(project);
                File baseDir = fileSet.getDir(project);
                Logger.getInstance().verbose("Filtering source files found in " + baseDir.getAbsolutePath());
                String[] included = ds.getIncludedFiles();
                if (included.length > 0) {
                    for (int j = 0; j < included.length; ++j) {
                        File inc = new File(baseDir, included[j]);
                        Logger.getInstance().verbose("Found file for instrumentation: " + inc.getAbsolutePath());
                        if (toCompile.contains(inc)) {
                            toInstrument.add(inc);
                            toCopy.remove(inc);
                        } else {
                            Logger.getInstance().verbose("File " + inc.getAbsolutePath() + " not in original compile list - ignoring");
                        }
                        toCompile.remove(inc);
                    }
                } else {
                    Logger.getInstance().verbose("No sources found");
                }
                String[] excluded = ds.getExcludedFiles();
                if (excluded.length > 0) {
                    for (int j = 0; j < excluded.length; ++j) {
                        File exc = new File(baseDir, excluded[j]);
                        Logger.getInstance().verbose("Found file to exclude from instrumentation: " + exc.getAbsolutePath());
                        if (toCompile.contains(exc)) {
                            toInstrument.remove(exc);
                            toCopy.add(exc);
                        } else {
                            Logger.getInstance().verbose("File " + exc.getAbsolutePath() + " not in original compile list - ignoring");
                        }
                        toCompile.remove(exc);
                    }
                    continue;
                }
                Logger.getInstance().verbose("No sources found");
            }
            if (toCompile.size() > 0) {
                Logger.getInstance().verbose(toCompile.size() + " file(s) in the compile list were neither included or excluded for Clover instrumentation. Adding to the exclude list:");
                for (File file : toCompile) {
                    Logger.getInstance().verbose(file.getAbsolutePath());
                }
                toCopy.addAll(toCompile);
            }
        }
    }

    public static void sieveSrcPath(Project project, PatternSet instrPatternSet, Collection<File> toCompile, Collection<File> toCopy, Collection<File> toInstrument, String srcDir) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(srcDir);
        ds.setIncludes(instrPatternSet.getIncludePatterns(project));
        ds.setExcludes(instrPatternSet.getExcludePatterns(project));
        ds.scan();
        String[] included = ds.getIncludedFiles();
        for (int j = 0; j < included.length; ++j) {
            File inc = new File(srcDir, included[j]);
            if (!toCompile.contains(inc)) continue;
            toInstrument.add(inc);
            toCopy.remove(inc);
        }
        String[] excluded = ds.getExcludedFiles();
        for (int j = 0; j < excluded.length; ++j) {
            File exc = new File(srcDir, excluded[j]);
            if (!toCompile.contains(exc)) continue;
            toInstrument.remove(exc);
            toCopy.add(exc);
        }
    }
}

