/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.tree.TreeTableIdManager;
import de.memtext.util.StringUtils;
import de.superx.common.SuperX_el;
import de.superx.common.SxResultRow;
import de.superx.util.SqlStringUtils;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

class XMLResultCreator {
    private SuperX_el result_el;
    private int maxOffset;
    private int offset;
    private String mandantenID;
    private TreeTableIdManager treeTableIdManger = new TreeTableIdManager();
    private String desiredRows = "all";

    XMLResultCreator(SuperX_el result_el, int maxOffset, int offset, String mandantenID) {
        this.result_el = result_el;
        this.maxOffset = maxOffset;
        this.offset = offset;
        this.mandantenID = mandantenID;
    }

    public void setDesiredRows(String desiredRows) {
        this.desiredRows = "," + desiredRows;
    }

    private void addSingleColumn(StringBuffer result, SxResultRow row, int trueColumn, int relativeColNo) {
        String f_name = this.result_el.getColumnNames()[trueColumn];
        String f_wert = "";
        int f_typ = this.result_el.getColumnTypes()[trueColumn];
        try {
            f_wert = SqlStringUtils.getValueAsString(row.get(trueColumn));
        }
        catch (Exception e2) {
            Logger.getLogger("superx_" + this.mandantenID).log(Level.SEVERE, String.valueOf(e2.toString()) + ": " + result.toString());
            f_wert = "";
        }
        if (f_wert != null) {
            f_wert = "<![CDATA[" + f_wert.trim() + "]]>";
        }
        result.append("<col id=\"" + relativeColNo + "\" typ=\"" + f_typ + "\">\n<f_name>" + f_name + "</f_name>\n<wert>" + f_wert + "</wert>\n</col>\n");
    }

    public void addXML(StringBuffer buf, String colset, boolean isEbenenWanted, String treetableid, int rowkids) {
        if (treetableid == null) {
            treetableid = "";
        }
        int anzahl = 0;
        int ebenenCol = -1;
        int previousLevel = 999;
        int minEbene = 0;
        int currentLevel = 0;
        int outputRowCount = 0;
        int rowno = 0;
        boolean checkNextRow = false;
        boolean addKidRows = false;
        int requiredKidRowLevel = 0;
        if (isEbenenWanted) {
            this.treeTableIdManger.reset();
            ebenenCol = this.result_el.getTrueColumnNumber("ebene");
            minEbene = this.result_el.getMinEbene();
            this.treeTableIdManger.setMinLevel(minEbene);
        }
        int currentRowNo = 0;
        for (SxResultRow row : this.result_el.getResultSet()) {
            ++currentRowNo;
            if (isEbenenWanted) {
                Object ebene = row.get(ebenenCol);
                currentLevel = minEbene;
                if (ebene != null) {
                    currentLevel = Integer.parseInt(ebene.toString());
                }
                if (addKidRows && currentLevel < requiredKidRowLevel) {
                    outputRowCount = 0;
                    addKidRows = false;
                }
                if (currentRowNo == rowkids) {
                    requiredKidRowLevel = currentLevel + 1;
                    addKidRows = true;
                }
                if (checkNextRow) {
                    if (previousLevel < currentLevel) {
                        StringUtils.replace(buf, "ISFOLDER", "true");
                    } else {
                        StringUtils.replace(buf, "ISFOLDER", "false");
                    }
                    checkNextRow = false;
                }
            }
            if (!(isEbenenWanted && rowkids == -1 && currentLevel == minEbene || isEbenenWanted && addKidRows && currentLevel == requiredKidRowLevel) && (isEbenenWanted || !this.isCurrentRowWanted(currentRowNo) || currentRowNo <= this.offset || currentRowNo > this.maxOffset + this.offset)) continue;
            buf.append("<row no=\"" + rowno + "\" ");
            ++rowno;
            if (isEbenenWanted) {
                buf.append(" treeindent=\"" + (currentLevel - minEbene) + "\"");
                previousLevel = currentLevel;
                buf.append(" treetableid=\"" + treetableid + "_" + outputRowCount + "\"");
                ++outputRowCount;
                buf.append(" isfolder=\"ISFOLDER\" internalrowno=\"" + currentRowNo + "\"");
                checkNextRow = true;
            }
            buf.append(">\n");
            ++anzahl;
            if (colset != null && !colset.trim().equals("") && !colset.trim().equalsIgnoreCase("restore")) {
                StringTokenizer st = new StringTokenizer(colset, "|");
                int colno = 0;
                while (st.hasMoreTokens()) {
                    int trueColumn = this.result_el.getTrueColumnNumber(st.nextToken());
                    this.addSingleColumn(buf, row, trueColumn, colno);
                    ++colno;
                }
            } else {
                int s = 0;
                while (s < this.result_el.getColumnCount()) {
                    this.addSingleColumn(buf, row, s, s);
                    ++s;
                }
            }
            buf.append("</row>\n");
        }
        if (isEbenenWanted) {
            StringUtils.replace(buf, "ISFOLDER", "false");
        }
        if (anzahl == 1) {
            buf.append("<msg>Insgesamt 1 Satz gefunden</msg>\n");
        } else {
            buf.append("<msg>Insgesamt " + anzahl + " S\u00e4tze gefunden</msg>\n");
        }
    }

    private boolean isCurrentRowWanted(int currentRowNo) {
        boolean result = false;
        if (this.desiredRows.equals("all") || this.desiredRows.indexOf("," + currentRowNo + ",") > -1) {
            result = true;
        }
        return result;
    }

    public StringBuffer getXMLClassic(String colset, boolean isEbenenWanted) {
        StringBuffer result = new StringBuffer();
        int anzahl = 0;
        int ebenenCol = -1;
        int previousLevel = 999;
        int minEbene = 0;
        if (isEbenenWanted) {
            this.treeTableIdManger.reset();
            ebenenCol = this.result_el.getTrueColumnNumber("ebene");
            minEbene = this.result_el.getMinEbene();
            this.treeTableIdManger.setMinLevel(minEbene);
        }
        int currentRowNo = 0;
        for (SxResultRow row : this.result_el.getResultSet()) {
            if (++currentRowNo < this.offset || currentRowNo >= this.maxOffset + this.offset) continue;
            result.append("<row");
            if (isEbenenWanted) {
                Object ebene = row.get(ebenenCol);
                int level = minEbene;
                if (ebene != null) {
                    level = Integer.parseInt(ebene.toString());
                }
                if (previousLevel < level) {
                    StringUtils.replace(result, "ISFOLDER", "true");
                } else {
                    StringUtils.replace(result, "ISFOLDER", "false");
                }
                result.append(" treeindent=\"" + (level - minEbene) + "\"");
                previousLevel = level;
                result.append(" treetableid=\"" + this.treeTableIdManger.getTreeTableId(level) + "\"");
                result.append(" isfolder=\"ISFOLDER\"");
            }
            result.append(">\n");
            ++anzahl;
            if (colset != null && !colset.trim().equals("") && !colset.trim().equalsIgnoreCase("restore")) {
                StringTokenizer st = new StringTokenizer(colset, "|");
                int colno = 0;
                while (st.hasMoreTokens()) {
                    int trueColumn = this.result_el.getTrueColumnNumber(st.nextToken());
                    this.addSingleColumn(result, row, trueColumn, colno);
                }
            } else {
                int s = 0;
                while (s < this.result_el.getColumnCount()) {
                    this.addSingleColumn(result, row, s, s);
                    ++s;
                }
            }
            result.append("</row>\n");
        }
        if (isEbenenWanted) {
            StringUtils.replace(result, "ISFOLDER", "false");
        }
        if (anzahl == 1) {
            result.append("<msg>Insgesamt 1 Satz gefunden</msg>\n");
        } else {
            result.append("<msg>Insgesamt " + anzahl + " S\u00e4tze gefunden</msg>\n");
        }
        return result;
    }
}

