/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private StringUtils() {
    }

    public static String javascriptUmlautAdapt(String in) {
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < in.length()) {
            char ch = in.charAt(i2);
            switch (ch) {
                case '\u00e4': {
                    sb.append("\\344");
                    break;
                }
                case '\u00c4': {
                    sb.append("\\304");
                    break;
                }
                case '\u00f6': {
                    sb.append("\\366");
                    break;
                }
                case '\u00d6': {
                    sb.append("\\326");
                    break;
                }
                case '\u00fc': {
                    sb.append("\\374");
                    break;
                }
                case '\u00dc': {
                    sb.append("\\334");
                    break;
                }
                case '\u00df': {
                    sb.append("\\337");
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i2;
        }
        return sb.toString();
    }

    public static String jsonAdapt(String in, boolean isJavascriptUmlautEncodingWanted) {
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < in.length()) {
            char ch = in.charAt(i2);
            switch (ch) {
                case '\u00e4': {
                    if (isJavascriptUmlautEncodingWanted) {
                        sb.append("\\344");
                        break;
                    }
                    sb.append("\u00e4");
                    break;
                }
                case '\u00c4': {
                    if (isJavascriptUmlautEncodingWanted) {
                        sb.append("\\304");
                        break;
                    }
                    sb.append("\u00c4");
                    break;
                }
                case '\u00f6': {
                    if (isJavascriptUmlautEncodingWanted) {
                        sb.append("\\366");
                        break;
                    }
                    sb.append("\u00f6");
                    break;
                }
                case '\u00d6': {
                    if (isJavascriptUmlautEncodingWanted) {
                        sb.append("\\326");
                        break;
                    }
                    sb.append("\u00d6");
                    break;
                }
                case '\u00fc': {
                    if (isJavascriptUmlautEncodingWanted) {
                        sb.append("\\374");
                        break;
                    }
                    sb.append("\u00fc");
                    break;
                }
                case '\u00dc': {
                    if (isJavascriptUmlautEncodingWanted) {
                        sb.append("\\334");
                        break;
                    }
                    sb.append("\u00dc");
                    break;
                }
                case '\u00df': {
                    if (isJavascriptUmlautEncodingWanted) {
                        sb.append("\\337");
                        break;
                    }
                    sb.append("\u00df");
                    break;
                }
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '/': {
                    sb.append("\\/");
                    break;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        int k2 = 0;
                        while (k2 < 4 - ss.length()) {
                            sb.append('0');
                            ++k2;
                        }
                        sb.append(ss.toUpperCase());
                        break;
                    }
                    sb.append(ch);
                }
            }
            ++i2;
        }
        String result = sb.toString();
        if (isJavascriptUmlautEncodingWanted) {
            result = StringUtils.javascriptUmlautAdapt(result);
        }
        return result;
    }

    public static void replace(StringBuffer buf, String token, String newval) {
        if (token == null) {
            throw new IllegalArgumentException("Token must not be null");
        }
        if (newval == null) {
            throw new IllegalArgumentException("newval must not be null");
        }
        if (token.equals(newval)) {
            throw new IllegalArgumentException("token and newval must not be equal");
        }
        boolean replaced = false;
        int start = 0;
        while (!replaced) {
            start = buf.toString().indexOf(token, start);
            switch (start) {
                case -1: {
                    replaced = true;
                    break;
                }
                default: {
                    int end = start + token.length();
                    buf.replace(start, end, newval);
                    start += newval.length();
                }
            }
        }
    }

    public static String nvl(String input, String nvl) {
        if (input == null) {
            return nvl;
        }
        return input;
    }

    public static String readFile(File f2) throws IOException {
        String line;
        FileReader fr = new FileReader(f2);
        BufferedReader bfr = new BufferedReader(fr);
        StringBuffer result = new StringBuffer();
        while ((line = bfr.readLine()) != null) {
            result.append(String.valueOf(line) + "\n");
        }
        bfr.close();
        fr.close();
        return result.toString();
    }

    public static void write(File f2, String text) throws IOException {
        FileWriter fw = new FileWriter(f2);
        BufferedWriter bfw = new BufferedWriter(fw);
        bfw.write(text);
        bfw.close();
        fw.close();
    }

    public static boolean containsTags(String source) {
        boolean result = false;
        if (source != null) {
            int startpos = 0;
            while (source.indexOf("<", startpos) > -1) {
                int tagend = source.indexOf(">", startpos = source.indexOf("<", startpos));
                if (tagend > -1 && tagend > startpos + 1 && source.substring(startpos, tagend).indexOf(" ") == -1) {
                    result = true;
                    break;
                }
                if (tagend > -1) {
                    startpos = tagend + 1;
                    continue;
                }
                ++startpos;
            }
            if (source.indexOf("javascript") > -1) {
                result = true;
            }
            if (source.indexOf("\u0000") > -1) {
                result = true;
            }
        }
        return result;
    }

    public static String replace(String text, String token, String newval) {
        StringBuffer buf = new StringBuffer(text);
        StringUtils.replace(buf, token, newval);
        return buf.toString();
    }

    public static Character getLastNonSpaceChar(String txt) {
        Character result = null;
        int pos = txt.length() - 1;
        while (pos > -1) {
            if (txt.charAt(pos) != ' ') {
                result = new Character(txt.charAt(pos));
                break;
            }
            --pos;
        }
        return result;
    }

    public static char getLastChar(StringBuffer buf) {
        if (buf == null || buf.length() == 0) {
            throw new IllegalArgumentException("Leerer Buffer");
        }
        return buf.charAt(buf.length() - 1);
    }

    public static void deleteLastChar(StringBuffer buf) {
        if (buf.length() > 0) {
            buf.deleteCharAt(buf.length() - 1);
        }
    }

    public static String deleteLastChar(String txt) {
        String result = txt;
        if (txt.length() > 0) {
            result = txt.substring(0, txt.length() - 1);
        }
        return result;
    }

    public static LinkedList getStringTokenizedList(String source, String delim) {
        LinkedList<String> result = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(source, delim);
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            result.add(next);
        }
        return result;
    }

    public static String toCommaList(Collection c2) {
        StringBuffer msg = new StringBuffer();
        for (Object o : c2) {
            msg.append(o + ",");
        }
        if (msg.length() > 1) {
            StringUtils.removeFromEnd(msg, ",", true);
        }
        return msg.toString();
    }

    public static void printInt(String x) {
        char ch;
        int i2 = 0;
        while (i2 < x.length()) {
            ch = x.charAt(i2);
            System.out.print(String.valueOf(x.charAt(i2)) + ",");
            ++i2;
        }
        i2 = 0;
        while (i2 < x.length()) {
            ch = x.charAt(i2);
            System.out.print(String.valueOf((int)ch) + ",");
            ++i2;
        }
    }

    public static String trimLength(String input, int len) {
        if (input != null) {
            input = input.substring(0, Math.min(len, input.length()));
        }
        return input;
    }

    public static void main(String[] a2) {
        String sql = "aaa<table id=\"customheader\" border=\"0\" width=\"100%\"> \n<colgroup> \n    <col width=\"90%\"/> \n    <col width=\"10%\"/> \n      </colgroup> \n  <tr><td align=\"center\"></table>bbb\n<table> 2 </table> ";
        Pattern p = Pattern.compile("<table id=\"customheader\".*?</table>", 32);
        Matcher action = p.matcher(sql);
        String worldwide = action.replaceAll("");
        System.out.println(worldwide);
    }

    public static int count(String base, String searchFor) {
        int pos = base.indexOf(searchFor);
        int result = 0;
        while (pos > -1) {
            ++result;
            pos = pos < base.length() - 1 ? base.indexOf(searchFor, pos + searchFor.length()) : -1;
        }
        return result;
    }

    public static void removeFromEnd(StringBuffer source, String removeIt, boolean isExceptionWanted) {
        if (source.length() < removeIt.length()) {
            throw new IllegalArgumentException("Source: " + source + " is shorter than " + removeIt);
        }
        if (isExceptionWanted && !source.substring(source.length() - removeIt.length()).equals(removeIt)) {
            throw new IllegalArgumentException("Source: " + source + " doesn't end with " + removeIt);
        }
        source.setLength(source.length() - removeIt.length());
    }

    public static String removeFromEnd(String source, String removeIt, boolean isExceptionWanted) {
        if (source.length() < removeIt.length()) {
            throw new IllegalArgumentException("Source: " + source + " is shorter than " + removeIt);
        }
        if (isExceptionWanted && !source.endsWith(removeIt)) {
            throw new IllegalArgumentException("Source: " + source + " doesn't end with " + removeIt);
        }
        return source.substring(0, source.length() - removeIt.length());
    }

    public static void removeLastChar(StringBuffer buf) {
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
    }

    public static String filterOutput(String output) {
        if (output != null) {
            output = StringUtils.replace(output, "&", "&amp;");
            output = StringUtils.replace(output, "<", "&lt;");
            output = StringUtils.replace(output, ">", "&gt;");
            output = StringUtils.replace(output, "\"", "&quot;");
            output = StringUtils.replace(output, "'", "&#39;");
        }
        return output;
    }
}

