/*
 * Decompiled with CFR 0.152.
 */
package de.joolap.servlet;

import de.joolap.servlet.JoolapPool;
import de.joolap.servlet.ServletMetaDataRequest;
import de.joolap.servlet.ServletResultSet;
import de.memtext.db.MemtextPools;
import de.memtext.db.NichtAngemeldetException;
import de.memtext.util.CryptUtils;
import de.memtext.util.ServletHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.RichTextString;

public class JoolapExcelServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static String loglevel = "none";
    private Exception startException = null;
    private static String path = null;
    private static File datasourceFile = null;
    private static MemtextPools pools;
    private static final String nameAppendix = "-joolap";

    public void init(ServletConfig config) throws ServletException {
        path = config.getServletContext().getRealPath("");
        datasourceFile = new File(String.valueOf(path) + File.separator + "WEB-INF" + File.separator + "joolapexceldatasource.xml");
        if (!datasourceFile.exists()) {
            this.startException = new IOException(datasourceFile + " not found");
        }
        System.setProperty("sql2excel.home", String.valueOf(path) + File.separator + "WEB-INF");
        pools = new MemtextPools();
        try {
            pools.init("WEB-INF" + File.separator + "joolapdbprops", JoolapPool.class, nameAppendix);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            this.startException = e2;
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block5: {
            JoolapExcelServletHelper jsh = null;
            try {
                ObjectInputStream inputFromApplet = new ObjectInputStream((InputStream)request.getInputStream());
                Object input = inputFromApplet.readObject();
                String signature = (String)inputFromApplet.readObject();
                jsh = new JoolapExcelServletHelper(request, response);
                if (input instanceof String && input.toString().startsWith("mphjo")) {
                    jsh.login(CryptUtils.simpleDecryptString2(input.toString().substring(6)));
                } else {
                    jsh.run(input, signature);
                }
            }
            catch (Exception e2) {
                if (!(e2 instanceof NichtAngemeldetException)) {
                    e2.printStackTrace();
                }
                if (jsh == null) break block5;
                jsh.sendBackObject(e2);
            }
        }
    }

    private void post2() {
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getParameter("log") != null) {
            loglevel = request.getParameter("log");
        }
        PrintWriter output = response.getWriter();
        response.setContentType("text/html; charset=ISO-8859-1");
        if (this.startException == null) {
            output.write("<html><body><h2>JoolapExcelServlet running</h2>" + new Date());
            output.write("<form action=\"/superx/servlet/JoolapExcelServlet\" method=\"post\">");
            output.write("<p>Content</p>  <textarea name=\"content\" cols=\"50\" rows=\"10\"></textarea>");
            output.write("<input type=\"submit\" value=\"Absenden\">");
            output.write("</form>");
        } else {
            output.write("<html><body><h2>Sql2ExcelServlet - es ist ein Fehler beim Starten aufgetreten </h2><p>" + this.startException + "<br>Kontrollieren Sie die Tomcat-Logdatei catalina.out<br></p>");
        }
        output.write("log ist " + loglevel == null ? "aus" : "an");
        output.write("</body></html>");
        output.flush();
        output.close();
    }

    public void destroy() {
        super.destroy();
    }

    public String getServletInfo() {
        return "Sql2ExcelServlet";
    }

    private class JoolapExcelServletHelper
    extends ServletHelper {
        public JoolapExcelServletHelper(HttpServletRequest request, HttpServletResponse response) throws IOException {
            super(request, response, "joolap");
        }

        private void login(String params) throws IOException {
            block10: {
                try {
                    int pos = params.indexOf("|");
                    String mandantenId = params.substring(0, pos);
                    int pos2 = params.indexOf("|", pos + 1);
                    int pos3 = params.indexOf("|", pos2 + 1);
                    String username = params.substring(pos + 1, pos2);
                    String cryptPassword = params.substring(pos2 + 1, pos3);
                    String cryptPassword2 = params.substring(pos3 + 1);
                    if (this.request.getRemoteUser() != null) {
                        username = this.request.getRemoteUser();
                    }
                    ResultSet rs = (ResultSet)this.execute(mandantenId, "select passwd_sha from userinfo where benutzer = '" + username + "';");
                    String theTruth = null;
                    while (rs.next()) {
                        theTruth = rs.getString(1);
                    }
                    rs.close();
                    if (theTruth == null) {
                        throw new NichtAngemeldetException("Kein User " + username + " gefunden");
                    }
                    if (this.request.getRemoteUser() != null || cryptPassword.equals(theTruth) || cryptPassword2.equals(theTruth)) {
                        HttpSession session = null;
                        if (this.request.getRemoteUser() == null) {
                            session = this.request.getSession(true);
                            session.setAttribute("sessiontype", (Object)"joolap");
                        } else {
                            session.setAttribute("joolapremoteuser", (Object)"true");
                        }
                        session.setAttribute("MandantenID", (Object)mandantenId);
                        String sendback = "jsessionid" + this.getJSessionId() + "|";
                        if (pools.get(String.valueOf(this.getMandantenID()) + JoolapExcelServlet.nameAppendix).hasDSAHandler()) {
                            sendback = String.valueOf(sendback) + pools.get(String.valueOf(this.getMandantenID()) + JoolapExcelServlet.nameAppendix).getPrivateKey();
                        }
                        this.sendBackObject(sendback);
                        break block10;
                    }
                    throw new NichtAngemeldetException("Falsches Passwort");
                }
                catch (Exception e2) {
                    if (!(e2 instanceof NichtAngemeldetException)) {
                        e2.printStackTrace();
                    }
                    this.sendBackObject(e2);
                }
            }
        }

        private Object execute(String mandantenID, String sql) throws Exception {
            Connection dbConnection = pools.getConnection(String.valueOf(mandantenID) + JoolapExcelServlet.nameAppendix);
            Integer result = null;
            try {
                Statement stm = dbConnection.createStatement();
                if (sql.startsWith("!!update!!")) {
                    result = new Integer(stm.executeUpdate(sql.substring(10)));
                } else {
                    ResultSet rs = stm.executeQuery(sql);
                    result = new ServletResultSet(rs);
                    rs.close();
                }
                stm.close();
                dbConnection.close();
            }
            catch (SQLException e2) {
                pools.invalidate(mandantenID, dbConnection);
                e2.printStackTrace();
                throw new SQLException(e2.toString());
            }
            catch (Exception e3) {
                pools.invalidate(mandantenID, dbConnection);
                e3.printStackTrace();
                throw new Exception(e3.toString());
            }
            return result;
        }

        private HSSFWorkbook getExelWorkbook(String mandantenID, String sql) throws Exception {
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.createSheet("Test-Sheet");
            HSSFRow row = sheet.createRow(0);
            HSSFFont fontUeberschrift = workbook.createFont();
            fontUeberschrift.setFontName("Arial");
            HSSFCellStyle cellStyleUeberschrift = workbook.createCellStyle();
            HSSFCell cell = row.createCell((short)0);
            cell.setCellValue((RichTextString)new HSSFRichTextString("Ueberschrift Spalte MB1"));
            cell.setCellStyle((CellStyle)cellStyleUeberschrift);
            cellStyleUeberschrift.setFont(fontUeberschrift);
            return workbook;
        }

        private void sendBackObject(Object result) throws IOException {
            ObjectOutputStream outputToApplet = new ObjectOutputStream((OutputStream)this.response.getOutputStream());
            outputToApplet.writeObject(result);
            outputToApplet.flush();
            outputToApplet.close();
        }

        @Override
        protected void checkSessionType() throws NichtAngemeldetException {
            HttpSession session = this.request.getSession();
            if (session == null) {
                throw new NichtAngemeldetException();
            }
            if (this.request.getRemoteUser() == null) {
                Object test = session.getAttribute("sessiontype");
                if (test == null || !test.toString().equals("joolap")) {
                    throw new NichtAngemeldetException("Fehlender oder falscher Sessiontyp");
                }
            } else if (session.getAttribute("joolapremoteuser") == null || !session.getAttribute("joolapremoteuser").equals("true")) {
                throw new NichtAngemeldetException("Keine Joolap-Berechtigung f\u00fcr RemoteUser gefunden");
            }
        }

        public void run(Object input, String signature) throws Exception {
            String username = this.request.getRemoteUser();
            if (username == null) {
                this.checkSessionType();
            }
            byte[] ret = null;
            if (input instanceof String) {
                String sql = (String)input;
                if (pools.get(String.valueOf(this.getMandantenID()) + JoolapExcelServlet.nameAppendix).hasDSAHandler() && !pools.get(String.valueOf(this.getMandantenID()) + JoolapExcelServlet.nameAppendix).verifiy(sql, signature)) {
                    throw new NichtAngemeldetException("DSA-Kontrolle fehlgeschlagen");
                }
                sql = CryptUtils.simpleDecryptString2((String)input);
                HSSFWorkbook wb = this.getExelWorkbook(this.getMandantenID(), sql);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                wb.write((OutputStream)out);
                byte[] b2 = out.toByteArray();
                out.close();
                ret = b2;
            }
            this.sendBackObject(ret);
        }

        private String getMandantenID() throws NichtAngemeldetException {
            String mandantenId = (String)this.request.getSession().getAttribute("MandantenID");
            if (mandantenId == null) {
                throw new NichtAngemeldetException("keine MandantenID gefunden");
            }
            return mandantenId;
        }

        private ResultSet getMeta(String mandantenID, ServletMetaDataRequest request) throws Exception {
            ServletResultSet result = null;
            Connection dbConnection = pools.getConnection(String.valueOf(mandantenID) + JoolapExcelServlet.nameAppendix);
            ResultSet rs = null;
            try {
                if (request.getName().equals("getTables")) {
                    rs = dbConnection.getMetaData().getTables(null, null, null, null);
                } else if (request.getName().equals("getColumns")) {
                    rs = dbConnection.getMetaData().getColumns(request.getParamString(0), request.getParamString(1), request.getParamString(2), request.getParamString(3));
                } else {
                    throw new UnsupportedOperationException(request.getName());
                }
                result = new ServletResultSet(rs);
                rs.close();
                dbConnection.close();
            }
            catch (SQLException e2) {
                pools.invalidate(mandantenID, dbConnection);
                e2.printStackTrace();
                throw new SQLException(e2.toString());
            }
            catch (Exception e3) {
                pools.invalidate(mandantenID, dbConnection);
                e3.printStackTrace();
                throw new Exception(e3.toString());
            }
            return result;
        }

        @Override
        protected void perform() throws Exception {
        }
    }
}

