/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime;

import de.statspez.pleditor.generator.runtime.NumberValue;
import de.statspez.pleditor.generator.runtime.PlausiRuntimeIterator;
import de.statspez.pleditor.generator.runtime.Range;
import de.statspez.pleditor.generator.runtime.SequenceIterator;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.ValueConversionException;
import java.math.BigDecimal;

public class SequenceRange
extends Range {
    private Value first = null;
    private Value second = null;
    private Value last = null;

    public SequenceRange(Value first, Value second, Value last) {
        this.first = first;
        this.second = second;
        this.last = last;
        if (second.lt(first) && last.gt(second)) {
            throw new RuntimeException("Ungueltige Sequenz: der letzte Wert ist groesser als der zweite Wert.");
        }
        if (second.gt(first) && last.lt(second)) {
            throw new RuntimeException("Ungueltige Sequenz: der letzte Wert ist kleiner als der zweite Wert.");
        }
        if (second.asDouble() - first.asDouble() == 0.0) {
            throw new RuntimeException("Ungueltige Sequenz: die Schrittweite ist 0.");
        }
    }

    public Value first() {
        return this.first;
    }

    public Value second() {
        return this.second;
    }

    public Value last() {
        return this.last;
    }

    @Override
    public PlausiRuntimeIterator iterator() {
        return new SequenceIterator(this);
    }

    @Override
    public double asDouble() throws ValueConversionException {
        double result = 0.0;
        PlausiRuntimeIterator it = this.iterator();
        while (it.hasNext()) {
            result += ((Value)it.next()).asDouble();
        }
        return result;
    }

    @Override
    public long asLong() throws ValueConversionException {
        long result = 0L;
        PlausiRuntimeIterator it = this.iterator();
        while (it.hasNext()) {
            result += ((Value)it.next()).asLong();
        }
        return result;
    }

    @Override
    public boolean asBoolean() throws ValueConversionException {
        throw new ValueConversionException("Der boolsche Wert eines Intervalls  kann nicht ermittelt werden!");
    }

    @Override
    public String asString() throws ValueConversionException {
        StringBuffer text = new StringBuffer("");
        text.append(this.first.asString());
        text.append(",");
        text.append(this.second.asString());
        text.append("..");
        text.append(this.last.asString());
        return text.toString();
    }

    @Override
    protected boolean containsImpl(Value aValue) {
        if (this.first.lt(this.second) && this.last.ge(aValue) && this.first.le(aValue) || this.first.gt(this.second) && this.last.le(aValue) && this.first.ge(aValue)) {
            BigDecimal firstVal = new BigDecimal(this.first.asString().replace(',', '.'));
            BigDecimal secondVal = new BigDecimal(this.second.asString().replace(',', '.'));
            BigDecimal aValueVal = new BigDecimal(aValue.asString().replace(',', '.'));
            BigDecimal leftOp = aValueVal.subtract(firstVal);
            BigDecimal rightOp = secondVal.subtract(firstVal);
            BigDecimal divide = leftOp.divide(rightOp, 10, 7);
            BigDecimal divide_rounded = leftOp.divide(rightOp, 0, 4);
            BigDecimal mod = divide.subtract(divide_rounded);
            return new NumberValue(0.0).eq(new NumberValue(mod.doubleValue()));
        }
        return false;
    }
}

