/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.format;

import de.statspez.pleditor.generator.format.CodeSegment;
import de.statspez.pleditor.generator.format.FormatSegment;
import de.statspez.pleditor.generator.format.Segment;
import de.statspez.pleditor.generator.format.SegmentTraverser;
import de.statspez.pleditor.generator.format.TextSegment;

public class HtmlSegmentConverter
extends SegmentTraverser {
    private StringBuffer buffer = new StringBuffer();

    public String convert(Segment segment) {
        this.buffer.delete(0, this.buffer.length());
        segment.accept(this);
        return this.buffer.toString();
    }

    protected void append(String text) {
        this.buffer.append(text);
    }

    @Override
    public void visitFormatSegment(FormatSegment segment) {
        String tag;
        switch (segment.getType()) {
            case 'f': {
                tag = "b";
                break;
            }
            case 'k': {
                tag = "i";
                break;
            }
            case 'u': {
                tag = "u";
                break;
            }
            case 'h': {
                tag = "sup";
                break;
            }
            case 't': {
                tag = "sub";
                break;
            }
            default: {
                throw new IllegalStateException("Invalid segment type: " + segment.getType());
            }
        }
        this.append("<" + tag + ">");
        super.visitFormatSegment(segment);
        this.append("</" + tag + ">");
    }

    @Override
    public void visitTextSegment(TextSegment segment) {
        this.append(HtmlSegmentConverter.escape(segment.getText()));
    }

    @Override
    public void visitCodeSegment(CodeSegment segment) {
        this.append(HtmlSegmentConverter.escape(segment.toString()));
    }

    protected static String escape(String text) {
        if (text == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        char[] chars = text.toCharArray();
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '\"': {
                    buffer.append("&quot;");
                    break;
                }
                case '\n': {
                    buffer.append("<br/>");
                    break;
                }
                case '\t': 
                case '\r': {
                    break;
                }
                default: {
                    buffer.append(chars[i]);
                }
            }
            ++i;
        }
        return buffer.toString();
    }
}

