/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.java.ProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.support.HelperVisitor;
import de.statspez.pleditor.generator.codegen.support.SymbolDescriptor;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaClassificationReference;
import de.statspez.pleditor.generator.meta.MetaDate;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaLiteralAccess;
import de.statspez.pleditor.generator.meta.MetaNoValue;

class SetValueStrategy
extends HelperVisitor {
    private ProgramCodeGenerator generator;

    public SetValueStrategy(ProgramCodeGenerator generator) {
        super(generator);
        this.generator = generator;
    }

    @Override
    public void visitFieldAccess(MetaFieldAccess anAccess) {
        if (!this.scope().isDefined(anAccess.accessedField(), this.namespace())) {
            this.error(anAccess, String.valueOf(anAccess.accessedField().toString()) + " ist nicht in diesem Gueltigkeitsbereich definiert " + "(Scope:" + this.namespace() + ")");
            return;
        }
        SymbolDescriptor sd = this.scope().symbolDescriptor(anAccess.accessedField(), this.namespace());
        if (sd.isArray()) {
            this.error(anAccess, "die Liste " + anAccess.accessedField().toString() + " kann nicht als Feld verwendet werden");
        }
        String name = StringHelper.getEscapedName(anAccess.accessedField().value());
        if (!this.generator.withinStructureAccess() && this.generator.withinSegment()) {
            if (sd.isLokaleVariable() || sd.isParameter()) {
                this.out().print("context.getVariable(\"");
                this.out().print(name);
                this.out().print("\")");
            } else {
                this.generator.printTopicAccess();
                this.out().print(name);
            }
        } else {
            this.out().print(name);
        }
        this.out().print(".set(context, ");
        this.out().print("ValueFactory.instance().valueFor(");
    }

    @Override
    public void visitArrayAccess(MetaArrayAccess anAccess) {
        if (!this.scope().isDefined(anAccess.accessedArray(), this.namespace())) {
            this.error(anAccess, String.valueOf(anAccess.accessedArray().toString()) + " ist in diesem Gueltigkeitsbereich nicht definiert " + "(Scope:" + this.namespace() + ")");
            return;
        }
        if (!this.scope().symbolDescriptor(anAccess.accessedArray(), this.namespace()).isArray()) {
            this.error(anAccess, String.valueOf(anAccess.accessedArray().toString()) + " ist keine Liste");
        }
        this.out().print(".set(context,");
        this.out().print("ValueFactory.instance().valueFor(");
    }

    @Override
    public void visitClassificationReference(MetaClassificationReference anAccess) {
        this.error(anAccess, "eine Auspraegung kann nicht veraendert werden");
    }

    @Override
    public void visitLiteralAccess(MetaLiteralAccess anAccess) {
        this.error(anAccess, "ein Literal kann nicht veraendert werden");
    }

    @Override
    public void visitDate(MetaDate aDate) {
        this.error(aDate, "ein Datum kann nicht veraendert werden");
    }

    @Override
    public void visitNoValue(MetaNoValue noValue) {
        this.error(noValue, "ein Leer-Wert kann nicht veraendert werden");
    }
}

