/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.sql.DataSource;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleCursor;
import mondrian.calc.TupleList;
import mondrian.calc.impl.DelegatingTupleList;
import mondrian.olap.Axis;
import mondrian.olap.CacheControl;
import mondrian.olap.Cell;
import mondrian.olap.ConnectionBase;
import mondrian.olap.Exp;
import mondrian.olap.FunTable;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.MondrianServer;
import mondrian.olap.Position;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.QueryPart;
import mondrian.olap.Result;
import mondrian.olap.ResultBase;
import mondrian.olap.ResultLimitExceededException;
import mondrian.olap.Role;
import mondrian.olap.RoleImpl;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.parser.MdxParserValidator;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapAxis;
import mondrian.rolap.RolapCell;
import mondrian.rolap.RolapConnectionPool;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapResult;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapSchemaPool;
import mondrian.rolap.RolapSchemaReader;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.ScenarioImpl;
import mondrian.server.Execution;
import mondrian.server.Locus;
import mondrian.server.Statement;
import mondrian.server.StatementImpl;
import mondrian.spi.DataSourceResolver;
import mondrian.spi.Dialect;
import mondrian.spi.DialectManager;
import mondrian.spi.impl.JndiDataSourceResolver;
import mondrian.util.ClassResolver;
import mondrian.util.FilteredIterableList;
import mondrian.util.LockBox;
import mondrian.util.MemoryMonitor;
import mondrian.util.MemoryMonitorFactory;
import mondrian.util.Pair;
import org.apache.commons.dbcp.DelegatingConnection;
import org.eigenbase.util.property.StringProperty;
import org.olap4j.Scenario;

public class RolapConnection
extends ConnectionBase {
    private static final org.apache.log4j.Logger LOGGER = org.apache.log4j.Logger.getLogger(RolapConnection.class);
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger();
    private final MondrianServer server;
    private final Util.PropertyList connectInfo;
    private final DataSource dataSource;
    private final String catalogUrl;
    private final RolapSchema schema;
    private SchemaReader schemaReader;
    protected Role role;
    private Locale locale;
    private Scenario scenario;
    private boolean closed;
    private static DataSourceResolver dataSourceResolver;
    private final int id;
    private final Statement internalStatement;

    public RolapConnection(MondrianServer server, Util.PropertyList connectInfo, DataSource dataSource) {
        this(server, connectInfo, null, dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RolapConnection(MondrianServer server, Util.PropertyList connectInfo, RolapSchema schema, DataSource dataSource) {
        String localeString;
        Role role;
        block39: {
            this.locale = Locale.getDefault();
            this.closed = false;
            assert (server != null);
            this.server = server;
            this.id = ID_GENERATOR.getAndIncrement();
            assert (connectInfo != null);
            String provider = connectInfo.get(RolapConnectionProperties.Provider.name(), "mondrian");
            Util.assertTrue(provider.equalsIgnoreCase("mondrian"));
            this.connectInfo = connectInfo;
            this.catalogUrl = connectInfo.get(RolapConnectionProperties.Catalog.name());
            String jdbcUser = connectInfo.get(RolapConnectionProperties.JdbcUser.name());
            String jdbcConnectString = connectInfo.get(RolapConnectionProperties.Jdbc.name());
            String strDataSource = connectInfo.get(RolapConnectionProperties.DataSource.name());
            StringBuilder buf = new StringBuilder();
            this.dataSource = RolapConnection.createDataSource(dataSource, connectInfo, buf);
            role = null;
            server.addConnection(this);
            if (schema == null) {
                Statement bootstrapStatement = this.createInternalStatement(false);
                Locus locus = new Locus(new Execution(bootstrapStatement, 0L), null, "Initializing connection");
                Locus.push(locus);
                try {
                    if (dataSource == null) {
                        String connectionKey = jdbcConnectString + RolapConnection.getJdbcProperties(connectInfo).toString();
                        schema = RolapSchemaPool.instance().get(this.catalogUrl, connectionKey, jdbcUser, strDataSource, connectInfo);
                    } else {
                        schema = RolapSchemaPool.instance().get(this.catalogUrl, dataSource, connectInfo);
                    }
                }
                finally {
                    Locus.pop(locus);
                    bootstrapStatement.close();
                }
                this.internalStatement = schema.getInternalConnection().getInternalStatement();
                String roleNameList = connectInfo.get(RolapConnectionProperties.Role.name());
                if (roleNameList != null) {
                    List<String> roleNames = Util.parseCommaList(roleNameList);
                    ArrayList<Role> roleList = new ArrayList<Role>();
                    for (String roleName : roleNames) {
                        Role role1;
                        LockBox.Entry entry = server.getLockBox().get(roleName);
                        if (entry != null) {
                            try {
                                role1 = (Role)entry.getValue();
                            }
                            catch (ClassCastException e) {
                                role1 = null;
                            }
                        } else {
                            role1 = schema.lookupRole(roleName);
                        }
                        if (role1 == null) {
                            throw Util.newError("Role '" + roleName + "' not found");
                        }
                        roleList.add(role1);
                    }
                    switch (roleList.size()) {
                        case 0: {
                            role = null;
                            break;
                        }
                        case 1: {
                            role = (Role)roleList.get(0);
                            break;
                        }
                        default: {
                            role = RoleImpl.union(roleList);
                        }
                    }
                }
            } else {
                this.internalStatement = this.createInternalStatement(true);
                Connection conn = null;
                java.sql.Statement statement = null;
                try {
                    conn = this.dataSource.getConnection();
                    Dialect dialect = DialectManager.createDialect(this.dataSource, conn);
                    if (dialect.getDatabaseProduct() == Dialect.DatabaseProduct.DERBY) {
                        statement = conn.createStatement();
                        statement.executeQuery("select * from bogustable");
                    }
                }
                catch (SQLException e) {
                    if (e.getMessage().equals("Table/View 'BOGUSTABLE' does not exist.")) {
                        break block39;
                    }
                    throw Util.newError(e, "Error while creating SQL connection: " + buf);
                }
                finally {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (SQLException e) {}
                }
            }
        }
        if (role == null) {
            role = schema.getDefaultRole();
        }
        if ((localeString = connectInfo.get(RolapConnectionProperties.Locale.name())) != null) {
            this.locale = Util.parseLocale(localeString);
            assert (this.locale != null);
        }
        this.schema = schema;
        this.setRole(role);
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
            this.close();
        }
        catch (Throwable t) {
            LOGGER.info((Object)MondrianResource.instance().FinalizerErrorRolapConnection.baseMessage, t);
        }
    }

    public int getId() {
        return this.id;
    }

    @Override
    protected org.apache.log4j.Logger getLogger() {
        return LOGGER;
    }

    static DataSource createDataSource(DataSource dataSource, Util.PropertyList connectInfo, StringBuilder buf) {
        assert (buf != null);
        String jdbcConnectString = connectInfo.get(RolapConnectionProperties.Jdbc.name());
        String jdbcUser = connectInfo.get(RolapConnectionProperties.JdbcUser.name());
        String jdbcPassword = connectInfo.get(RolapConnectionProperties.JdbcPassword.name());
        String dataSourceName = connectInfo.get(RolapConnectionProperties.DataSource.name());
        if (dataSource != null) {
            RolapConnection.appendKeyValue(buf, "Anonymous data source", dataSource);
            RolapConnection.appendKeyValue(buf, RolapConnectionProperties.JdbcUser.name(), jdbcUser);
            RolapConnection.appendKeyValue(buf, RolapConnectionProperties.JdbcPassword.name(), jdbcPassword);
            if (jdbcUser != null || jdbcPassword != null) {
                dataSource = new UserPasswordDataSource(dataSource, jdbcUser, jdbcPassword);
            }
            return dataSource;
        }
        if (jdbcConnectString != null) {
            boolean poolNeeded;
            RolapConnection.appendKeyValue(buf, RolapConnectionProperties.Jdbc.name(), jdbcConnectString);
            RolapConnection.appendKeyValue(buf, RolapConnectionProperties.JdbcUser.name(), jdbcUser);
            RolapConnection.appendKeyValue(buf, RolapConnectionProperties.JdbcPassword.name(), jdbcPassword);
            String jdbcDrivers = connectInfo.get(RolapConnectionProperties.JdbcDrivers.name());
            if (jdbcDrivers != null) {
                RolapUtil.loadDrivers(jdbcDrivers);
            }
            String jdbcDriversProp = MondrianProperties.instance().JdbcDrivers.get();
            RolapUtil.loadDrivers(jdbcDriversProp);
            Properties jdbcProperties = RolapConnection.getJdbcProperties(connectInfo);
            Map<String, String> map = Util.toMap(jdbcProperties);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                RolapConnection.appendKeyValue(buf, entry.getKey(), entry.getValue());
            }
            if (jdbcUser != null) {
                jdbcProperties.put("user", jdbcUser);
            }
            if (jdbcPassword != null) {
                jdbcProperties.put("password", jdbcPassword);
            }
            if (!(poolNeeded = connectInfo.get(RolapConnectionProperties.PoolNeeded.name(), "true").equalsIgnoreCase("true"))) {
                return new DriverManagerDataSource(jdbcConnectString, jdbcProperties);
            }
            if (jdbcConnectString.toLowerCase().indexOf("mysql") > -1) {
                jdbcProperties.setProperty("autoReconnect", "true");
            }
            return RolapConnectionPool.instance().getDriverManagerPoolingDataSource(jdbcConnectString, jdbcProperties);
        }
        if (dataSourceName != null) {
            RolapConnection.appendKeyValue(buf, RolapConnectionProperties.DataSource.name(), dataSourceName);
            RolapConnection.appendKeyValue(buf, RolapConnectionProperties.JdbcUser.name(), jdbcUser);
            RolapConnection.appendKeyValue(buf, RolapConnectionProperties.JdbcPassword.name(), jdbcPassword);
            boolean poolNeeded = connectInfo.get(RolapConnectionProperties.PoolNeeded.name(), "false").equalsIgnoreCase("true");
            DataSourceResolver dataSourceResolver = RolapConnection.getDataSourceResolver();
            try {
                dataSource = dataSourceResolver.lookup(dataSourceName);
            }
            catch (Exception e) {
                throw Util.newInternal(e, "Error while looking up data source (" + dataSourceName + ")");
            }
            if (poolNeeded) {
                dataSource = RolapConnectionPool.instance().getDataSourcePoolingDataSource(dataSource, dataSourceName, jdbcUser, jdbcPassword);
            } else if (jdbcUser != null || jdbcPassword != null) {
                dataSource = new UserPasswordDataSource(dataSource, jdbcUser, jdbcPassword);
            }
            return dataSource;
        }
        throw Util.newInternal("Connect string '" + connectInfo.toString() + "' must contain either '" + (Object)((Object)RolapConnectionProperties.Jdbc) + "' or '" + (Object)((Object)RolapConnectionProperties.DataSource) + "'");
    }

    private static synchronized DataSourceResolver getDataSourceResolver() {
        if (dataSourceResolver == null) {
            StringProperty property = MondrianProperties.instance().DataSourceResolverClass;
            String className = property.get(JndiDataSourceResolver.class.getName());
            try {
                dataSourceResolver = (DataSourceResolver)ClassResolver.INSTANCE.instantiateSafe(className, new Object[0]);
            }
            catch (ClassCastException e) {
                throw Util.newInternal(e, "Plugin class specified by property " + property.getPath() + " must implement " + DataSourceResolver.class.getName());
            }
        }
        return dataSourceResolver;
    }

    private static void appendKeyValue(StringBuilder buf, String key, Object value) {
        if (value != null) {
            if (buf.length() > 0) {
                buf.append("; ");
            }
            buf.append(key).append('=').append(value);
        }
    }

    private static Properties getJdbcProperties(Util.PropertyList connectInfo) {
        Properties jdbcProperties = new Properties();
        for (Pair<String, String> entry : connectInfo) {
            if (!((String)entry.left).startsWith("jdbc.")) continue;
            jdbcProperties.put(((String)entry.left).substring("jdbc.".length()), entry.right);
        }
        return jdbcProperties;
    }

    public Util.PropertyList getConnectInfo() {
        return this.connectInfo;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.server.removeConnection(this);
        }
        if (this.internalStatement != null) {
            this.internalStatement.close();
        }
    }

    @Override
    public RolapSchema getSchema() {
        return this.schema;
    }

    @Override
    public String getConnectString() {
        return this.connectInfo.toString();
    }

    @Override
    public String getCatalogName() {
        return this.catalogUrl;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale must not be null");
        }
        this.locale = locale;
    }

    @Override
    public SchemaReader getSchemaReader() {
        return this.schemaReader;
    }

    @Override
    public Object getProperty(String name) {
        if (name.equals(RolapConnectionProperties.JdbcPassword.name()) || name.equals(RolapConnectionProperties.CatalogContent.name())) {
            return "";
        }
        return this.connectInfo.get(name);
    }

    @Override
    public CacheControl getCacheControl(PrintWriter pw) {
        return this.getServer().getAggregationManager().getCacheControl(this, pw);
    }

    @Override
    public Result execute(Query query) {
        Statement statement = query.getStatement();
        Execution execution = new Execution(statement, statement.getQueryTimeoutMillis());
        return this.execute(execution);
    }

    public Result execute(final Execution execution) {
        execution.copyMDC();
        return this.server.getResultShepherd().shepherdExecution(execution, new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return RolapConnection.this.executeInternal(execution);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result executeInternal(final Execution execution) {
        Statement statement;
        execution.setContextMap();
        Statement statement2 = statement = execution.getMondrianStatement();
        synchronized (statement2) {
            Execution previousExecution = statement.getCurrentExecution();
            if (previousExecution != null) {
                statement.end(previousExecution);
            }
        }
        Query query = statement.getQuery();
        MemoryMonitor.Listener listener = new MemoryMonitor.Listener(){

            @Override
            public void memoryUsageNotification(long used, long max) {
                execution.setOutOfMemory("OutOfMemory used=" + used + ", max=" + max + " for connection: " + RolapConnection.this.getConnectString());
            }
        };
        MemoryMonitor mm = MemoryMonitorFactory.getMemoryMonitor();
        long currId = execution.getId();
        try {
            ResultBase result;
            mm.addListener(listener);
            execution.checkCancelOrTimeout();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)Util.unparse(query));
            }
            if (RolapUtil.MDX_LOGGER.isDebugEnabled()) {
                RolapUtil.MDX_LOGGER.debug((Object)(currId + ": " + Util.unparse(query)));
            }
            Locus locus = new Locus(execution, null, "Loading cells");
            Locus.push(locus);
            try {
                statement.start(execution);
                ((RolapCube)query.getCube()).clearCachedAggregations(true);
                result = new RolapResult(execution, true);
                int i = 0;
                for (QueryAxis axis : query.getAxes()) {
                    if (axis.isNonEmpty()) {
                        result = new NonEmptyResult(result, execution, i);
                    }
                    ++i;
                }
            }
            finally {
                Locus.pop(locus);
                ((RolapCube)query.getCube()).clearCachedAggregations(true);
            }
            statement.end(execution);
            RolapResult i = result;
            return i;
        }
        catch (ResultLimitExceededException e) {
            throw e;
        }
        catch (Exception e) {
            String queryString;
            try {
                if (!execution.isCancelOrTimeout()) {
                    statement.end(execution);
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
            try {
                queryString = Util.unparse(query);
            }
            catch (Exception e1) {
                queryString = "?";
            }
            throw Util.newError(e, "Error while executing query [" + queryString + "]");
        }
        finally {
            mm.removeListener(listener);
            if (RolapUtil.MDX_LOGGER.isDebugEnabled()) {
                long elapsed = execution.getElapsedMillis();
                RolapUtil.MDX_LOGGER.debug((Object)(currId + ": exec: " + elapsed + " ms"));
            }
        }
    }

    @Override
    public void setRole(Role role) {
        assert (role != null);
        this.role = role;
        this.schemaReader = new RolapSchemaReader(role, this.schema);
    }

    @Override
    public Role getRole() {
        Util.assertPostcondition(this.role != null, "role != null");
        return this.role;
    }

    public void setScenario(Scenario scenario) {
        this.scenario = scenario;
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    public MondrianServer getServer() {
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryPart parseStatement(String query) {
        Statement statement = this.createInternalStatement(false);
        Locus locus = new Locus(new Execution(statement, 0L), "Parse/validate MDX statement", null);
        Locus.push(locus);
        try {
            QueryPart queryPart = this.parseStatement(statement, query, null, false);
            if (queryPart instanceof Query) {
                ((Query)queryPart).setOwnStatement(true);
                statement = null;
            }
            QueryPart queryPart2 = queryPart;
            return queryPart2;
        }
        finally {
            Locus.pop(locus);
            if (statement != null) {
                statement.close();
            }
        }
    }

    @Override
    public Exp parseExpression(String expr) {
        boolean debug = false;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(Util.nl + expr));
        }
        Statement statement = this.getInternalStatement();
        try {
            MdxParserValidator parser = this.createParser();
            FunTable funTable = this.getSchema().getFunTable();
            return parser.parseExpression(statement, expr, debug, funTable);
        }
        catch (Throwable exception) {
            throw MondrianResource.instance().FailedToParseQuery.ex(expr, exception);
        }
    }

    @Override
    public Statement getInternalStatement() {
        if (this.internalStatement == null) {
            return this.schema.getInternalConnection().getInternalStatement();
        }
        return this.internalStatement;
    }

    private Statement createInternalStatement(boolean reentrant) {
        InternalStatement statement = reentrant ? new ReentrantInternalStatement() : new InternalStatement();
        this.server.addStatement(statement);
        return statement;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    public ScenarioImpl createScenario() {
        ScenarioImpl scenario = new ScenarioImpl();
        scenario.register(this.schema);
        return scenario;
    }

    private class ReentrantInternalStatement
    extends InternalStatement {
        private ReentrantInternalStatement() {
        }

        @Override
        public void start(Execution execution) {
            execution.start();
        }

        @Override
        public void end(Execution execution) {
            execution.end();
        }

        @Override
        public void close() {
        }
    }

    private class InternalStatement
    extends StatementImpl {
        private boolean closed = false;

        private InternalStatement() {
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                RolapConnection.this.server.removeStatement(this);
            }
        }

        @Override
        public RolapConnection getMondrianConnection() {
            return RolapConnection.this;
        }
    }

    private static class UserPasswordDataSource
    extends DelegatingDataSource {
        private final String jdbcUser;
        private final String jdbcPassword;

        public UserPasswordDataSource(DataSource dataSource, String jdbcUser, String jdbcPassword) {
            super(dataSource);
            this.jdbcUser = jdbcUser;
            this.jdbcPassword = jdbcPassword;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.dataSource.getConnection(this.jdbcUser, this.jdbcPassword);
        }
    }

    private static abstract class DelegatingDataSource
    implements DataSource {
        protected final DataSource dataSource;

        public DelegatingDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.dataSource.getConnection();
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            return this.dataSource.getConnection(username, password);
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.dataSource.getLogWriter();
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            this.dataSource.setLogWriter(out);
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            this.dataSource.setLoginTimeout(seconds);
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.dataSource.getLoginTimeout();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            if (Util.JdbcVersion >= 1024) {
                try {
                    Method method = DataSource.class.getMethod("unwrap", Class.class);
                    return iface.cast(method.invoke((Object)this.dataSource, iface));
                }
                catch (IllegalAccessException e) {
                    throw Util.newInternal(e, "While invoking unwrap");
                }
                catch (InvocationTargetException e) {
                    throw Util.newInternal(e, "While invoking unwrap");
                }
                catch (NoSuchMethodException e) {
                    throw Util.newInternal(e, "While invoking unwrap");
                }
            }
            if (iface.isInstance(this.dataSource)) {
                return iface.cast(this.dataSource);
            }
            return null;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            if (Util.JdbcVersion >= 1024) {
                try {
                    Method method = DataSource.class.getMethod("isWrapperFor", Boolean.TYPE);
                    return (Boolean)method.invoke((Object)this.dataSource, iface);
                }
                catch (IllegalAccessException e) {
                    throw Util.newInternal(e, "While invoking isWrapperFor");
                }
                catch (InvocationTargetException e) {
                    throw Util.newInternal(e, "While invoking isWrapperFor");
                }
                catch (NoSuchMethodException e) {
                    throw Util.newInternal(e, "While invoking isWrapperFor");
                }
            }
            return iface.isInstance(this.dataSource);
        }

        @Override
        public Logger getParentLogger() {
            if (Util.JdbcVersion >= 1025) {
                try {
                    Method method = DataSource.class.getMethod("getParentLogger", new Class[0]);
                    return (Logger)method.invoke((Object)this.dataSource, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw Util.newInternal(e, "While invoking getParentLogger");
                }
                catch (InvocationTargetException e) {
                    throw Util.newInternal(e, "While invoking getParentLogger");
                }
                catch (NoSuchMethodException e) {
                    throw Util.newInternal(e, "While invoking getParentLogger");
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    static class NonEmptyResult
    extends ResultBase {
        final Result underlying;
        private final int axis;
        private final Map<Integer, Integer> map;
        private final int[] pos;

        NonEmptyResult(Result result, Execution execution, int axis) {
            super(execution, (Axis[])result.getAxes().clone());
            TupleList filteredTupleList;
            this.underlying = result;
            this.axis = axis;
            this.map = new HashMap<Integer, Integer>();
            int axisCount = this.underlying.getAxes().length;
            this.pos = new int[axisCount];
            this.slicerAxis = this.underlying.getSlicerAxis();
            TupleList tupleList = ((RolapAxis)this.underlying.getAxes()[axis]).getTupleList();
            if (!tupleList.isEmpty() && ((Member)((List)tupleList.get(0)).get(0)).getDimension().isHighCardinality()) {
                filteredTupleList = new DelegatingTupleList(tupleList.getArity(), new FilteredIterableList<List<Member>>(tupleList, new FilteredIterableList.Filter<List<Member>>(){

                    @Override
                    public boolean accept(List<Member> p) {
                        return p.get(0) != null;
                    }
                }));
            } else {
                filteredTupleList = TupleCollections.createList(tupleList.getArity());
                int i = -1;
                TupleCursor tupleCursor = tupleList.tupleCursor();
                while (tupleCursor.forward()) {
                    if (this.isEmpty(++i, axis)) continue;
                    this.map.put(filteredTupleList.size(), i);
                    filteredTupleList.addCurrent(tupleCursor);
                }
            }
            this.axes[axis] = new RolapAxis(filteredTupleList);
        }

        @Override
        protected org.apache.log4j.Logger getLogger() {
            return LOGGER;
        }

        private boolean isEmpty(int offset, int fixedAxis) {
            int axisCount = this.getAxes().length;
            this.pos[fixedAxis] = offset;
            return this.isEmptyRecurse(fixedAxis, axisCount - 1);
        }

        private boolean isEmptyRecurse(int fixedAxis, int axis) {
            if (axis < 0) {
                RolapCell cell = (RolapCell)this.underlying.getCell(this.pos);
                return cell.isNull();
            }
            if (axis == fixedAxis) {
                return this.isEmptyRecurse(fixedAxis, axis - 1);
            }
            List<Position> positions = this.getAxes()[axis].getPositions();
            int positionCount = positions.size();
            int i = 0;
            while (i < positionCount) {
                this.pos[axis] = i++;
                if (this.isEmptyRecurse(fixedAxis, axis - 1)) continue;
                return false;
            }
            return true;
        }

        @Override
        public synchronized Cell getCell(int[] externalPos) {
            try {
                int mappedOffset;
                System.arraycopy(externalPos, 0, this.pos, 0, externalPos.length);
                int offset = externalPos[this.axis];
                this.pos[this.axis] = mappedOffset = this.mapOffsetToUnderlying(offset);
                return this.underlying.getCell(this.pos);
            }
            catch (NullPointerException npe) {
                return this.underlying.getCell(externalPos);
            }
        }

        private int mapOffsetToUnderlying(int offset) {
            return this.map.get(offset);
        }

        @Override
        public void close() {
            this.underlying.close();
        }
    }

    private static class DriverManagerDataSource
    implements DataSource {
        private final String jdbcConnectString;
        private PrintWriter logWriter;
        private int loginTimeout;
        private Properties jdbcProperties;

        public DriverManagerDataSource(String jdbcConnectString, Properties properties) {
            this.jdbcConnectString = jdbcConnectString;
            this.jdbcProperties = properties;
        }

        public int hashCode() {
            int h = this.loginTimeout;
            h = Util.hash(h, this.jdbcConnectString);
            h = Util.hash(h, this.jdbcProperties);
            return h;
        }

        public boolean equals(Object obj) {
            if (obj instanceof DriverManagerDataSource) {
                DriverManagerDataSource that = (DriverManagerDataSource)obj;
                return this.loginTimeout == that.loginTimeout && this.jdbcConnectString.equals(that.jdbcConnectString) && this.jdbcProperties.equals(that.jdbcProperties);
            }
            return false;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return new DelegatingConnection(DriverManager.getConnection(this.jdbcConnectString, this.jdbcProperties));
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            if (this.jdbcProperties == null) {
                return DriverManager.getConnection(this.jdbcConnectString, username, password);
            }
            Properties temp = (Properties)this.jdbcProperties.clone();
            temp.put("user", username);
            temp.put("password", password);
            return DriverManager.getConnection(this.jdbcConnectString, temp);
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.logWriter;
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            this.logWriter = out;
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            this.loginTimeout = seconds;
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.loginTimeout;
        }

        @Override
        public Logger getParentLogger() {
            return Logger.getLogger("");
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new SQLException("not a wrapper");
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }
    }
}

