/*
 * Decompiled with CFR 0.152.
 */
package mondrian.i18n;

import java.io.InputStream;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.spi.DynamicSchemaProcessor;
import mondrian.spi.impl.FilterDynamicSchemaProcessor;
import org.apache.log4j.Logger;

public class LocalizingDynamicSchemaProcessor
extends FilterDynamicSchemaProcessor
implements DynamicSchemaProcessor {
    private static final Logger LOGGER = Logger.getLogger(LocalizingDynamicSchemaProcessor.class);
    private ResourceBundle bundle;
    private static final Pattern pattern = Pattern.compile("(%\\{.*?\\})");
    private String locale;

    void populate(String propFile) {
        if (propFile.endsWith(".properties")) {
            propFile = propFile.substring(0, propFile.length() - ".properties".length());
        }
        try {
            this.bundle = ResourceBundle.getBundle(propFile, Util.parseLocale(this.locale), this.getClass().getClassLoader());
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Mondrian: Warning: no suitable locale file found for locale '" + this.locale + "'"), (Throwable)e);
        }
    }

    private void loadProperties() {
        String propFile = MondrianProperties.instance().LocalePropFile.get();
        if (propFile != null) {
            this.populate(propFile);
        }
    }

    @Override
    public String filter(String schemaUrl, Util.PropertyList connectInfo, InputStream stream) throws Exception {
        this.setLocale(connectInfo.get("Locale"));
        this.loadProperties();
        String schema = super.filter(schemaUrl, connectInfo, stream);
        if (this.bundle != null) {
            schema = this.doRegExReplacements(schema);
        }
        LOGGER.debug((Object)schema);
        return schema;
    }

    private String doRegExReplacements(String schema) {
        StringBuffer intlSchema = new StringBuffer();
        Matcher match = pattern.matcher(schema);
        while (match.find()) {
            String key = this.extractKey(match.group());
            int start = match.start();
            int end = match.end();
            try {
                String intlProperty = this.bundle.getString(key);
                if (intlProperty == null) continue;
                match.appendReplacement(intlSchema, intlProperty);
            }
            catch (MissingResourceException e) {
                LOGGER.error((Object)("Missing resource for key [" + key + "]"), (Throwable)e);
            }
            catch (NullPointerException e) {
                LOGGER.error((Object)("missing resource key at substring(" + start + "," + end + ")"), (Throwable)e);
            }
        }
        match.appendTail(intlSchema);
        return intlSchema.toString();
    }

    private String extractKey(String group) {
        return group.substring(2, group.length() - 1);
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }
}

