/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mondrian.calc.TupleIterator;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractTupleList;
import mondrian.olap.Member;
import mondrian.olap.Util;

public class DelegatingTupleList
extends AbstractTupleList {
    private final List<List<Member>> list;

    public DelegatingTupleList(int arity, List<List<Member>> list) {
        super(arity);
        this.list = list;
        assert (list.isEmpty() || list.get(0) instanceof List && (list.get(0).isEmpty() || list.get(0).get(0) == null || list.get(0).get(0) instanceof Member)) : "sanity check failed: " + list;
    }

    @Override
    protected TupleIterator tupleIteratorInternal() {
        return new AbstractTupleList.AbstractTupleListIterator();
    }

    @Override
    public TupleList subList(int fromIndex, int toIndex) {
        return new DelegatingTupleList(this.arity, this.list.subList(fromIndex, toIndex));
    }

    @Override
    public List<Member> get(int index) {
        return this.list.get(index);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<Member> slice(final int column) {
        return new AbstractList<Member>(){

            @Override
            public Member get(int index) {
                return (Member)((List)DelegatingTupleList.this.list.get(index)).get(column);
            }

            @Override
            public int size() {
                return DelegatingTupleList.this.list.size();
            }

            @Override
            public Member set(int index, Member element) {
                List subList = (List)DelegatingTupleList.this.list.get(index);
                if (subList.size() == 1) {
                    return DelegatingTupleList.this.list.set(index, Collections.singletonList(element)).get(0);
                }
                return subList.set(column, element);
            }
        };
    }

    @Override
    public TupleList cloneList(int capacity) {
        return new DelegatingTupleList(this.arity, capacity < 0 ? new ArrayList<List<Member>>(this.list) : new ArrayList(capacity));
    }

    @Override
    public List<Member> set(int index, List<Member> element) {
        return this.list.set(index, element);
    }

    @Override
    public void add(int index, List<Member> element) {
        this.list.add(index, element);
    }

    @Override
    public void addTuple(Member ... members) {
        this.list.add(Util.flatList(members));
    }

    @Override
    public TupleList project(final int[] destIndices) {
        return new DelegatingTupleList(destIndices.length, (List<List<Member>>)new AbstractList<List<Member>>(){

            @Override
            public List<Member> get(final int index) {
                return new AbstractList<Member>(){

                    @Override
                    public Member get(int column) {
                        return (Member)((List)DelegatingTupleList.this.list.get(index)).get(destIndices[column]);
                    }

                    @Override
                    public int size() {
                        return destIndices.length;
                    }

                    @Override
                    public Member set(int column, Member element) {
                        return ((List)DelegatingTupleList.this.list.get(index)).set(index, element);
                    }
                };
            }

            @Override
            public List<Member> set(int index, List<Member> element) {
                return DelegatingTupleList.this.list.set(index, element);
            }

            @Override
            public int size() {
                return DelegatingTupleList.this.list.size();
            }
        });
    }

    @Override
    public TupleList withPositionCallback(final TupleList.PositionCallback positionCallback) {
        return new DelegatingTupleList(this.arity, (List<List<Member>>)new AbstractList<List<Member>>(){

            @Override
            public List<Member> get(int index) {
                positionCallback.onPosition(index);
                return (List)DelegatingTupleList.this.list.get(index);
            }

            @Override
            public int size() {
                return DelegatingTupleList.this.list.size();
            }

            @Override
            public List<Member> set(int index, List<Member> element) {
                positionCallback.onPosition(index);
                return DelegatingTupleList.this.list.set(index, element);
            }

            @Override
            public void add(int index, List<Member> element) {
                positionCallback.onPosition(index);
                DelegatingTupleList.this.list.add(index, element);
            }

            @Override
            public List<Member> remove(int index) {
                positionCallback.onPosition(index);
                return (List)DelegatingTupleList.this.list.remove(index);
            }
        });
    }
}

