/*
 * Decompiled with CFR 0.152.
 */
package com.bitmechanic.maxq;

import com.bitmechanic.maxq.HttpRequestHeader;
import com.bitmechanic.maxq.IScriptAdapter;
import com.bitmechanic.maxq.RequestObserver;
import com.bitmechanic.maxq.Utils;
import com.bitmechanic.maxq.generator.GeneratorFactory;
import com.bitmechanic.maxq.generator.IScriptGenerator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class Test
implements RequestObserver {
    public static boolean debug = false;
    private IScriptGenerator testScript;
    private boolean isRecording;
    private File testFile;
    private String testName;

    public static boolean isDebug() {
        return debug;
    }

    public static void setDebug(boolean debug) {
        Test.debug = debug;
    }

    public Test(IScriptAdapter adapter) {
        this.testScript = GeneratorFactory.getTestScript(adapter);
    }

    public void openTest(File testFile) throws IOException {
        this.testFile = testFile;
        this.load();
        this.testName = this.testScript.parseTestName();
    }

    public String getTestScript() {
        return this.testScript.getScript();
    }

    public String getTestName() {
        return this.testName;
    }

    public File getTestFile() {
        return this.testFile;
    }

    public void setTestFile(File file) {
        this.testFile = file;
    }

    public String getCurrentPath() {
        String currentPath = null;
        currentPath = this.testFile == null ? System.getProperty("user.dir") : this.stripFileName(this.testFile.getAbsolutePath());
        return currentPath;
    }

    public String[] getvalidTestFileExtensions() {
        return this.testScript.getValidFileExtensions();
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public void pauseRecording() {
        this.isRecording = false;
    }

    public void stopRecording() {
        this.testScript.doStopRecording();
        this.isRecording = false;
    }

    public void startRecording() {
        this.isRecording = true;
        this.testScript.doStartRecording();
    }

    public void save() throws IOException {
        this.testScript.doSave(this.stripFileName(this.testFile.getAbsolutePath()), this.testFile.getName());
        PrintWriter writer = new PrintWriter(new FileWriter(this.testFile));
        String str = this.testScript.getScript();
        str = Utils.replace(str, "\r\n", "\n");
        str = Utils.replace(str, "\n", IScriptGenerator.EOL);
        writer.println(str);
        writer.close();
    }

    private String stripFileName(String absolutePath) {
        return absolutePath.substring(0, absolutePath.lastIndexOf(92));
    }

    public void processResponse(HttpRequestHeader header, byte[] response) {
        if (this.isRecording) {
            ((RequestObserver)((Object)this.testScript)).processResponse(header, response);
        }
    }

    public void processRequest(HttpRequestHeader header, byte[] request) {
        if (this.isRecording) {
            ((RequestObserver)((Object)this.testScript)).processRequest(header, request);
        }
    }

    private void load() throws IOException {
        StringBuffer buffer = new StringBuffer();
        BufferedReader r = new BufferedReader(new FileReader(this.testFile));
        String line = r.readLine();
        while (line != null) {
            buffer.append(line);
            buffer.append(IScriptGenerator.EOL);
            line = r.readLine();
        }
        r.close();
        this.testScript.doLoad(buffer.toString());
    }
}

