/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.text;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class AscFunction
implements Function {
    @Override
    public String getCanonicalName() {
        return "ASC";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount != 1) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type type1 = parameters.getType(0);
        Object value1 = parameters.getValue(0);
        TypeRegistry typeRegistry = context.getTypeRegistry();
        String result = typeRegistry.convertToText(type1, value1);
        if (result == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        char[] chars = result.toCharArray();
        StringBuffer b = new StringBuffer(chars.length);
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            this.convert(c, b);
        }
        return new TypeValuePair(TextType.TYPE, b.toString());
    }

    private void convert(char c, StringBuffer b) {
        if (c >= '\u30a1' && c <= '\u30aa') {
            if (c % 2 == 0) {
                b.append((char)((c - 12450) / 2 + 65393));
            } else {
                b.append((char)((c - 12449) / 2 + 65383));
            }
            return;
        }
        if (c >= '\u30ab' && c <= '\u30c2') {
            if (c % 2 == 0) {
                b.append((char)((c - 12459) / 2 + 65398));
            } else {
                b.append((char)((c - 12460) / 2 + 65398));
                b.append('\uff9e');
            }
            return;
        }
        if (c == '\u30c3') {
            b.append('\uff6f');
            return;
        }
        if (c >= '\u30c4' && c <= '\u30c9') {
            if (c % 2 == 0) {
                b.append((char)((c - 12484) / 2 + 65410));
            } else {
                b.append((char)((c - 12485) / 2 + 65410));
                b.append('\uff9e');
            }
            return;
        }
        if (c >= '\u30ca' && c <= '\u30ce') {
            b.append((char)(c - 12490 + 65413));
            return;
        }
        if (c >= '\u30cf' && c <= '\u30dd') {
            switch (c % 3) {
                case 0: {
                    b.append((char)((c - 12495) / 3 + 65418));
                    break;
                }
                case 1: {
                    b.append((char)((c - 12496) / 3 + 65418));
                    b.append('\uff9e');
                    break;
                }
                case 2: {
                    b.append((char)((c - 12497) / 3 + 65418));
                    b.append('\uff9f');
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return;
        }
        if (c >= '\u30de' && c <= '\u30e2') {
            b.append((char)(c - 12510 + 65423));
            return;
        }
        if (c >= '\u30e3' && c <= '\u30e8') {
            if (c % 2 == 0) {
                b.append((char)((c - 12516) / 2 + 65428));
            } else {
                b.append((char)((c - 12515) / 2 + 65388));
            }
            return;
        }
        if (c >= '\u30e9' && c <= '\u30ed') {
            b.append((char)(c - 12521 + 65431));
            return;
        }
        if (c == '\u30ef') {
            b.append('\uff9c');
            return;
        }
        if (c == '\u30f2') {
            b.append('\uff66');
            return;
        }
        if (c == '\u30f3') {
            b.append('\uff9d');
            return;
        }
        if (c >= '\uff01' && c <= '\uff5e') {
            b.append((char)(c - 65281 + 33));
            return;
        }
        if (c == '\u2015') {
            b.append('\uff70');
            return;
        }
        if (c == '\u2018') {
            b.append('`');
            return;
        }
        if (c == '\u2019') {
            b.append('\'');
            return;
        }
        if (c == '\u201d') {
            b.append('\"');
            return;
        }
        if (c == '\u3001') {
            b.append('\uff64');
            return;
        }
        if (c == '\u3002') {
            b.append('\uff61');
            return;
        }
        if (c == '\u300c') {
            b.append('\uff61');
            return;
        }
        if (c == '\u300d') {
            b.append('\uff61');
            return;
        }
        if (c == '\u309b') {
            b.append('\uff9e');
            return;
        }
        if (c == '\u309c') {
            b.append('\uff9f');
            return;
        }
        if (c == '\u30fb') {
            b.append('\uff65');
            return;
        }
        if (c == '\u30fc') {
            b.append('\uff70');
            return;
        }
        if (c == '\uffe5') {
            b.append('\\');
            return;
        }
        b.append(c);
    }
}

