/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.olapinput;

import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.olapinput.OlapData;
import org.pentaho.di.trans.steps.olapinput.OlapInputMeta;

public class OlapInput
extends BaseStep
implements StepInterface {
    private OlapInputMeta meta;
    private OlapData data;

    public OlapInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        try {
            if (this.first) {
                this.first = false;
                this.meta.initData(this);
                this.data.rowNumber = 0;
            }
            while (this.data.rowNumber < this.data.olapHelper.getRows().length) {
                String[] row = this.data.olapHelper.getRows()[this.data.rowNumber];
                Object[] outputRowData = RowDataUtil.allocateRowData((int)row.length);
                outputRowData = row;
                this.putRow(this.data.outputRowMeta, outputRowData);
                ++this.data.rowNumber;
            }
            this.setOutputDone();
            return false;
        }
        catch (Exception e) {
            this.logError("An error occurred, processing will be stopped", e);
            this.setErrors(1L);
            this.stopAll();
            return false;
        }
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.log.isBasic()) {
            this.logBasic("Finished reading query, closing connection.");
        }
        try {
            this.data.olapHelper.close();
        }
        catch (KettleDatabaseException e) {
            this.logError("Error closing connection: ", e);
        }
        super.dispose(smi, sdi);
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (OlapInputMeta)smi;
        this.data = (OlapData)sdi;
        return super.init(smi, sdi);
    }
}

