/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fieldsplitter;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.fieldsplitter.FieldSplitterData;
import org.pentaho.di.trans.steps.fieldsplitter.FieldSplitterMeta;

public class FieldSplitter
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = FieldSplitterMeta.class;
    private FieldSplitterMeta meta;
    private FieldSplitterData data;

    public FieldSplitter(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private Object[] splitField(Object[] r) throws KettleException {
        boolean selectFieldById;
        if (this.first) {
            this.first = false;
            this.data.previousMeta = this.getInputRowMeta().clone();
            this.data.fieldnr = this.data.previousMeta.indexOfValue(this.meta.getSplitField());
            if (this.data.fieldnr < 0) {
                throw new KettleValueException(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.CouldNotFindFieldToSplit", (String[])new String[]{this.meta.getSplitField()}));
            }
            if (!this.data.previousMeta.getValueMeta(this.data.fieldnr).isString()) {
                throw new KettleValueException(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.SplitFieldNotValid", (String[])new String[]{this.meta.getSplitField()}));
            }
            this.data.outputMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            this.data.conversionMeta = this.data.outputMeta.cloneToType(2);
            this.data.delimiter = this.environmentSubstitute(this.meta.getDelimiter());
            this.data.enclosure = this.environmentSubstitute(this.meta.getEnclosure());
        }
        Object[] outputRow = RowDataUtil.allocateRowData((int)this.data.outputMeta.size());
        int nrExtraFields = this.meta.getFieldID().length - 1;
        System.arraycopy(r, 0, outputRow, 0, this.data.fieldnr);
        System.arraycopy(r, this.data.fieldnr + 1, outputRow, this.data.fieldnr + 1 + nrExtraFields, this.data.previousMeta.size() - (this.data.fieldnr + 1));
        boolean bl = selectFieldById = this.meta.getFieldID().length > 0 && this.meta.getFieldID()[0] != null && this.meta.getFieldID()[0].length() > 0;
        if (this.log.isDebug()) {
            if (selectFieldById) {
                this.logDebug(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.UsingIds", (String[])new String[0]));
            } else {
                this.logDebug(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.UsingPositionOfValue", (String[])new String[0]));
            }
        }
        String valueToSplit = this.data.previousMeta.getString(r, this.data.fieldnr);
        String[] valueParts = Const.splitString((String)valueToSplit, (String)this.data.delimiter, (String)this.data.enclosure);
        int prev = 0;
        for (int i = 0; i < this.meta.getFieldName().length; ++i) {
            Object value;
            String rawValue = null;
            if (selectFieldById) {
                for (String part : valueParts) {
                    if (!part.startsWith(this.meta.getFieldID()[i])) continue;
                    if (this.meta.getFieldRemoveID()[i]) {
                        rawValue = part.substring(this.meta.getFieldID()[i].length());
                        break;
                    }
                    rawValue = part;
                    break;
                }
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.SplitInfo", (String[])new String[0]) + rawValue);
                }
            } else {
                rawValue = valueParts == null || i >= valueParts.length ? null : valueParts[i];
                prev += (rawValue == null ? 0 : rawValue.length()) + this.data.delimiter.length();
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.SplitFieldsInfo", (String[])new String[]{rawValue, String.valueOf(prev)}));
                }
            }
            try {
                ValueMetaInterface valueMeta = this.data.outputMeta.getValueMeta(this.data.fieldnr + i);
                ValueMetaInterface conversionValueMeta = this.data.conversionMeta.getValueMeta(this.data.fieldnr + i);
                value = valueMeta.convertDataFromString(rawValue, conversionValueMeta, this.meta.getFieldNullIf()[i], this.meta.getFieldIfNull()[i], this.meta.getFieldTrimType()[i]);
            }
            catch (Exception e) {
                throw new KettleValueException(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.ErrorConvertingSplitValue", (String[])new String[]{rawValue, this.meta.getSplitField() + "]!"}), (Throwable)e);
            }
            outputRow[this.data.fieldnr + i] = value;
        }
        return outputRow;
    }

    @Override
    public synchronized boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (FieldSplitterMeta)smi;
        this.data = (FieldSplitterData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        Object[] outputRowData = this.splitField(r);
        this.putRow(this.data.outputMeta, outputRowData);
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (FieldSplitterMeta)smi;
        this.data = (FieldSplitterData)sdi;
        return super.init(smi, sdi);
    }
}

