/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.datagrid;

import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.datagrid.DataGridData;
import org.pentaho.di.trans.steps.datagrid.DataGridMeta;

public class DataGrid
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = DataGridMeta.class;
    private DataGridMeta meta = (DataGridMeta)this.getStepMeta().getStepMetaInterface();
    private DataGridData data;

    public DataGrid(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (DataGridData)stepDataInterface;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        if (this.data.linesWritten >= this.meta.getDataLines().size()) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.linesWritten = 0;
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            this.data.convertMeta = this.data.outputRowMeta.cloneToType(2);
        }
        Object[] outputRowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        List<String> outputLine = this.meta.getDataLines().get(this.data.linesWritten);
        for (int i = 0; i < this.data.outputRowMeta.size(); ++i) {
            if (this.meta.isSetEmptyString()[i]) {
                outputRowData[i] = "";
                continue;
            }
            ValueMetaInterface valueMeta = this.data.outputRowMeta.getValueMeta(i);
            ValueMetaInterface convertMeta = this.data.convertMeta.getValueMeta(i);
            String valueData = outputLine.get(i);
            outputRowData[i] = valueMeta.convertDataFromString(valueData, convertMeta, null, null, 0);
        }
        this.putRow(this.data.outputRowMeta, outputRowData);
        ++this.data.linesWritten;
        if (this.log.isRowLevel()) {
            this.log.logRowlevel(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"DataGrid.Log.Wrote.Row", (String[])new String[]{Long.toString(this.getLinesWritten()), this.data.outputRowMeta.getString(outputRowData)})});
        }
        if (this.checkFeedback(this.getLinesWritten()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"DataGrid.Log.LineNr", (String[])new String[]{Long.toString(this.getLinesWritten())}));
        }
        return true;
    }

    public boolean isWaitingForData() {
        return true;
    }
}

