/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.ftpdelete;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPException;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.HTTPProxyData;
import com.trilead.ssh2.ProxyData;
import com.trilead.ssh2.SFTPv3Client;
import com.trilead.ssh2.SFTPv3DirectoryEntry;
import java.io.File;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.ftpsget.FTPSConnection;
import org.pentaho.di.job.entries.sftp.SFTPClient;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryFTPDelete
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryFTPDelete.class;
    private String serverName = null;
    private String port = "21";
    private String userName;
    private String password;
    private String ftpDirectory;
    private String wildcard;
    private int timeout;
    private boolean activeConnection;
    private boolean publicpublickey = false;
    private String keyFilename = null;
    private String keyFilePass = null;
    private boolean useproxy;
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String socksProxyHost;
    private String socksProxyPort = "1080";
    private String socksProxyUsername;
    private String socksProxyPassword;
    private String protocol = "FTP";
    public static final String PROTOCOL_FTP = "FTP";
    public static final String PROTOCOL_FTPS = "FTPS";
    public static final String PROTOCOL_SFTP = "SFTP";
    public static final String PROTOCOL_SSH = "SSH";
    public String SUCCESS_IF_AT_LEAST_X_FILES_DOWNLOADED = "success_when_at_least";
    public String SUCCESS_IF_ERRORS_LESS = "success_if_errors_less";
    public String SUCCESS_IF_ALL_FILES_DOWNLOADED = "success_is_all_files_downloaded";
    private String nr_limit_success = "10";
    private String success_condition = this.SUCCESS_IF_ALL_FILES_DOWNLOADED;
    private boolean copyprevious = false;
    private int FTPSConnectionType = 0;
    long NrErrors = 0L;
    long NrfilesDeleted = 0L;
    boolean successConditionBroken = false;
    String targetFilename = null;
    int limitFiles = 0;
    FTPClient ftpclient = null;
    FTPSConnection ftpsclient = null;
    SFTPClient sftpclient = null;
    SFTPv3Client sshclient = null;

    public JobEntryFTPDelete(String n) {
        super(n, "");
    }

    public JobEntryFTPDelete() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryFTPDelete je = (JobEntryFTPDelete)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(128);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"protocol", (String)this.protocol));
        retval.append("      ").append(XMLHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"port", (String)this.port));
        retval.append("      ").append(XMLHandler.addTagValue((String)"username", (String)this.userName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.getPassword())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"ftpdirectory", (String)this.ftpDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"timeout", (int)this.timeout));
        retval.append("      ").append(XMLHandler.addTagValue((String)"active", (boolean)this.activeConnection));
        retval.append("      ").append(XMLHandler.addTagValue((String)"useproxy", (boolean)this.useproxy));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_host", (String)this.proxyHost));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_port", (String)this.proxyPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_username", (String)this.proxyUsername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"publicpublickey", (boolean)this.publicpublickey));
        retval.append("      ").append(XMLHandler.addTagValue((String)"keyfilename", (String)this.keyFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"keyfilepass", (String)this.keyFilePass));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nr_limit_success", (String)this.nr_limit_success));
        retval.append("      ").append(XMLHandler.addTagValue((String)"success_condition", (String)this.success_condition));
        retval.append("      ").append(XMLHandler.addTagValue((String)"copyprevious", (boolean)this.copyprevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)"ftps_connection_type", (String)FTPSConnection.getConnectionTypeCode(this.FTPSConnectionType)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"socksproxy_host", (String)this.socksProxyHost));
        retval.append("      ").append(XMLHandler.addTagValue((String)"socksproxy_port", (String)this.socksProxyPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"socksproxy_username", (String)this.socksProxyUsername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"socksproxy_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.getSocksProxyPassword())));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.protocol = XMLHandler.getTagValue((Node)entrynode, (String)"protocol");
            this.port = XMLHandler.getTagValue((Node)entrynode, (String)"port");
            this.serverName = XMLHandler.getTagValue((Node)entrynode, (String)"servername");
            this.userName = XMLHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"password"));
            this.ftpDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"ftpdirectory");
            this.wildcard = XMLHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.timeout = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"timeout"), (int)10000);
            this.activeConnection = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"active"));
            this.useproxy = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"useproxy"));
            this.proxyHost = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_host");
            this.proxyPort = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_port");
            this.proxyUsername = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_username");
            this.proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"proxy_password"));
            this.publicpublickey = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"publicpublickey"));
            this.keyFilename = XMLHandler.getTagValue((Node)entrynode, (String)"keyfilename");
            this.keyFilePass = XMLHandler.getTagValue((Node)entrynode, (String)"keyfilepass");
            this.nr_limit_success = XMLHandler.getTagValue((Node)entrynode, (String)"nr_limit_success");
            this.success_condition = XMLHandler.getTagValue((Node)entrynode, (String)"success_condition");
            this.copyprevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"copyprevious"));
            this.FTPSConnectionType = FTPSConnection.getConnectionTypeByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"ftps_connection_type"), (String)""));
            this.socksProxyHost = XMLHandler.getTagValue((Node)entrynode, (String)"socksproxy_host");
            this.socksProxyPort = XMLHandler.getTagValue((Node)entrynode, (String)"socksproxy_port");
            this.socksProxyUsername = XMLHandler.getTagValue((Node)entrynode, (String)"socksproxy_username");
            this.socksProxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"socksproxy_password"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'ftp' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.protocol = rep.getJobEntryAttributeString(id_jobentry, "protocol");
            this.port = rep.getJobEntryAttributeString(id_jobentry, "port");
            this.serverName = rep.getJobEntryAttributeString(id_jobentry, "servername");
            this.userName = rep.getJobEntryAttributeString(id_jobentry, "username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "password"));
            this.ftpDirectory = rep.getJobEntryAttributeString(id_jobentry, "ftpdirectory");
            this.wildcard = rep.getJobEntryAttributeString(id_jobentry, "wildcard");
            this.timeout = (int)rep.getJobEntryAttributeInteger(id_jobentry, "timeout");
            this.activeConnection = rep.getJobEntryAttributeBoolean(id_jobentry, "active");
            this.copyprevious = rep.getJobEntryAttributeBoolean(id_jobentry, "copyprevious");
            this.useproxy = rep.getJobEntryAttributeBoolean(id_jobentry, "useproxy");
            this.proxyHost = rep.getJobEntryAttributeString(id_jobentry, "proxy_host");
            this.proxyPort = rep.getJobEntryAttributeString(id_jobentry, "proxy_port");
            this.proxyUsername = rep.getJobEntryAttributeString(id_jobentry, "proxy_username");
            this.proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "proxy_password"));
            this.publicpublickey = rep.getJobEntryAttributeBoolean(id_jobentry, "publicpublickey");
            this.keyFilename = rep.getJobEntryAttributeString(id_jobentry, "keyfilename");
            this.keyFilePass = rep.getJobEntryAttributeString(id_jobentry, "keyfilepass");
            this.nr_limit_success = rep.getJobEntryAttributeString(id_jobentry, "nr_limit_success");
            this.success_condition = rep.getJobEntryAttributeString(id_jobentry, "success_condition");
            this.FTPSConnectionType = FTPSConnection.getConnectionTypeByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "ftps_connection_type"), (String)""));
            this.socksProxyHost = rep.getJobEntryAttributeString(id_jobentry, "socksproxy_host");
            this.socksProxyPort = rep.getJobEntryAttributeString(id_jobentry, "socksproxy_port");
            this.socksProxyUsername = rep.getJobEntryAttributeString(id_jobentry, "socksproxy_username");
            this.socksProxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "socksproxy_password"));
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'ftp' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "protocol", this.protocol);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "port", this.port);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "servername", this.serverName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "username", this.userName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "ftpdirectory", this.ftpDirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "wildcard", this.wildcard);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "timeout", this.timeout);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "active", this.activeConnection);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "copyprevious", this.copyprevious);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "useproxy", this.useproxy);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "publicpublickey", this.publicpublickey);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "keyfilename", this.keyFilename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "keyfilepass", this.keyFilePass);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxy_host", this.proxyHost);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxy_port", this.proxyPort);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxy_username", this.proxyUsername);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxy_password", Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "nr_limit_success", this.nr_limit_success);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "success_condition", this.success_condition);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "ftps_connection_type", FTPSConnection.getConnectionType(this.FTPSConnectionType));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "socksproxy_host", this.socksProxyHost);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "socksproxy_port", this.socksProxyPort);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "socksproxy_username", this.socksProxyUsername);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "socksproxy_password", Encr.encryptPasswordIfNotUsingVariables((String)this.socksProxyPassword));
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'ftp' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    private boolean getStatus() {
        boolean retval = false;
        if (this.NrErrors == 0L && this.getSuccessCondition().equals(this.SUCCESS_IF_ALL_FILES_DOWNLOADED) || this.NrfilesDeleted >= (long)this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_AT_LEAST_X_FILES_DOWNLOADED) || this.NrErrors <= (long)this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    public boolean isCopyPrevious() {
        return this.copyprevious;
    }

    public void setCopyPrevious(boolean copyprevious) {
        this.copyprevious = copyprevious;
    }

    public void setUsePublicKey(boolean publickey) {
        this.publicpublickey = publickey;
    }

    public boolean isUsePublicKey() {
        return this.publicpublickey;
    }

    public void setKeyFilename(String keyfilename) {
        this.keyFilename = keyfilename;
    }

    public String getKeyFilename() {
        return this.keyFilename;
    }

    public void setKeyFilePass(String keyFilePass) {
        this.keyFilePass = keyFilePass;
    }

    public String getKeyFilePass() {
        return this.keyFilePass;
    }

    public int getFTPSConnectionType() {
        return this.FTPSConnectionType;
    }

    public void setFTPSConnectionType(int type) {
        this.FTPSConnectionType = type;
    }

    public void setLimitSuccess(String nr_limit_successin) {
        this.nr_limit_success = nr_limit_successin;
    }

    public String getLimitSuccess() {
        return this.nr_limit_success;
    }

    public void setSuccessCondition(String success_condition) {
        this.success_condition = success_condition;
    }

    public String getSuccessCondition() {
        return this.success_condition;
    }

    public String getFtpDirectory() {
        return this.ftpDirectory;
    }

    public void setFtpDirectory(String directory) {
        this.ftpDirectory = directory;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public boolean isUseProxy() {
        return this.useproxy;
    }

    public void setUseProxy(boolean useproxy) {
        this.useproxy = useproxy;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        String[] filelist;
        String sourceFolder;
        HashSet<String> list_previous_files;
        List rows;
        Result result;
        RowMetaAndData resultRow;
        block94: {
            int found;
            this.log.logBasic(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.Started", (String[])new String[]{this.serverName}));
            resultRow = null;
            result = previousResult;
            rows = result.getRows();
            result.setResult(false);
            this.NrErrors = 0L;
            this.NrfilesDeleted = 0L;
            this.successConditionBroken = false;
            list_previous_files = new HashSet<String>();
            String realservername = this.environmentSubstitute(this.serverName);
            String realserverpassword = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.password));
            String realFtpDirectory = this.environmentSubstitute(this.ftpDirectory);
            int realserverport = Const.toInt((String)this.environmentSubstitute(this.port), (int)0);
            String realUsername = this.environmentSubstitute(this.userName);
            String realPassword = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.password));
            String realproxyhost = this.environmentSubstitute(this.proxyHost);
            String realproxyusername = this.environmentSubstitute(this.proxyUsername);
            String realproxypassword = this.environmentSubstitute(this.proxyPassword);
            int realproxyport = Const.toInt((String)this.environmentSubstitute(this.proxyPort), (int)0);
            String realkeyFilename = this.environmentSubstitute(this.keyFilename);
            String realkeyPass = this.environmentSubstitute(this.keyFilePass);
            sourceFolder = "";
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.Start", (String[])new String[0]));
            }
            if (this.copyprevious && rows.size() == 0) {
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.ArgsFromPreviousNothing", (String[])new String[0]));
                }
                result.setResult(true);
                return result;
            }
            filelist = null;
            if (this.protocol.equals(PROTOCOL_FTP)) {
                String translatedWildcard;
                if (!Const.isEmpty((String)this.socksProxyHost)) {
                    if (Const.isEmpty((String)this.socksProxyPort)) {
                        throw new FTPException(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.SocksProxy.PortMissingException", (String[])new String[]{this.environmentSubstitute(this.socksProxyHost), this.getName()}));
                    }
                    FTPClient.initSOCKS((String)this.environmentSubstitute(this.socksProxyPort), (String)this.environmentSubstitute(this.socksProxyHost));
                    if (!Const.isEmpty((String)this.socksProxyUsername) && !Const.isEmpty((String)this.socksProxyPassword)) {
                        FTPClient.initSOCKSAuthentication((String)this.environmentSubstitute(this.socksProxyUsername), (String)this.environmentSubstitute(this.socksProxyPassword));
                    } else if (!Const.isEmpty((String)this.socksProxyUsername) && Const.isEmpty((String)this.socksProxyPassword) || Const.isEmpty((String)this.socksProxyUsername) && !Const.isEmpty((String)this.socksProxyPassword)) {
                        throw new FTPException(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.SocksProxy.IncompleteCredentials", (String[])new String[]{this.environmentSubstitute(this.socksProxyHost), this.getName()}));
                    }
                }
                this.FTPConnect(realservername, realUsername, realPassword, realserverport, realFtpDirectory, realproxyhost, realproxyusername, realproxypassword, realproxyport, this.timeout);
                filelist = this.ftpclient.dir();
                if (filelist.length == 1 && !Const.isEmpty((String)(translatedWildcard = this.environmentSubstitute(this.wildcard))) && filelist[0].startsWith(translatedWildcard)) {
                    throw new FTPException(filelist[0]);
                }
            } else if (this.protocol.equals(PROTOCOL_FTPS)) {
                this.FTPSConnect(realservername, realUsername, realserverport, realPassword, realFtpDirectory, this.timeout);
                filelist = this.ftpsclient.getFileNames();
            } else if (this.protocol.equals(PROTOCOL_SFTP)) {
                this.SFTPConnect(realservername, realUsername, realserverport, realPassword, realFtpDirectory);
                filelist = this.sftpclient.dir();
            } else if (this.protocol.equals(PROTOCOL_SSH)) {
                this.SSHConnect(realservername, realserverpassword, realserverport, realUsername, realPassword, realproxyhost, realproxyusername, realproxypassword, realproxyport, realkeyFilename, realkeyPass);
                sourceFolder = ".";
                sourceFolder = realFtpDirectory != null ? realFtpDirectory + "/" : "./";
                Vector vfilelist = this.sshclient.ls(sourceFolder);
                if (vfilelist != null) {
                    int fileCount = 0;
                    for (SFTPv3DirectoryEntry dirEntry : vfilelist) {
                        if (dirEntry == null || dirEntry.filename.equals(".") || dirEntry.filename.equals("..") || this.isDirectory(this.sshclient, sourceFolder + dirEntry.filename)) continue;
                        ++fileCount;
                    }
                    filelist = new String[fileCount];
                    Iterator iterator = vfilelist.iterator();
                    int i = 0;
                    while (iterator.hasNext()) {
                        SFTPv3DirectoryEntry dirEntry = (SFTPv3DirectoryEntry)iterator.next();
                        if (dirEntry == null || dirEntry.filename.equals(".") || dirEntry.filename.equals("..") || this.isDirectory(this.sshclient, sourceFolder + dirEntry.filename)) continue;
                        filelist[i] = dirEntry.filename;
                        ++i;
                    }
                }
            }
            if (this.isDetailed()) {
                this.logDetailed("JobEntryFTPDelete.FoundNFiles", String.valueOf(filelist.length));
            }
            int n = found = filelist == null ? 0 : filelist.length;
            if (found != 0) break block94;
            result.setResult(true);
            Result fileCount = result;
            if (this.ftpclient != null && this.ftpclient.connected()) {
                try {
                    this.ftpclient.quit();
                    this.ftpclient = null;
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.ErrorQuitting", (String[])new String[]{e.getMessage()}));
                }
            }
            if (this.ftpsclient != null) {
                try {
                    this.ftpsclient.disconnect();
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.ErrorQuitting", (String[])new String[]{e.getMessage()}));
                }
            }
            if (this.sftpclient != null) {
                try {
                    this.sftpclient.disconnect();
                    this.sftpclient = null;
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.ErrorQuitting", (String[])new String[]{e.getMessage()}));
                }
            }
            if (this.sshclient != null) {
                try {
                    this.sshclient.close();
                    this.sshclient = null;
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.ErrorQuitting", (String[])new String[]{e.getMessage()}));
                }
            }
            FTPClient.clearSOCKS();
            return fileCount;
        }
        try {
            Pattern pattern = null;
            if (this.copyprevious) {
                for (int iteration = 0; iteration < rows.size(); ++iteration) {
                    resultRow = (RowMetaAndData)rows.get(iteration);
                    String file_previous = resultRow.getString(0, null);
                    if (Const.isEmpty((String)file_previous)) continue;
                    list_previous_files.add(file_previous);
                }
            } else if (!Const.isEmpty((String)this.wildcard)) {
                String realWildcard = this.environmentSubstitute(this.wildcard);
                pattern = Pattern.compile(realWildcard);
            }
            if (!this.getSuccessCondition().equals(this.SUCCESS_IF_ALL_FILES_DOWNLOADED)) {
                this.limitFiles = Const.toInt((String)this.environmentSubstitute(this.getLimitSuccess()), (int)10);
            }
            for (int i = 0; i < filelist.length && !this.parentJob.isStopped(); ++i) {
                if (this.successConditionBroken) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.SuccesConditionBroken", (String[])new String[0]));
                }
                boolean getIt = false;
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.AnalysingFile", (String[])new String[]{filelist[i]}));
                }
                try {
                    if (this.copyprevious) {
                        if (list_previous_files.contains(filelist[i])) {
                            getIt = true;
                        }
                    } else if (pattern != null) {
                        Matcher matcher = pattern.matcher(filelist[i]);
                        getIt = matcher.matches();
                    }
                    if (!getIt) continue;
                    if (this.protocol.equals(PROTOCOL_FTP)) {
                        this.ftpclient.delete(filelist[i]);
                    }
                    if (this.protocol.equals(PROTOCOL_FTPS)) {
                        System.out.println("---------------" + filelist[i]);
                        this.ftpsclient.deleteFile(filelist[i]);
                    } else if (this.protocol.equals(PROTOCOL_SFTP)) {
                        this.sftpclient.delete(filelist[i]);
                    } else if (this.protocol.equals(PROTOCOL_SSH)) {
                        this.sshclient.rm(sourceFolder + filelist[i]);
                    }
                    if (this.isDetailed()) {
                        this.logDetailed("JobEntryFTPDelete.RemotefileDeleted", filelist[i]);
                    }
                    this.updateDeletedFiles();
                    continue;
                }
                catch (Exception e) {
                    this.updateErrors();
                    this.logError(BaseMessages.getString(PKG, (String)"JobFTP.UnexpectedError", (String[])new String[]{e.getMessage()}));
                    if (!this.successConditionBroken) continue;
                    throw new Exception(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.SuccesConditionBroken", (String[])new String[0]));
                }
            }
        }
        catch (Exception e) {
            try {
                this.updateErrors();
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.ErrorGetting", (String[])new String[]{e.getMessage()}));
                this.logError(Const.getStackTracker((Throwable)e));
            }
            catch (Throwable throwable) {
                if (this.ftpclient != null && this.ftpclient.connected()) {
                    try {
                        this.ftpclient.quit();
                        this.ftpclient = null;
                    }
                    catch (Exception e2) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.ErrorQuitting", (String[])new String[]{e2.getMessage()}));
                    }
                }
                if (this.ftpsclient != null) {
                    try {
                        this.ftpsclient.disconnect();
                    }
                    catch (Exception e3) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.ErrorQuitting", (String[])new String[]{e3.getMessage()}));
                    }
                }
                if (this.sftpclient != null) {
                    try {
                        this.sftpclient.disconnect();
                        this.sftpclient = null;
                    }
                    catch (Exception e4) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.ErrorQuitting", (String[])new String[]{e4.getMessage()}));
                    }
                }
                if (this.sshclient != null) {
                    try {
                        this.sshclient.close();
                        this.sshclient = null;
                    }
                    catch (Exception e5) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.ErrorQuitting", (String[])new String[]{e5.getMessage()}));
                    }
                }
                FTPClient.clearSOCKS();
                throw throwable;
            }
            if (this.ftpclient != null && this.ftpclient.connected()) {
                try {
                    this.ftpclient.quit();
                    this.ftpclient = null;
                }
                catch (Exception e6) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.ErrorQuitting", (String[])new String[]{e6.getMessage()}));
                }
            }
            if (this.ftpsclient != null) {
                try {
                    this.ftpsclient.disconnect();
                }
                catch (Exception e7) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.ErrorQuitting", (String[])new String[]{e7.getMessage()}));
                }
            }
            if (this.sftpclient != null) {
                try {
                    this.sftpclient.disconnect();
                    this.sftpclient = null;
                }
                catch (Exception e8) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.ErrorQuitting", (String[])new String[]{e8.getMessage()}));
                }
            }
            if (this.sshclient != null) {
                try {
                    this.sshclient.close();
                    this.sshclient = null;
                }
                catch (Exception e9) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.ErrorQuitting", (String[])new String[]{e9.getMessage()}));
                }
            }
            FTPClient.clearSOCKS();
        }
        if (this.ftpclient != null && this.ftpclient.connected()) {
            try {
                this.ftpclient.quit();
                this.ftpclient = null;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.ErrorQuitting", (String[])new String[]{e.getMessage()}));
            }
        }
        if (this.ftpsclient != null) {
            try {
                this.ftpsclient.disconnect();
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.ErrorQuitting", (String[])new String[]{e.getMessage()}));
            }
        }
        if (this.sftpclient != null) {
            try {
                this.sftpclient.disconnect();
                this.sftpclient = null;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.ErrorQuitting", (String[])new String[]{e.getMessage()}));
            }
        }
        if (this.sshclient != null) {
            try {
                this.sshclient.close();
                this.sshclient = null;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.ErrorQuitting", (String[])new String[]{e.getMessage()}));
            }
        }
        FTPClient.clearSOCKS();
        result.setResult(!this.successConditionBroken);
        result.setNrFilesRetrieved(this.NrfilesDeleted);
        result.setNrErrors(this.NrErrors);
        return result;
    }

    public boolean isDirectory(SFTPv3Client sftpClient, String filename) {
        try {
            return sftpClient.stat(filename).isDirectory();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void SSHConnect(String realservername, String realserverpassword, int realserverport, String realUsername, String realPassword, String realproxyhost, String realproxyusername, String realproxypassword, int realproxyport, String realkeyFilename, String realkeyPass) throws Exception {
        Connection conn = new Connection(realservername, realserverport);
        if (this.useproxy) {
            conn.setProxyData((ProxyData)new HTTPProxyData(realproxyhost, realproxyport));
            if (!Const.isEmpty((String)realproxyusername) || !Const.isEmpty((String)realproxypassword)) {
                conn.setProxyData((ProxyData)new HTTPProxyData(realproxyhost, realproxyport, realproxyusername, realproxypassword));
            }
        }
        if (this.timeout > 0) {
            conn.connect(null, 0, this.timeout * 1000);
        } else {
            conn.connect();
        }
        boolean isAuthenticated = false;
        isAuthenticated = this.publicpublickey ? conn.authenticateWithPublicKey(realUsername, new File(realkeyFilename), realkeyPass) : conn.authenticateWithPassword(realUsername, realserverpassword);
        if (!isAuthenticated) {
            throw new Exception("Can not connect to ");
        }
        this.sshclient = new SFTPv3Client(conn);
    }

    private void SFTPConnect(String realservername, String realusername, int realport, String realpassword, String realFTPDirectory) throws Exception {
        this.sftpclient = new SFTPClient(InetAddress.getByName(realservername), realport, realusername);
        this.sftpclient.login(realpassword);
        if (!Const.isEmpty((String)realFTPDirectory)) {
            this.sftpclient.chdir(realFTPDirectory);
            if (this.isDetailed()) {
                this.logDetailed("Changed to directory [" + realFTPDirectory + "]");
            }
        }
    }

    private void FTPSConnect(String realservername, String realusername, int realport, String realpassword, String realFTPDirectory, int realtimeout) throws Exception {
        this.ftpsclient = new FTPSConnection(this.getFTPSConnectionType(), realservername, realport, realusername, realpassword);
        if (!Const.isEmpty((String)this.proxyHost)) {
            int proxyport;
            String realProxy_host = this.environmentSubstitute(this.proxyHost);
            String realProxy_username = this.environmentSubstitute(this.proxyUsername);
            String realProxy_password = this.environmentSubstitute(this.proxyPassword);
            this.ftpsclient.setProxyHost(realProxy_host);
            if (!Const.isEmpty((String)realProxy_username)) {
                this.ftpsclient.setProxyUser(realProxy_username);
            }
            if (!Const.isEmpty((String)realProxy_password)) {
                this.ftpsclient.setProxyPassword(realProxy_password);
            }
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.OpenedProxyConnectionOn", (String[])new String[]{realProxy_host}));
            }
            if ((proxyport = Const.toInt((String)this.environmentSubstitute(this.proxyPort), (int)21)) != 0) {
                this.ftpsclient.setProxyPort(proxyport);
            }
        } else if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.OpenedConnectionTo", (String[])new String[]{realservername}));
        }
        if (this.activeConnection) {
            this.ftpsclient.setPassiveMode(false);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.SetActive", (String[])new String[0]));
            }
        } else {
            this.ftpsclient.setPassiveMode(true);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.SetPassive", (String[])new String[0]));
            }
        }
        this.ftpsclient.setTimeOut(realtimeout);
        if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.SetTimeout", (String[])new String[]{String.valueOf(realtimeout)}));
        }
        this.ftpsclient.connect();
        if (!Const.isEmpty((String)realFTPDirectory)) {
            this.ftpsclient.changeDirectory(realFTPDirectory);
            if (this.isDetailed()) {
                this.logDetailed("Changed to directory [" + realFTPDirectory + "]");
            }
        }
    }

    private void FTPConnect(String realServername, String realusername, String realpassword, int realport, String realFtpDirectory, String realProxyhost, String realproxyusername, String realproxypassword, int realproxyport, int realtimeout) throws Exception {
        this.ftpclient = new FTPClient();
        this.ftpclient.setRemoteAddr(InetAddress.getByName(realServername));
        if (realport != 0) {
            this.ftpclient.setRemotePort(realport);
        }
        if (!Const.isEmpty((String)realProxyhost)) {
            this.ftpclient.setRemoteAddr(InetAddress.getByName(realProxyhost));
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.OpenedProxyConnectionOn", (String[])new String[]{realProxyhost}));
            }
            if (realproxyport != 0) {
                this.ftpclient.setRemotePort(realproxyport);
            }
        } else {
            this.ftpclient.setRemoteAddr(InetAddress.getByName(realServername));
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.OpenedConnectionTo", (String[])new String[]{realServername}));
            }
        }
        if (this.activeConnection) {
            this.ftpclient.setConnectMode(FTPConnectMode.ACTIVE);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.SetActive", (String[])new String[0]));
            }
        } else {
            this.ftpclient.setConnectMode(FTPConnectMode.PASV);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.SetPassive", (String[])new String[0]));
            }
        }
        this.ftpclient.setTimeout(realtimeout);
        if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.SetTimeout", (String[])new String[]{String.valueOf(realtimeout)}));
        }
        this.ftpclient.connect();
        String realUsername = realusername + (!Const.isEmpty((String)realProxyhost) ? "@" + realServername : "") + (!Const.isEmpty((String)realproxyusername) ? " " + realproxyusername : "");
        String realPassword = realpassword + (!Const.isEmpty((String)realproxypassword) ? " " + realproxypassword : "");
        this.ftpclient.login(realUsername, realPassword);
        if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.LoggedIn", (String[])new String[]{realUsername}));
        }
        if (!Const.isEmpty((String)realFtpDirectory)) {
            this.ftpclient.chdir(realFtpDirectory);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPDelete.ChangedDir", (String[])new String[]{realFtpDirectory}));
            }
        }
    }

    private void updateErrors() {
        ++this.NrErrors;
        if (!this.getStatus()) {
            this.successConditionBroken = true;
        }
    }

    private void updateDeletedFiles() {
        ++this.NrfilesDeleted;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public boolean isActiveConnection() {
        return this.activeConnection;
    }

    public void setActiveConnection(boolean passive) {
        this.activeConnection = passive;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        JobEntryValidatorUtils.andValidator().validate(this, "serverName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "targetDirectory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "userName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "password", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.serverName)) {
            String realServername = jobMeta.environmentSubstitute(this.serverName);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realServername, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    public String getSocksProxyHost() {
        return this.socksProxyHost;
    }

    public String getSocksProxyPort() {
        return this.socksProxyPort;
    }

    public String getSocksProxyUsername() {
        return this.socksProxyUsername;
    }

    public String getSocksProxyPassword() {
        return this.socksProxyPassword;
    }

    public void setSocksProxyHost(String socksProxyHost) {
        this.socksProxyHost = socksProxyHost;
    }

    public void setSocksProxyPort(String socksProxyPort) {
        this.socksProxyPort = socksProxyPort;
    }

    public void setSocksProxyUsername(String socksProxyUsername) {
        this.socksProxyUsername = socksProxyUsername;
    }

    public void setSocksProxyPassword(String socksProxyPassword) {
        this.socksProxyPassword = socksProxyPassword;
    }
}

