/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.dtdvalidator;

import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.dtdvalidator.DTDValidator;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryDTDValidator
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String xmlfilename = null;
    private String dtdfilename = null;
    private boolean dtdintern = false;

    public JobEntryDTDValidator(String n) {
        super(n, "");
    }

    public JobEntryDTDValidator() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryDTDValidator je = (JobEntryDTDValidator)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"xmlfilename", (String)this.xmlfilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"dtdfilename", (String)this.dtdfilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"dtdintern", (boolean)this.dtdintern));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.xmlfilename = XMLHandler.getTagValue((Node)entrynode, (String)"xmlfilename");
            this.dtdfilename = XMLHandler.getTagValue((Node)entrynode, (String)"dtdfilename");
            this.dtdintern = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"dtdintern"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'DTDvalidator' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.xmlfilename = rep.getJobEntryAttributeString(id_jobentry, "xmlfilename");
            this.dtdfilename = rep.getJobEntryAttributeString(id_jobentry, "dtdfilename");
            this.dtdintern = rep.getJobEntryAttributeBoolean(id_jobentry, "dtdintern");
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'DTDvalidator' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "xmlfilename", this.xmlfilename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "dtdfilename", this.dtdfilename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "dtdintern", this.dtdintern);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'DTDvalidator' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public String getRealxmlfilename() {
        return this.environmentSubstitute(this.xmlfilename);
    }

    public String getRealDTDfilename() {
        return this.environmentSubstitute(this.dtdfilename);
    }

    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(true);
        String realxmlfilename = this.getRealxmlfilename();
        String realDTDfilename = this.getRealDTDfilename();
        DTDValidator validator = new DTDValidator(this.log);
        validator.setXMLFilename(realxmlfilename);
        if (this.dtdintern) {
            validator.setInternDTD(true);
        } else {
            validator.setDTDFilename(realDTDfilename);
        }
        boolean status = validator.validate();
        if (!status) {
            this.log.logError(validator.getErrorMessage());
            result.setResult(false);
            result.setNrErrors((long)validator.getNrErrors());
            result.setLogText(validator.getErrorMessage());
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public void setxmlFilename(String filename) {
        this.xmlfilename = filename;
    }

    public String getxmlFilename() {
        return this.xmlfilename;
    }

    public void setdtdFilename(String filename) {
        this.dtdfilename = filename;
    }

    public String getdtdFilename() {
        return this.dtdfilename;
    }

    public boolean getDTDIntern() {
        return this.dtdintern;
    }

    public void setDTDIntern(boolean dtdinternin) {
        this.dtdintern = dtdinternin;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.dtdfilename) && !Const.isEmpty((String)this.xmlfilename)) {
            String realXmlFileName = jobMeta.environmentSubstitute(this.xmlfilename);
            String realXsdFileName = jobMeta.environmentSubstitute(this.dtdfilename);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realXmlFileName, ResourceEntry.ResourceType.FILE));
            reference.getEntries().add(new ResourceEntry(realXsdFileName, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "dtdfilename", remarks, ctx);
        JobEntryValidatorUtils.andValidator().validate(this, "xmlFilename", remarks, ctx);
    }
}

