/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.pentaho.di.core.util.Assert;
import org.pentaho.di.i18n.BaseMessages;

public final class PluginMessages {
    private static final Map<String, PluginMessages> MESSAGES_MAP = new HashMap<String, PluginMessages>();
    private final String packageName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PluginMessages getMessages(String packageName) throws IllegalArgumentException {
        Assert.assertNotBlank(packageName, "Package name cannot be blank");
        Class<PluginMessages> clazz = PluginMessages.class;
        synchronized (PluginMessages.class) {
            if (MESSAGES_MAP.containsKey(packageName)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return MESSAGES_MAP.get(packageName);
            }
            MESSAGES_MAP.put(packageName, new PluginMessages(packageName));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return MESSAGES_MAP.get(packageName);
        }
    }

    public static PluginMessages getMessages(Class<?> someClassInPackage) throws IllegalArgumentException {
        Assert.assertNotNull(someClassInPackage, "Class cannot be null");
        return PluginMessages.getMessages(someClassInPackage.getPackage().getName());
    }

    private PluginMessages(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getString(String key) {
        return BaseMessages.getString((String)this.packageName, (String)key);
    }

    public String getString(String key, String param1) {
        return BaseMessages.getString((String)this.packageName, (String)key, (String[])new String[]{param1});
    }

    public String getString(String key, String param1, String param2) {
        return BaseMessages.getString((String)this.packageName, (String)key, (String[])new String[]{param1, param2});
    }

    public String getString(String key, String param1, String param2, String param3) {
        return BaseMessages.getString((String)this.packageName, (String)key, (String[])new String[]{param1, param2, param3});
    }

    public String getString(String key, String param1, String param2, String param3, String param4) {
        return BaseMessages.getString((String)this.packageName, (String)key, (String[])new String[]{param1, param2, param3, param4});
    }

    public String getString(String key, String param1, String param2, String param3, String param4, String param5) {
        return BaseMessages.getString((String)this.packageName, (String)key, (String[])new String[]{param1, param2, param3, param4, param5});
    }

    public String getString(String key, String param1, String param2, String param3, String param4, String param5, String param6) {
        return BaseMessages.getString((String)this.packageName, (String)key, (String[])new String[]{param1, param2, param3, param4, param5, param6});
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("packageName", (Object)this.packageName);
        return builder.toString();
    }
}

