/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LogMessageInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.util.EnvUtil;

public class LogMessage
implements LogMessageInterface {
    private String logChannelId;
    private String message;
    private String subject;
    private Object[] arguments;
    private LogLevel level;
    private String copy;

    public LogMessage(String subject, LogLevel level) {
        this.subject = subject;
        this.level = level;
        this.message = null;
        this.logChannelId = null;
    }

    public LogMessage(String message, String logChannelId, LogLevel level) {
        this.message = message;
        this.logChannelId = logChannelId;
        this.level = level;
        this.lookupSubject();
    }

    public LogMessage(String message, String logChannelId, Object[] arguments, LogLevel level) {
        this.message = message;
        this.logChannelId = logChannelId;
        this.arguments = arguments;
        this.level = level;
        this.lookupSubject();
    }

    private void lookupSubject() {
        boolean detailedLogTurnOn;
        LoggingObjectInterface loggingObject = LoggingRegistry.getInstance().getLoggingObject(this.logChannelId);
        boolean bl = detailedLogTurnOn = "Y".equals(EnvUtil.getSystemProperty("KETTLE_LOG_MARK_MAPPINGS"));
        if (loggingObject != null) {
            this.subject = !detailedLogTurnOn ? loggingObject.getObjectName() : this.getDetailedSubject(loggingObject);
            this.copy = loggingObject.getObjectCopy();
        }
    }

    private String getDetailedSubject(LoggingObjectInterface loggingObject) {
        List<String> subjects = this.getSubjectTree(loggingObject);
        return subjects.size() > 1 ? this.formatDetailedSubject(subjects) : subjects.get(0);
    }

    private List<String> getSubjectTree(LoggingObjectInterface loggingObject) {
        ArrayList<String> subjects = new ArrayList<String>();
        while (loggingObject != null) {
            subjects.add(loggingObject.getObjectName());
            loggingObject = loggingObject.getParent();
        }
        return subjects;
    }

    private String formatDetailedSubject(List<String> subjects) {
        StringBuffer string = new StringBuffer();
        int currentStep = 0;
        int rootStep = subjects.size() - 1;
        for (int i = rootStep - 1; i > currentStep; --i) {
            string.append("[").append(subjects.get(i)).append("]").append(".");
        }
        string.append(subjects.get(currentStep));
        return string.toString();
    }

    @Deprecated
    public String toString() {
        if (this.message == null) {
            return this.subject;
        }
        if (this.arguments != null && this.arguments.length > 0) {
            return this.subject + " - " + MessageFormat.format(this.message, this.arguments);
        }
        return this.subject + " - " + this.message;
    }

    @Override
    public LogLevel getLevel() {
        return this.level;
    }

    @Deprecated
    public void setLevel(LogLevel level) {
        this.level = level;
    }

    @Override
    public String getMessage() {
        if (this.arguments != null && this.arguments.length > 0) {
            return MessageFormat.format(this.message, this.arguments);
        }
        return this.message;
    }

    @Deprecated
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Deprecated
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public String getLogChannelId() {
        return this.logChannelId;
    }

    @Deprecated
    public void setLogChannelId(String logChannelId) {
        this.logChannelId = logChannelId;
    }

    @Override
    public Object[] getArguments() {
        return this.arguments;
    }

    @Deprecated
    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    public boolean isError() {
        return this.level.isError();
    }

    @Override
    public String getCopy() {
        return this.copy;
    }

    public void setCopy(String copy) {
        this.copy = copy;
    }
}

