/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.KettleLoggingEvent;
import org.pentaho.di.core.logging.LogMessage;
import org.pentaho.di.version.BuildVersion;

public class KettleLogLayout {
    private static final ThreadLocal<SimpleDateFormat> LOCAL_SIMPLE_DATE_PARSER = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        }
    };
    public static final String ERROR_STRING = "ERROR";
    private boolean timeAdded;

    public KettleLogLayout() {
        this(true);
    }

    public KettleLogLayout(boolean addTime) {
        this.timeAdded = addTime;
    }

    public String format(KettleLoggingEvent event) {
        Object object;
        StringBuffer line = new StringBuffer();
        String dateTimeString = "";
        if (this.timeAdded) {
            dateTimeString = LOCAL_SIMPLE_DATE_PARSER.get().format(new Date(event.timeStamp)) + " - ";
        }
        if ((object = event.getMessage()) instanceof LogMessage) {
            LogMessage message = (LogMessage)object;
            String[] parts = message.getMessage() == null ? new String[]{} : message.getMessage().split(Const.CR);
            for (int i = 0; i < parts.length; ++i) {
                line.append(dateTimeString);
                if (message.getSubject() != null) {
                    line.append(message.getSubject());
                    if (message.getCopy() != null) {
                        line.append(".").append(message.getCopy());
                    }
                    line.append(" - ");
                }
                if (i == 0 && message.isError()) {
                    BuildVersion buildVersion = BuildVersion.getInstance();
                    line.append(ERROR_STRING);
                    line.append(" (version ");
                    line.append(buildVersion.getVersion());
                    if (!Const.isEmpty(buildVersion.getRevision())) {
                        line.append(", build ");
                        line.append(buildVersion.getRevision());
                    }
                    if (!Const.isEmpty(buildVersion.getBuildDate())) {
                        line.append(" from ");
                        line.append(buildVersion.getBuildDate());
                    }
                    if (!Const.isEmpty(buildVersion.getBuildUser())) {
                        line.append(" by ");
                        line.append(buildVersion.getBuildUser());
                    }
                    line.append(") : ");
                }
                line.append(parts[i]);
                if (i >= parts.length - 1) continue;
                line.append(Const.CR);
            }
        } else {
            line.append(dateTimeString);
            line.append(object != null ? object.toString() : "<null>");
        }
        return line.toString();
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public void activateOptions() {
    }

    public boolean isTimeAdded() {
        return this.timeAdded;
    }

    public void setTimeAdded(boolean addTime) {
        this.timeAdded = addTime;
    }
}

