/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.encryption;

import java.math.BigInteger;
import java.util.ArrayList;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.TwoWayPasswordEncoderInterface;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.StringUtil;

public class KettleTwoWayPasswordEncoder
implements TwoWayPasswordEncoderInterface {
    private static final int RADIX = 16;
    private static final String SEED = "0933910847463829827159347601486730416058";
    public static final String PASSWORD_ENCRYPTED_PREFIX = "Encrypted ";

    @Override
    public void init() throws KettleException {
    }

    @Override
    public String encode(String rawPassword) {
        return this.encode(rawPassword, true);
    }

    @Override
    public String encode(String rawPassword, boolean includePrefix) {
        if (includePrefix) {
            return KettleTwoWayPasswordEncoder.encryptPasswordIfNotUsingVariables(rawPassword);
        }
        return KettleTwoWayPasswordEncoder.encryptPassword(rawPassword);
    }

    @Override
    public String decode(String encodedPassword) {
        if (encodedPassword != null && encodedPassword.startsWith(PASSWORD_ENCRYPTED_PREFIX)) {
            encodedPassword = encodedPassword.substring(PASSWORD_ENCRYPTED_PREFIX.length());
        }
        return KettleTwoWayPasswordEncoder.decryptPassword(encodedPassword);
    }

    @Override
    public String decode(String encodedPassword, boolean optionallyEncrypted) {
        if (encodedPassword == null) {
            return null;
        }
        if (optionallyEncrypted) {
            if (encodedPassword.startsWith(PASSWORD_ENCRYPTED_PREFIX)) {
                encodedPassword = encodedPassword.substring(PASSWORD_ENCRYPTED_PREFIX.length());
                return KettleTwoWayPasswordEncoder.decryptPassword(encodedPassword);
            }
            return encodedPassword;
        }
        return KettleTwoWayPasswordEncoder.decryptPassword(encodedPassword);
    }

    public static final String encryptPassword(String password) {
        if (password == null) {
            return "";
        }
        if (password.length() == 0) {
            return "";
        }
        BigInteger bi_passwd = new BigInteger(password.getBytes());
        BigInteger bi_r0 = new BigInteger(SEED);
        BigInteger bi_r1 = bi_r0.xor(bi_passwd);
        return bi_r1.toString(16);
    }

    public static final String decryptPassword(String encrypted) {
        if (encrypted == null) {
            return "";
        }
        if (encrypted.length() == 0) {
            return "";
        }
        BigInteger bi_confuse = new BigInteger(SEED);
        try {
            BigInteger bi_r1 = new BigInteger(encrypted, 16);
            BigInteger bi_r0 = bi_r1.xor(bi_confuse);
            return new String(bi_r0.toByteArray());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String[] getPrefixes() {
        return new String[]{PASSWORD_ENCRYPTED_PREFIX};
    }

    public static final String encryptPasswordIfNotUsingVariables(String password) {
        String encrPassword = "";
        ArrayList<String> varList = new ArrayList<String>();
        StringUtil.getUsedVariables(password, varList, true);
        encrPassword = varList.isEmpty() ? PASSWORD_ENCRYPTED_PREFIX + KettleTwoWayPasswordEncoder.encryptPassword(password) : password;
        return encrPassword;
    }

    public static final String decryptPasswordOptionallyEncrypted(String password) {
        if (!Const.isEmpty(password) && password.startsWith(PASSWORD_ENCRYPTED_PREFIX)) {
            return KettleTwoWayPasswordEncoder.decryptPassword(password.substring(PASSWORD_ENCRYPTED_PREFIX.length()));
        }
        return password;
    }
}

