/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.PrintPart;
import net.sf.jasperreports.engine.PrintParts;

public class StandardPrintParts
implements PrintParts,
Serializable {
    private static final long serialVersionUID = 10200L;
    private NavigableMap<Integer, PrintPart> parts = new ConcurrentSkipListMap<Integer, PrintPart>();

    @Override
    public boolean hasParts() {
        return !this.parts.isEmpty();
    }

    @Override
    public int partCount() {
        return this.parts.size();
    }

    @Override
    public boolean startsAtZero() {
        if (!this.hasParts()) {
            return false;
        }
        return (Integer)this.parts.firstKey() == 0;
    }

    @Override
    public void addPart(int pageIndex, PrintPart part) {
        this.parts.put(pageIndex, part);
    }

    @Override
    public PrintPart removePart(int pageIndex) {
        return (PrintPart)this.parts.remove(pageIndex);
    }

    @Override
    public Iterator<Map.Entry<Integer, PrintPart>> partsIterator() {
        return this.parts.entrySet().iterator();
    }

    @Override
    public int getStartPageIndex(int partIndex) {
        int partStartPage = 0;
        Iterator it = this.parts.keySet().iterator();
        for (int i = 0; i <= partIndex && it.hasNext(); ++i) {
            partStartPage = (Integer)it.next();
        }
        return partStartPage;
    }

    @Override
    public int getPartIndex(int pageIndex) {
        Integer pgIdx;
        int partIndex = 0;
        Iterator it = this.parts.keySet().iterator();
        while (it.hasNext() && pageIndex >= (pgIdx = (Integer)it.next())) {
            ++partIndex;
        }
        return partIndex;
    }

    @Override
    public PrintPageFormat getPageFormat(int pageIndex) {
        Map.Entry<Integer, PrintPart> partEntry = this.parts.floorEntry(pageIndex);
        return partEntry == null ? null : partEntry.getValue().getPageFormat();
    }

    public StandardPrintParts shallowClone() {
        StandardPrintParts clone = new StandardPrintParts();
        clone.parts.putAll(this.parts);
        return clone;
    }
}

