/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import org.codehaus.janino.ClassFileIClass;
import org.codehaus.janino.CompileException;
import org.codehaus.janino.DebuggingInformation;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.FilterWarningHandler;
import org.codehaus.janino.IClass;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.Java;
import org.codehaus.janino.Location;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.UnitCompiler;
import org.codehaus.janino.WarningHandler;
import org.codehaus.janino.util.Benchmark;
import org.codehaus.janino.util.ClassFile;
import org.codehaus.janino.util.StringPattern;
import org.codehaus.janino.util.enumerator.EnumeratorFormatException;
import org.codehaus.janino.util.enumerator.EnumeratorSet;
import org.codehaus.janino.util.resource.DirectoryResourceCreator;
import org.codehaus.janino.util.resource.DirectoryResourceFinder;
import org.codehaus.janino.util.resource.FileResource;
import org.codehaus.janino.util.resource.FileResourceCreator;
import org.codehaus.janino.util.resource.PathResourceFinder;
import org.codehaus.janino.util.resource.Resource;
import org.codehaus.janino.util.resource.ResourceCreator;
import org.codehaus.janino.util.resource.ResourceFinder;

public class Compiler {
    private static final boolean DEBUG = false;
    private static final String[] USAGE = new String[]{"Usage:", "", "  java " + (class$org$codehaus$janino$Compiler == null ? (class$org$codehaus$janino$Compiler = Compiler.class$("org.codehaus.janino.Compiler")) : class$org$codehaus$janino$Compiler).getName() + " [ <option> ] ... <source-file> ...", "", "Supported <option>s are:", "  -d <output-dir>           Where to save class files", "  -sourcepath <dirlist>     Where to look for other source files", "  -classpath <dirlist>      Where to look for other class files", "  -extdirs <dirlist>        Where to look for other class files", "  -bootclasspath <dirlist>  Where to look for other class files", "  -encoding <encoding>      Encoding of source files, e.g. \"UTF-8\" or \"ISO-8859-1\"", "  -verbose", "  -g                        Generate all debugging info", "  -g:none                   Generate no debugging info", "  -g:{lines,vars,source}    Generate only some debugging info", "  -warn:<pattern-list>      Issue certain warnings; examples:", "    -warn:*                 Enables all warnings", "    -warn:IASF              Only warn against implicit access to static fields", "    -warn:*-IASF            Enables all warnings, except those against implicit", "                            access to static fields", "    -warn:*-IA*+IASF        Enables all warnings, except those against implicit", "                            accesses, but do warn against implicit access to", "                            static fields", "  -rebuild                  Compile all source files, even if the class files", "                            seems up-to-date", "  -help", "", "The default encoding in this environment is \"" + new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding() + "\"."};
    private ResourceFinder classFileFinder;
    public static final ResourceFinder FIND_NEXT_TO_SOURCE_FILE = null;
    private ResourceCreator classFileCreator;
    public static final ResourceCreator CREATE_NEXT_TO_SOURCE_FILE = null;
    private String optionalCharacterEncoding;
    private Benchmark benchmark;
    private EnumeratorSet debuggingInformation;
    private WarningHandler optionalWarningHandler;
    private UnitCompiler.ErrorHandler optionalCompileErrorHandler = null;
    private IClassLoader iClassLoader;
    private final ArrayList parsedCompilationUnits = new ArrayList();
    public static final File NO_DESTINATION_DIRECTORY = null;
    public static final StringPattern[] DEFAULT_WARNING_HANDLE_PATTERNS = StringPattern.PATTERNS_NONE;
    static /* synthetic */ Class class$org$codehaus$janino$DebuggingInformation;
    static /* synthetic */ Class class$org$codehaus$janino$Compiler;

    public static void main(String[] args) {
        String arg;
        int i;
        File destinationDirectory = NO_DESTINATION_DIRECTORY;
        File[] optionalSourcePath = null;
        File[] classPath = new File[]{new File(".")};
        File[] optionalExtDirs = null;
        File[] optionalBootClassPath = null;
        String optionalCharacterEncoding = null;
        boolean verbose = false;
        EnumeratorSet debuggingInformation = DebuggingInformation.DEFAULT_DEBUGGING_INFORMATION;
        StringPattern[] warningHandlePatterns = DEFAULT_WARNING_HANDLE_PATTERNS;
        boolean rebuild = false;
        for (i = 0; i < args.length && (arg = args[i]).charAt(0) == '-'; ++i) {
            if (arg.equals("-d")) {
                destinationDirectory = new File(args[++i]);
                continue;
            }
            if (arg.equals("-sourcepath")) {
                optionalSourcePath = PathResourceFinder.parsePath(args[++i]);
                continue;
            }
            if (arg.equals("-classpath")) {
                classPath = PathResourceFinder.parsePath(args[++i]);
                continue;
            }
            if (arg.equals("-extdirs")) {
                optionalExtDirs = PathResourceFinder.parsePath(args[++i]);
                continue;
            }
            if (arg.equals("-bootclasspath")) {
                optionalBootClassPath = PathResourceFinder.parsePath(args[++i]);
                continue;
            }
            if (arg.equals("-encoding")) {
                optionalCharacterEncoding = args[++i];
                continue;
            }
            if (arg.equals("-verbose")) {
                verbose = true;
                continue;
            }
            if (arg.equals("-g")) {
                debuggingInformation = DebuggingInformation.ALL;
                continue;
            }
            if (arg.startsWith("-g:")) {
                try {
                    debuggingInformation = new EnumeratorSet(class$org$codehaus$janino$DebuggingInformation == null ? Compiler.class$("org.codehaus.janino.DebuggingInformation") : class$org$codehaus$janino$DebuggingInformation, arg.substring(3));
                }
                catch (EnumeratorFormatException ex) {
                    System.err.println("Invalid debugging option \"" + arg + "\", only \"" + DebuggingInformation.ALL + "\" allowed");
                    System.exit(1);
                }
                continue;
            }
            if (arg.startsWith("-warn:")) {
                warningHandlePatterns = StringPattern.parseCombinedPattern(arg.substring(6));
                continue;
            }
            if (arg.equals("-rebuild")) {
                rebuild = true;
                continue;
            }
            if (arg.equals("-help")) {
                for (int j = 0; j < USAGE.length; ++j) {
                    System.out.println(USAGE[j]);
                }
                System.exit(1);
                continue;
            }
            System.err.println("Unrecognized command line option \"" + arg + "\"; try \"-help\".");
            System.exit(1);
        }
        if (i == args.length) {
            System.err.println("No source files given on command line; try \"-help\".");
            System.exit(1);
        }
        File[] sourceFiles = new File[args.length - i];
        for (int j = i; j < args.length; ++j) {
            sourceFiles[j - i] = new File(args[j]);
        }
        Compiler compiler = new Compiler(optionalSourcePath, classPath, optionalExtDirs, optionalBootClassPath, destinationDirectory, optionalCharacterEncoding, verbose, debuggingInformation, warningHandlePatterns, rebuild);
        try {
            compiler.compile(sourceFiles);
        }
        catch (Exception e) {
            System.err.println(e.toString());
            System.exit(1);
        }
    }

    public Compiler(File[] optionalSourcePath, File[] classPath, File[] optionalExtDirs, File[] optionalBootClassPath, File destinationDirectory, String optionalCharacterEncoding, boolean verbose, EnumeratorSet debuggingInformation, StringPattern[] warningHandlePatterns, boolean rebuild) {
        this(new PathResourceFinder(optionalSourcePath == null ? classPath : optionalSourcePath), IClassLoader.createJavacLikePathIClassLoader(optionalBootClassPath, optionalExtDirs, classPath), rebuild ? ResourceFinder.EMPTY_RESOURCE_FINDER : (destinationDirectory == NO_DESTINATION_DIRECTORY ? FIND_NEXT_TO_SOURCE_FILE : new DirectoryResourceFinder(destinationDirectory)), destinationDirectory == NO_DESTINATION_DIRECTORY ? CREATE_NEXT_TO_SOURCE_FILE : new DirectoryResourceCreator(destinationDirectory), optionalCharacterEncoding, verbose, debuggingInformation, new FilterWarningHandler(warningHandlePatterns, new SimpleWarningHandler()));
        this.benchmark.report("*** JANINO - an embedded compiler for the Java(TM) programming language");
        this.benchmark.report("*** For more information visit http://janino.codehaus.org");
        this.benchmark.report("Source path", optionalSourcePath);
        this.benchmark.report("Class path", classPath);
        this.benchmark.report("Ext dirs", optionalExtDirs);
        this.benchmark.report("Boot class path", optionalBootClassPath);
        this.benchmark.report("Destination directory", destinationDirectory);
        this.benchmark.report("Character encoding", optionalCharacterEncoding);
        this.benchmark.report("Verbose", new Boolean(verbose));
        this.benchmark.report("Debugging information", debuggingInformation);
        this.benchmark.report("Warning handle patterns", warningHandlePatterns);
        this.benchmark.report("Rebuild", new Boolean(rebuild));
    }

    public Compiler(ResourceFinder sourceFinder, IClassLoader iClassLoader, ResourceFinder classFileFinder, ResourceCreator classFileCreator, String optionalCharacterEncoding, boolean verbose, EnumeratorSet debuggingInformation, WarningHandler optionalWarningHandler) {
        this.classFileFinder = classFileFinder;
        this.classFileCreator = classFileCreator;
        this.optionalCharacterEncoding = optionalCharacterEncoding;
        this.benchmark = new Benchmark(verbose);
        this.debuggingInformation = debuggingInformation;
        this.optionalWarningHandler = optionalWarningHandler;
        this.iClassLoader = new CompilerIClassLoader(sourceFinder, iClassLoader);
    }

    public void setCompileErrorHandler(UnitCompiler.ErrorHandler optionalCompileErrorHandler) {
        this.optionalCompileErrorHandler = optionalCompileErrorHandler;
    }

    public boolean compile(File[] sourceFiles) throws Scanner.ScanException, Parser.ParseException, CompileException, IOException {
        this.benchmark.report("Source files", sourceFiles);
        Resource[] sourceFileResources = new Resource[sourceFiles.length];
        for (int i = 0; i < sourceFiles.length; ++i) {
            sourceFileResources[i] = new FileResource(sourceFiles[i]);
        }
        this.compile(sourceFileResources);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compile(Resource[] sourceResources) throws Scanner.ScanException, Parser.ParseException, CompileException, IOException {
        UnitCompiler.ErrorHandler ceh = this.optionalCompileErrorHandler != null ? this.optionalCompileErrorHandler : new UnitCompiler.ErrorHandler(){
            int compileErrorCount = 0;

            public void handleError(String message, Location optionalLocation) throws CompileException {
                CompileException ex = new CompileException(message, optionalLocation);
                if (++this.compileErrorCount >= 20) {
                    throw ex;
                }
                System.err.println(ex.getMessage());
            }
        };
        this.benchmark.beginReporting();
        try {
            int i;
            this.parsedCompilationUnits.clear();
            for (i = 0; i < sourceResources.length; ++i) {
                this.parsedCompilationUnits.add(new UnitCompiler(this.parseCompilationUnit(sourceResources[i].getFileName(), new BufferedInputStream(sourceResources[i].open()), this.optionalCharacterEncoding), this.iClassLoader));
            }
            for (i = 0; i < this.parsedCompilationUnits.size(); ++i) {
                ClassFile[] classFiles;
                UnitCompiler unitCompiler = (UnitCompiler)this.parsedCompilationUnits.get(i);
                Java.CompilationUnit cu = unitCompiler.compilationUnit;
                if (cu.optionalFileName == null) {
                    throw new RuntimeException();
                }
                File sourceFile = new File(cu.optionalFileName);
                unitCompiler.setCompileErrorHandler(ceh);
                unitCompiler.setWarningHandler(this.optionalWarningHandler);
                this.benchmark.beginReporting("Compiling compilation unit \"" + sourceFile + "\"");
                try {
                    classFiles = unitCompiler.compileUnit(this.debuggingInformation);
                }
                finally {
                    this.benchmark.endReporting();
                }
                this.benchmark.beginReporting("Storing " + classFiles.length + " class file(s) resulting from compilation unit \"" + sourceFile + "\"");
                try {
                    for (int j = 0; j < classFiles.length; ++j) {
                        this.storeClassFile(classFiles[j], sourceFile);
                    }
                    continue;
                }
                finally {
                    this.benchmark.endReporting();
                }
            }
        }
        finally {
            this.benchmark.endReporting("Compiled " + this.parsedCompilationUnits.size() + " compilation unit(s)");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Java.CompilationUnit parseCompilationUnit(String fileName, InputStream inputStream, String optionalCharacterEncoding) throws Scanner.ScanException, Parser.ParseException, IOException {
        try {
            Scanner scanner = new Scanner(fileName, inputStream, optionalCharacterEncoding);
            scanner.setWarningHandler(this.optionalWarningHandler);
            Parser parser = new Parser(scanner);
            parser.setWarningHandler(this.optionalWarningHandler);
            this.benchmark.beginReporting("Parsing \"" + fileName + "\"");
            try {
                Java.CompilationUnit compilationUnit = parser.parseCompilationUnit();
                this.benchmark.endReporting();
                return compilationUnit;
            }
            catch (Throwable throwable) {
                this.benchmark.endReporting();
                throw throwable;
            }
        }
        finally {
            inputStream.close();
        }
    }

    public static File getClassFile(String className, File sourceFile, File optionalDestinationDirectory) {
        if (optionalDestinationDirectory != null) {
            return new File(optionalDestinationDirectory, ClassFile.getClassFileResourceName(className));
        }
        int idx = className.lastIndexOf(46);
        return new File(sourceFile.getParentFile(), ClassFile.getClassFileResourceName(className.substring(idx + 1)));
    }

    public void storeClassFile(ClassFile classFile, final File sourceFile) throws IOException {
        String classFileResourceName = ClassFile.getClassFileResourceName(classFile.getThisClassName());
        ResourceCreator rc = this.classFileCreator != CREATE_NEXT_TO_SOURCE_FILE ? this.classFileCreator : new FileResourceCreator(){

            protected File getFile(String resourceName) {
                return new File(sourceFile.getParentFile(), resourceName.substring(resourceName.lastIndexOf(47) + 1));
            }
        };
        OutputStream os = rc.createResource(classFileResourceName);
        try {
            classFile.store(os);
        }
        catch (IOException ex) {
            try {
                os.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            os = null;
            if (!rc.deleteResource(classFileResourceName)) {
                throw new IOException("Could not delete incompletely written class file \"" + classFileResourceName + "\"");
            }
            throw ex;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CompilerIClassLoader
    extends IClassLoader {
        private final ResourceFinder sourceFinder;

        public CompilerIClassLoader(ResourceFinder sourceFinder, IClassLoader optionalParentIClassLoader) {
            super(optionalParentIClassLoader);
            this.sourceFinder = sourceFinder;
            super.postConstruct();
        }

        protected IClass findIClass(String type) throws ClassNotFoundException {
            Resource classFileResource;
            String className = Descriptor.toClassName(type);
            if (className.startsWith("java.")) {
                return null;
            }
            int idx = className.indexOf(36);
            String topLevelClassName = idx == -1 ? className : className.substring(0, idx);
            for (int i = 0; i < Compiler.this.parsedCompilationUnits.size(); ++i) {
                UnitCompiler uc = (UnitCompiler)Compiler.this.parsedCompilationUnits.get(i);
                IClass res = uc.findClass(topLevelClassName);
                if (res == null) continue;
                if (!className.equals(topLevelClassName) && (res = uc.findClass(className)) == null) {
                    return null;
                }
                this.defineIClass(res);
                return res;
            }
            Resource sourceResource = this.sourceFinder.findResource(ClassFile.getSourceResourceName(className));
            if (sourceResource == null) {
                return null;
            }
            if (Compiler.this.classFileFinder != FIND_NEXT_TO_SOURCE_FILE) {
                classFileResource = Compiler.this.classFileFinder.findResource(ClassFile.getClassFileResourceName(className));
            } else {
                if (!(sourceResource instanceof FileResource)) {
                    return null;
                }
                File classFile = new File(((FileResource)sourceResource).getFile().getParentFile(), ClassFile.getClassFileResourceName(className.substring(className.lastIndexOf(46) + 1)));
                Resource resource = classFileResource = classFile.exists() ? new FileResource(classFile) : null;
            }
            if (classFileResource != null && sourceResource.lastModified() <= classFileResource.lastModified()) {
                return this.defineIClassFromClassFileResource(classFileResource);
            }
            return this.defineIClassFromSourceResource(sourceResource, className);
        }

        private IClass defineIClassFromSourceResource(Resource sourceResource, String className) throws ClassNotFoundException {
            UnitCompiler uc;
            try {
                Java.CompilationUnit cu = Compiler.this.parseCompilationUnit(sourceResource.getFileName(), new BufferedInputStream(sourceResource.open()), Compiler.this.optionalCharacterEncoding);
                uc = new UnitCompiler(cu, Compiler.this.iClassLoader);
            }
            catch (IOException ex) {
                throw new ClassNotFoundException("Parsing compilation unit \"" + sourceResource + "\"", ex);
            }
            catch (Parser.ParseException ex) {
                throw new ClassNotFoundException("Parsing compilation unit \"" + sourceResource + "\"", ex);
            }
            catch (Scanner.ScanException ex) {
                throw new ClassNotFoundException("Parsing compilation unit \"" + sourceResource + "\"", ex);
            }
            catch (CompileException ex) {
                throw new ClassNotFoundException("Parsing compilation unit \"" + sourceResource + "\"", ex);
            }
            Compiler.this.parsedCompilationUnits.add(uc);
            IClass res = uc.findClass(className);
            if (res == null) {
                return null;
            }
            this.defineIClass(res);
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IClass defineIClassFromClassFileResource(Resource classFileResource) throws ClassNotFoundException {
            Compiler.this.benchmark.beginReporting("Loading class file \"" + classFileResource.getFileName() + "\"");
            try {
                ClassFile cf;
                InputStream is = null;
                try {
                    is = classFileResource.open();
                    cf = new ClassFile(new BufferedInputStream(is));
                }
                catch (IOException ex) {
                    throw new ClassNotFoundException("Opening class file resource \"" + classFileResource + "\"", ex);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {}
                    }
                }
                ClassFileIClass result = new ClassFileIClass(cf, this);
                this.defineIClass(result);
                result.resolveAllClasses();
                ClassFileIClass classFileIClass = result;
                return classFileIClass;
            }
            finally {
                Compiler.this.benchmark.endReporting();
            }
        }
    }

    public static class SimpleWarningHandler
    implements WarningHandler {
        public void handleWarning(String handle, String message, Location optionalLocation) {
            StringBuffer sb = new StringBuffer();
            if (optionalLocation != null) {
                sb.append(optionalLocation).append(": ");
            }
            sb.append("Warning ").append(handle).append(": ").append(message);
            System.err.println(sb.toString());
        }
    }
}

