/*
 * Decompiled with CFR 0.152.
 */
package de.his.utils.string.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RightsParser {
    public static final char RIGHTS_PARAM_START = '[';
    public static final char RIGHTS_PARAM_END = ']';
    public static final String RIGHTS_SEPARATOR = ",";
    public static final String RIGHTS_PARAM_SEPARATOR = ";";
    public static final char RIGHTS_PARAM_KEY_VALUE_SEPARATOR = '=';
    private static final String PAT_PARAMETER_KEY = "[\\w\\.]+";
    private static final String PAT_PARAMETER_VALUE = "([\\w\\.]+,)*[\\w\\.]+";
    private static final String PAT_PARAMETER = "\\[([\\w\\.]+=([\\w\\.]+,)*[\\w\\.]+;)*[\\w\\.]+=([\\w\\.]+,)*[\\w\\.]+\\]";
    public static final Pattern HIS1_RIGHTS_PATTERN = Pattern.compile("^RIGHT_\\w+(\\[([\\w\\.]+=([\\w\\.]+,)*[\\w\\.]+;)*[\\w\\.]+=([\\w\\.]+,)*[\\w\\.]+\\]){0,1}");
    private final String rights;

    public RightsParser(String rights) {
        this.rights = rights;
    }

    public Map<String, Map<String, String>> parse() {
        return this.rights != null ? this.parseHis1Rights(this.rights) : new HashMap();
    }

    private Map<String, Map<String, String>> parseHis1Rights(String h1rights) {
        HashMap<String, Map<String, String>> his1Rights = new HashMap<String, Map<String, String>>();
        List<String> rightsList = RightsParser.splitRights(h1rights);
        for (String r : rightsList) {
            int paramStartIndex = r.indexOf(91);
            int paramEndIndex = r.indexOf(93);
            String right = paramStartIndex != -1 ? r.substring(0, paramStartIndex) : r;
            if (!this.looksLikeHis1Right(right)) continue;
            Map<String, String> params = paramStartIndex != -1 && paramEndIndex != -1 ? this.parseHis1RightParameters(r.substring(paramStartIndex + 1, paramEndIndex).trim()) : null;
            his1Rights.put(right, params);
        }
        return his1Rights;
    }

    private Map<String, String> parseHis1RightParameters(String params) {
        String[] parameters;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String param : parameters = params.split(RIGHTS_PARAM_SEPARATOR)) {
            int sepIndex = param.indexOf(61);
            if (sepIndex == -1) continue;
            String key = param.substring(0, sepIndex).trim();
            String value = param.substring(sepIndex + 1).trim();
            result.put(key, value);
        }
        return result;
    }

    private static List<String> splitRights(String rights) {
        int pos;
        StringBuilder r = new StringBuilder();
        r.append(rights);
        ArrayList<String> result = new ArrayList<String>();
        int length = rights.length();
        int lastPos = 0;
        boolean inRightsParameters = false;
        for (pos = 0; pos < length; ++pos) {
            char lookingAt = r.charAt(pos);
            if (lookingAt == '[') {
                inRightsParameters = true;
                continue;
            }
            if (lookingAt == ']') {
                inRightsParameters = false;
                continue;
            }
            if (inRightsParameters || lookingAt != RIGHTS_SEPARATOR.charAt(0)) continue;
            result.add(r.substring(lastPos, pos));
            lastPos = pos + 1;
        }
        result.add(r.substring(lastPos, pos));
        return result;
    }

    public boolean looksLikeHis1Right(String someString) {
        Matcher m = HIS1_RIGHTS_PATTERN.matcher(someString);
        return m.matches();
    }
}

