/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.fonts.Positionable;
import org.apache.fop.complexscripts.fonts.Substitutable;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.Typeface;

public class Font
implements Substitutable,
Positionable {
    public static final int WEIGHT_EXTRA_BOLD = 800;
    public static final int WEIGHT_BOLD = 700;
    public static final int WEIGHT_NORMAL = 400;
    public static final int WEIGHT_LIGHT = 200;
    public static final String STYLE_NORMAL = "normal";
    public static final String STYLE_ITALIC = "italic";
    public static final String STYLE_OBLIQUE = "oblique";
    public static final String STYLE_INCLINED = "inclined";
    public static final int PRIORITY_DEFAULT = 0;
    public static final FontTriplet DEFAULT_FONT = new FontTriplet("any", "normal", 400, 0);
    private static Log log = LogFactory.getLog(Font.class);
    private final String fontName;
    private final FontTriplet triplet;
    private final int fontSize;
    private final FontMetrics metric;

    public Font(String key, FontTriplet triplet, FontMetrics met, int fontSize) {
        this.fontName = key;
        this.triplet = triplet;
        this.metric = met;
        this.fontSize = fontSize;
    }

    public FontMetrics getFontMetrics() {
        return this.metric;
    }

    public boolean isMultiByte() {
        return this.getFontMetrics().isMultiByte();
    }

    public int getAscender() {
        return this.metric.getAscender(this.fontSize) / 1000;
    }

    public int getCapHeight() {
        return this.metric.getCapHeight(this.fontSize) / 1000;
    }

    public int getDescender() {
        return this.metric.getDescender(this.fontSize) / 1000;
    }

    public String getFontName() {
        return this.fontName;
    }

    public FontTriplet getFontTriplet() {
        return this.triplet;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public int getXHeight() {
        return this.metric.getXHeight(this.fontSize) / 1000;
    }

    public boolean hasKerning() {
        return this.metric.hasKerningInfo();
    }

    public boolean hasFeature(int tableType, String script, String language, String feature) {
        return this.metric.hasFeature(tableType, script, language, feature);
    }

    public Map<Integer, Map<Integer, Integer>> getKerning() {
        if (this.metric.hasKerningInfo()) {
            return this.metric.getKerningInfo();
        }
        return Collections.emptyMap();
    }

    public int getKernValue(char ch1, char ch2) {
        Integer width;
        Map<Integer, Integer> kernPair = this.getKerning().get(ch1);
        if (kernPair != null && (width = kernPair.get(ch2)) != null) {
            return width * this.getFontSize() / 1000;
        }
        return 0;
    }

    public int getKernValue(int ch1, int ch2) {
        if (ch1 > 65536) {
            return 0;
        }
        if (ch1 >= 55296 && ch1 <= 57344) {
            return 0;
        }
        if (ch2 > 65536) {
            return 0;
        }
        if (ch2 >= 55296 && ch2 <= 57344) {
            return 0;
        }
        return this.getKernValue((char)ch1, (char)ch2);
    }

    public int getWidth(int charnum) {
        return this.metric.getWidth(charnum, this.fontSize) / 1000;
    }

    public char mapChar(char c) {
        if (this.metric instanceof Typeface) {
            return ((Typeface)this.metric).mapChar(c);
        }
        char d = CodePointMapping.getMapping("WinAnsiEncoding").mapChar(c);
        if (d != '\u0000') {
            c = d;
        } else {
            log.warn((Object)("Glyph " + c + " not available in font " + this.fontName));
            c = (char)35;
        }
        return c;
    }

    public boolean hasChar(char c) {
        if (this.metric instanceof Typeface) {
            return ((Typeface)this.metric).hasChar(c);
        }
        return CodePointMapping.getMapping("WinAnsiEncoding").mapChar(c) > '\u0000';
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(super.toString());
        sbuf.append('{');
        sbuf.append(this.fontName);
        sbuf.append(',');
        sbuf.append(this.fontSize);
        sbuf.append('}');
        return sbuf.toString();
    }

    public int getCharWidth(char c) {
        int width;
        if (c == '\n' || c == '\r' || c == '\t' || c == '\u00a0') {
            width = this.getCharWidth(' ');
        } else {
            if (this.hasChar(c)) {
                char mappedChar = this.mapChar(c);
                width = this.getWidth(mappedChar);
            } else {
                width = -1;
            }
            if (width <= 0) {
                int em = this.getFontSize();
                int en = em / 2;
                width = c == ' ' ? em : (c == '\u2000' ? en : (c == '\u2001' ? em : (c == '\u2002' ? em / 2 : (c == '\u2003' ? this.getFontSize() : (c == '\u2004' ? em / 3 : (c == '\u2005' ? em / 4 : (c == '\u2006' ? em / 6 : (c == '\u2007' ? this.getCharWidth('0') : (c == '\u2008' ? this.getCharWidth('.') : (c == '\u2009' ? em / 5 : (c == '\u200a' ? em / 10 : (c == '\u200b' ? 0 : (c == '\u202f' ? this.getCharWidth(' ') / 2 : (c == '\u2060' ? 0 : (c == '\u3000' ? this.getCharWidth(' ') * 2 : (c == '\ufeff' ? 0 : this.getWidth(this.mapChar(c))))))))))))))))));
            }
        }
        return width;
    }

    public int getCharWidth(int c) {
        if (c < 65536) {
            return this.getCharWidth((char)c);
        }
        return -1;
    }

    public int getWordWidth(String word) {
        if (word == null) {
            return 0;
        }
        int wordLength = word.length();
        int width = 0;
        char[] characters = new char[wordLength];
        word.getChars(0, wordLength, characters, 0);
        for (int i = 0; i < wordLength; ++i) {
            width += this.getCharWidth(characters[i]);
        }
        return width;
    }

    @Override
    public boolean performsSubstitution() {
        if (this.metric instanceof Substitutable) {
            Substitutable s = (Substitutable)((Object)this.metric);
            return s.performsSubstitution();
        }
        return false;
    }

    @Override
    public CharSequence performSubstitution(CharSequence cs, String script, String language, List associations, boolean retainControls) {
        if (this.metric instanceof Substitutable) {
            Substitutable s = (Substitutable)((Object)this.metric);
            return s.performSubstitution(cs, script, language, associations, retainControls);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public CharSequence reorderCombiningMarks(CharSequence cs, int[][] gpa, String script, String language, List associations) {
        if (this.metric instanceof Substitutable) {
            Substitutable s = (Substitutable)((Object)this.metric);
            return s.reorderCombiningMarks(cs, gpa, script, language, associations);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean performsPositioning() {
        if (this.metric instanceof Positionable) {
            Positionable p = (Positionable)((Object)this.metric);
            return p.performsPositioning();
        }
        return false;
    }

    @Override
    public int[][] performPositioning(CharSequence cs, String script, String language, int fontSize) {
        if (this.metric instanceof Positionable) {
            Positionable p = (Positionable)((Object)this.metric);
            return p.performPositioning(cs, script, language, fontSize);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int[][] performPositioning(CharSequence cs, String script, String language) {
        return this.performPositioning(cs, script, language, this.fontSize);
    }
}

