/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.dbforms.config.FieldValue;
import org.dbforms.taglib.DbFilterTag;
import org.dbforms.taglib.DbFilterValueTag;
import org.dbforms.taglib.TagSupportWithScriptHandler;
import org.dbforms.util.ParseUtil;

public class DbFilterConditionTag
extends TagSupportWithScriptHandler
implements TryCatchFinally {
    private transient State state = new State();

    public void setLabel(String string) {
        this.state.label = string;
    }

    public String getLabel() {
        return this.state.label;
    }

    public int doAfterBody() throws JspException {
        if (this.bodyContent != null) {
            this.state.filterCondition = this.bodyContent.getString().trim();
        }
        return 0;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public void doFinally() {
        this.state = new State();
    }

    public int doStartTag() throws JspException {
        int selId;
        this.init();
        String sel = ParseUtil.getParameter((HttpServletRequest)this.pageContext.getRequest(), ((DbFilterTag)this.getParent()).getFilterName() + "_sel");
        if (sel != null && (selId = Integer.parseInt(sel)) == this.state.conditionId) {
            return 2;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof DbFilterConditionTag && this.state.conditionId == ((DbFilterConditionTag)((Object)obj)).state.conditionId;
    }

    public int hashCode() {
        return this.state.conditionId;
    }

    protected static String getConditionName(int tableId, int conditionId) {
        return DbFilterTag.getFilterName(tableId) + "_cond_" + conditionId;
    }

    protected static String getSqlFilter(HttpServletRequest request, int tableId, int conditionId) {
        return ParseUtil.getParameter(request, DbFilterTag.getFilterName(tableId) + "_cond_" + conditionId);
    }

    protected static FieldValue[] getSqlFilterParams(HttpServletRequest request, int tableId, int conditionId) {
        return DbFilterValueTag.readValuesFromRequest(request, tableId, conditionId);
    }

    protected String getConditionName() {
        return DbFilterConditionTag.getConditionName(((DbFilterTag)this.getParent()).getTableId(), this.state.conditionId);
    }

    protected void setState(PageContext pg, DbFilterTag parent, State state) {
        this.setParent((Tag)parent);
        this.setPageContext(pg);
        this.state = state;
    }

    protected State getState() {
        return this.state;
    }

    protected int addValue(DbFilterValueTag value) {
        this.state.values.add(value.getState());
        return this.state.values.size() - 1;
    }

    protected StringBuffer render() throws JspException {
        StringBuffer buf = new StringBuffer();
        buf.append("<input type=\"hidden\" name=\"" + ((DbFilterTag)this.getParent()).getFilterName() + "_cond_" + this.state.conditionId + "\" value=\"" + this.state.filterCondition + "\" />\n");
        DbFilterValueTag value = new DbFilterValueTag();
        Iterator i = this.state.values.iterator();
        while (i.hasNext()) {
            value.setState(this.pageContext, this, (DbFilterValueTag.State)i.next());
            buf.append(value.render());
        }
        return buf;
    }

    private void init() {
        this.state.values = new ArrayList();
        this.state.conditionId = ((DbFilterTag)this.getParent()).addCondition(this);
        this.state.filterCondition = null;
        if (this.state.label == null) {
            this.state.label = Integer.toString(this.state.conditionId);
        }
    }

    protected static class State {
        protected ArrayList values = null;
        protected String filterCondition = null;
        protected String label = null;
        protected int conditionId = -1;

        protected State() {
        }
    }
}

