/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.AccessControlException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.ValidatorResourcesInitializer;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.dbforms.config.ConfigLoader;
import org.dbforms.config.DbFormsConfig;
import org.dbforms.config.DbFormsConfigRegistry;
import org.dbforms.config.DbFormsErrors;
import org.dbforms.util.MessageResources;
import org.dbforms.util.Util;
import org.xml.sax.SAXException;

public class ConfigServlet
extends HttpServlet {
    private static Log logCat;
    private transient ConfigLoader loader = new ConfigLoader();
    static /* synthetic */ Class class$org$dbforms$servlets$ConfigServlet;

    public void destroy() {
        this.log("finalizing");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.process(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.process(request, response);
    }

    public void init() throws ServletException {
        try {
            this.initLogging();
            this.loader.setFieldClassName(this.getServletConfig().getInitParameter("className.Field"));
            this.loader.setTableClassName(this.getServletConfig().getInitParameter("className.Table"));
            this.loader.setQueryClassName(this.getServletConfig().getInitParameter("className.Query"));
            this.loader.setForeignKeyClassName(this.getServletConfig().getInitParameter("className.ForeignKey"));
            this.loader.setReferenceClassName(this.getServletConfig().getInitParameter("className.Reference"));
            this.initXMLConfig();
            this.initXMLErrors();
            this.initXMLValidator();
            this.initApplicationResources();
            this.initLocaleKey();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initLogging() {
        String configurationStr = this.getServletConfig().getInitParameter("log4j.configuration");
        boolean usingURL = true;
        if (!Util.isNull(configurationStr)) {
            block7: {
                try {
                    InputStream fis = this.getServletContext().getResourceAsStream(configurationStr);
                    if (fis != null) {
                        try {
                            Properties log4jProperties = new Properties();
                            log4jProperties.load(fis);
                            LogManager.resetConfiguration();
                            PropertyConfigurator.configure((Properties)log4jProperties);
                            break block7;
                        }
                        finally {
                            fis.close();
                        }
                    }
                    System.err.println("ConfigServlet::initLogging - log4j.configuration not found!");
                }
                catch (IOException e) {
                    System.err.println("ConfigServlet::initLogging - log4j.properties not found!");
                    PropertyConfigurator.configure((String)configurationStr);
                    usingURL = false;
                }
            }
            logCat = LogFactory.getLog((String)(class$org$dbforms$servlets$ConfigServlet == null ? (class$org$dbforms$servlets$ConfigServlet = ConfigServlet.class$("org.dbforms.servlets.ConfigServlet")) : class$org$dbforms$servlets$ConfigServlet).getName());
            logCat.info((Object)("### LOGGING INITALIZED, USING URL: " + usingURL + " ###" + configurationStr));
        }
    }

    protected void initApplicationResources() {
        logCat.info((Object)"initialize Application Resources.");
        String value = this.getServletConfig().getInitParameter("resourceBundle");
        if (value == null) {
            logCat.warn((Object)" Application Resources file not setted in Web.xml, ApplicationResources handler disabled!");
            return;
        }
        MessageResources.setSubClass(value);
        logCat.info((Object)" DbForms Application Resources : SubClass initialized ");
    }

    protected void initLocaleKey() {
        logCat.info((Object)"initialize Locale Key for session attribute.");
        String value = this.getServletConfig().getInitParameter("localeKey");
        if (value == null) {
            logCat.warn((Object)(" Locale Key not setted, use \"" + MessageResources.LOCALE_KEY + "\" as key to access the Locale in session scope."));
        } else {
            MessageResources.LOCALE_KEY = value.trim();
            logCat.info((Object)(" Locale Key setted with \"" + MessageResources.LOCALE_KEY + "\" as key to access the Locale in session scope."));
        }
    }

    protected void initXMLConfig() throws IOException, ServletException {
        String value = this.getServletConfig().getInitParameter("dbformsConfig");
        this.loader.setConfig(value);
        String[] s = StringUtils.split((String)this.loader.getConfig(), (String)",");
        for (int i = 0; i < s.length; ++i) {
            this.initXMLConfigFile(s[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initXMLConfigFile(String config) throws IOException, ServletException {
        String realPath = this.getServletContext().getRealPath("/");
        InputStream input = this.getServletContext().getResourceAsStream(config);
        if (input == null) {
            throw new UnavailableException("configMissing");
        }
        try {
            DbFormsConfigRegistry registry = DbFormsConfigRegistry.instance();
            DbFormsConfig dbFormsConfig = null;
            try {
                dbFormsConfig = registry.lookup();
            }
            catch (Exception e) {
                dbFormsConfig = null;
            }
            if (dbFormsConfig == null) {
                dbFormsConfig = new DbFormsConfig(realPath);
                dbFormsConfig.setServletConfig(this.getServletConfig());
                registry.setServletContext(this.getServletContext());
                registry.register(dbFormsConfig);
            }
            try {
                this.loader.loadConfig(input, dbFormsConfig);
            }
            catch (SAXException e) {
                logCat.error((Object)"::initXMLConfig - SaxException", (Throwable)e);
                throw new ServletException(e.toString());
            }
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initXMLErrors() throws IOException, ServletException {
        logCat.info((Object)"initialize XML Errors.");
        String value = this.getServletConfig().getInitParameter("dbformsErrors");
        this.loader.setErrors(value);
        InputStream input = this.getServletContext().getResourceAsStream(this.loader.getErrors());
        if (input == null) {
            logCat.warn((Object)"XML Errors file not found, XML error handler disabled!");
            return;
        }
        try {
            DbFormsErrors dbFormsErrors = new DbFormsErrors();
            dbFormsErrors.setServletConfig(this.getServletConfig());
            this.getServletContext().setAttribute("dbformsErrors", (Object)dbFormsErrors);
            try {
                this.loader.loadErrors(input, dbFormsErrors);
            }
            catch (SAXException e) {
                throw new ServletException(e.toString());
            }
            logCat.info((Object)("DbForms Error: " + dbFormsErrors));
        }
        finally {
            input.close();
        }
    }

    protected void initXMLValidator() throws ServletException {
        try {
            System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.Log4JCategoryLog");
        }
        catch (AccessControlException e) {
            logCat.warn((Object)"Unable map commons-logging to Log4j, due to SecurityManager", (Throwable)e);
        }
        ValidatorResources resources = new ValidatorResources();
        logCat.info((Object)"initialize XML Validator.");
        String value = this.getServletConfig().getInitParameter("validator-rules");
        this.loader.setValidatorRules(value);
        this.initXMLValidatorRules(resources, this.loader.getValidatorRules());
        value = this.getServletConfig().getInitParameter("validation");
        this.loader.setValidation(value);
        String[] s = StringUtils.split((String)this.loader.getValidation(), (String)",");
        for (int i = 0; i < s.length; ++i) {
            this.initXMLValidatorValidation(resources, s[i]);
        }
        this.getServletContext().setAttribute("Validator", (Object)resources);
        logCat.info((Object)" DbForms Validator : Loaded ");
    }

    /*
     * Loose catch block
     */
    protected void initXMLValidatorRules(ValidatorResources resources, String validator_rules) throws ServletException {
        block8: {
            InputStream inputValidatorRules = this.getServletContext().getResourceAsStream(validator_rules);
            if (inputValidatorRules == null) {
                logCat.warn((Object)"XML Validator rule file not found, XML Validator handler disabled!");
                return;
            }
            ValidatorResourcesInitializer.initialize((ValidatorResources)resources, (InputStream)inputValidatorRules);
            Object var6_4 = null;
            try {
                inputValidatorRules.close();
            }
            catch (Exception e) {
                logCat.error((Object)"initXMLValidatorRules", (Throwable)e);
            }
            break block8;
            {
                catch (IOException e) {
                    logCat.warn((Object)("XML Validator Exception ValidatorResourcesInitializer.initialize  : " + e.getMessage()));
                    throw new ServletException(e.toString());
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                try {
                    inputValidatorRules.close();
                }
                catch (Exception e) {
                    logCat.error((Object)"initXMLValidatorRules", (Throwable)e);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    protected void initXMLValidatorValidation(ValidatorResources resources, String validation) throws ServletException {
        block8: {
            InputStream inputValidation = this.getServletContext().getResourceAsStream(validation);
            if (inputValidation == null) {
                logCat.warn((Object)"XML Validation file not found, XML Validator handler disabled!");
                return;
            }
            ValidatorResourcesInitializer.initialize((ValidatorResources)resources, (InputStream)inputValidation);
            Object var6_4 = null;
            try {
                inputValidation.close();
            }
            catch (Exception e) {
                logCat.error((Object)"initXMLValidatorValidation", (Throwable)e);
            }
            break block8;
            {
                catch (IOException e) {
                    logCat.warn((Object)("XML Validator Exception ValidatorResourcesInitializer.initialize  : " + e.getMessage()));
                    throw new ServletException(e.toString());
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                try {
                    inputValidation.close();
                }
                catch (Exception e) {
                    logCat.error((Object)"initXMLValidatorValidation", (Throwable)e);
                }
                throw throwable;
            }
        }
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter out = response.getWriter();
        try {
            DbFormsConfig dbFormsConfig = DbFormsConfigRegistry.instance().lookup();
            out.println(dbFormsConfig.toString());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

