/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.util;

import com.atlassian.clover.Logger;
import com.atlassian.clover.util.FileUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class Path {
    private Logger log = Logger.getInstance();
    private List elements = new LinkedList();

    public Path() {
    }

    public Path(String osPathString) {
        this(osPathString, File.pathSeparator);
    }

    public Path(String osPathString, String pathSep) {
        StringTokenizer pt = new StringTokenizer(osPathString, pathSep);
        while (pt.hasMoreTokens()) {
            this.elements.add(FileUtils.getNormalizedPath(pt.nextToken()));
        }
    }

    public Path(String[] elements) {
        this.addAll(Arrays.asList(elements));
        this.normalizeFileSeps();
    }

    public void append(String element) {
        this.elements.add(FileUtils.getNormalizedPath(element));
    }

    public void append(Path path) {
        this.elements.addAll(path.elements);
    }

    public File resolveFile(String relativeFile) {
        relativeFile = FileUtils.getNormalizedPath(relativeFile);
        for (String pathElement : this.elements) {
            File absoluteFile = new File(pathElement, relativeFile);
            boolean exists = absoluteFile.exists();
            this.log.debug("looking for " + absoluteFile + (exists ? ": FOUND" : ": not found"));
            if (!exists) continue;
            return absoluteFile;
        }
        this.log.debug(relativeFile + " not found on path");
        return null;
    }

    protected void addAll(List pathEls) {
        this.elements.addAll(pathEls);
    }

    protected void normalizeFileSeps() {
        LinkedList<String> newElements = new LinkedList<String>();
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            newElements.add(FileUtils.getNormalizedPath((String)it.next()));
        }
        this.elements = newElements;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String sep = "";
        for (String pathElement : this.elements) {
            buf.append(sep);
            buf.append(pathElement);
            sep = File.pathSeparator;
        }
        return buf.toString();
    }
}

