/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.json;

import clover.org.apache.velocity.VelocityContext;
import com.atlassian.clover.api.registry.FileInfo;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.api.registry.PackageInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.reporters.CloverReportConfig;
import com.atlassian.clover.reporters.Column;
import com.atlassian.clover.reporters.Columns;
import com.atlassian.clover.reporters.html.HtmlRenderingSupportImpl;
import com.atlassian.clover.reporters.html.HtmlReportUtil;
import com.atlassian.clover.reporters.json.JSONObject;
import com.atlassian.clover.reporters.json.JSONReportUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class RenderMetricsJSONAction
implements Callable {
    private static ThreadLocal columns;
    private final HasMetrics mInfo;
    private final File mFile;
    private final HtmlRenderingSupportImpl mHelper;
    private final CloverReportConfig mCfg;
    private final VelocityContext mCtx;

    public RenderMetricsJSONAction(VelocityContext ctx, HasMetrics configured, CloverReportConfig current, File outfile, HtmlRenderingSupportImpl helper) {
        this.mInfo = configured;
        this.mCtx = ctx;
        this.mHelper = helper;
        this.mCfg = current;
        this.mFile = outfile;
    }

    public static void initThreadLocals() {
        columns = new ThreadLocal();
    }

    public static void resetThreadLocals() {
        columns = null;
    }

    public Object call() throws Exception {
        if (columns.get() == null) {
            List<Column> cols = this.mCfg.isColumnsSet() ? this.mCfg.getColumns().getProjectColumnsCopy() : Columns.getAllColumns();
            columns.set(cols);
        }
        this.render();
        return null;
    }

    public void render() throws Exception {
        Map<String, Number> columnValues = JSONReportUtils.collectColumnValuesFor((List)columns.get(), this.mInfo, this.mHelper);
        JSONObject json = new JSONObject().put("name", this.mInfo.getName()).put("title", this.mCfg.getTitle()).put("stats", columnValues);
        ArrayList<String> children = new ArrayList<String>();
        if (this.mInfo instanceof FullProjectInfo) {
            FullProjectInfo projectInfo = (FullProjectInfo)this.mInfo;
            List<? extends PackageInfo> pkgs = projectInfo.getAllPackages();
            Iterator<? extends PackageInfo> iterator = pkgs.iterator();
            while (iterator.hasNext()) {
                children.add(((FullPackageInfo)iterator.next()).getPath());
            }
        } else if (this.mInfo instanceof FullPackageInfo) {
            List<? extends FileInfo> files = ((FullPackageInfo)this.mInfo).getFiles();
            for (FullFileInfo fullFileInfo : files) {
                children.add(fullFileInfo.getName());
            }
        }
        json.put("children", children);
        this.mCtx.put("json", json);
        this.mCtx.put("callback", this.mCfg.getFormat().getCallback());
        HtmlReportUtil.mergeTemplateToFile(this.mFile, this.mCtx, "html_res/api-json.vm");
    }
}

