/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.entities;

import com.atlassian.clover.TCILookupStore;
import com.atlassian.clover.TestCaseInfoLookup;
import com.atlassian.clover.api.registry.BlockMetrics;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.ContextSet;
import com.atlassian.clover.api.registry.EntityContainer;
import com.atlassian.clover.api.registry.FileInfo;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.api.registry.SourceInfo;
import com.atlassian.clover.api.registry.StatementInfo;
import com.atlassian.clover.io.tags.TaggedDataInput;
import com.atlassian.clover.io.tags.TaggedDataOutput;
import com.atlassian.clover.io.tags.TaggedPersistent;
import com.atlassian.clover.registry.CoverageDataProvider;
import com.atlassian.clover.registry.CoverageDataReceptor;
import com.atlassian.clover.registry.FileElementVisitor;
import com.atlassian.clover.registry.FixedSourceRegion;
import com.atlassian.clover.registry.entities.BaseClassInfo;
import com.atlassian.clover.registry.entities.BaseFileInfo;
import com.atlassian.clover.registry.entities.FullBranchInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.entities.FullStatementInfo;
import com.atlassian.clover.registry.entities.Modifiers;
import com.atlassian.clover.registry.entities.ParentEntity;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.atlassian.clover.registry.metrics.ClassMetrics;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.registry.metrics.HasMetricsNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullClassInfo
extends BaseClassInfo
implements HasMetricsNode,
CoverageDataReceptor,
TaggedPersistent,
ClassInfo {
    private List<FullMethodInfo> methods = new ArrayList<FullMethodInfo>();
    private List<FullClassInfo> classes = new ArrayList<FullClassInfo>();
    private List<FullStatementInfo> statements = new ArrayList<FullStatementInfo>();
    private List<FullBranchInfo> branches = new ArrayList<FullBranchInfo>();
    private int relativeDataIndex;
    private int dataLength;
    private int aggregatedStatementCount;
    private int aggregatedComplexity;
    private transient CoverageDataProvider data;
    private transient TestCaseInfoLookup tciLookup;
    private transient ParentEntity parent;

    public FullClassInfo(FullPackageInfo packageInfo, FullClassInfo parentClass, int dataIndex, String name, SourceInfo region, Modifiers modifiers, boolean typeInterface, boolean typeEnum, boolean typeAnnotation) {
        this(new ParentEntity(parentClass), packageInfo, dataIndex, name, region, modifiers, typeInterface, typeEnum, typeAnnotation);
    }

    public FullClassInfo(FullPackageInfo packageInfo, FullMethodInfo parentMethod, int dataIndex, String name, SourceInfo region, Modifiers modifiers, boolean typeInterface, boolean typeEnum, boolean typeAnnotation) {
        this(new ParentEntity(parentMethod), packageInfo, dataIndex, name, region, modifiers, typeInterface, typeEnum, typeAnnotation);
    }

    public FullClassInfo(FullPackageInfo packageInfo, FullFileInfo parentFile, int dataIndex, String name, SourceInfo region, Modifiers modifiers, boolean typeInterface, boolean typeEnum, boolean typeAnnotation) {
        this(new ParentEntity(parentFile), packageInfo, dataIndex, name, region, modifiers, typeInterface, typeEnum, typeAnnotation);
    }

    private FullClassInfo(ParentEntity parent, FullPackageInfo packageInfo, int dataIndex, String name, SourceInfo region, Modifiers modifiers, boolean typeInterface, boolean typeEnum, boolean typeAnnotation) {
        super(packageInfo, (BaseFileInfo)parent.getContainingFile(), name, region, modifiers, typeInterface, typeEnum, typeAnnotation);
        this.relativeDataIndex = dataIndex;
        this.parent = parent;
    }

    private FullClassInfo(String name, String qualifiedName, int dataIndex, int dataLength, boolean typeInterface, boolean typeEnum, boolean typeAnnotation, boolean testClass, SourceInfo region, Modifiers modifiers, List<FullMethodInfo> methods, List<FullClassInfo> classes, List<FullStatementInfo> statements) {
        super(name, qualifiedName, region, modifiers, typeInterface, typeEnum, typeAnnotation, testClass);
        this.relativeDataIndex = dataIndex;
        this.dataLength = dataLength;
        this.methods = methods;
        this.classes = classes;
        this.statements = statements;
    }

    @Override
    public boolean isEmpty() {
        return this.methods.size() == 0;
    }

    @Override
    @NotNull
    public List<? extends ClassInfo> getClasses() {
        return new ArrayList<FullClassInfo>(this.classes);
    }

    @Override
    @NotNull
    public List<? extends ClassInfo> getAllClasses() {
        ArrayList<ClassInfo> allClasses = new ArrayList<ClassInfo>();
        for (FullClassInfo classInfo : this.classes) {
            allClasses.add(classInfo);
            allClasses.addAll(classInfo.getAllClasses());
        }
        for (FullMethodInfo methodInfo : this.methods) {
            allClasses.addAll(methodInfo.getAllClasses());
        }
        return allClasses;
    }

    @Override
    @NotNull
    public List<? extends MethodInfo> getMethods() {
        return new ArrayList<FullMethodInfo>(this.methods);
    }

    @Override
    @NotNull
    public List<? extends MethodInfo> getAllMethods() {
        ArrayList<MethodInfo> allMethods = new ArrayList<MethodInfo>();
        for (FullMethodInfo methodInfo : this.methods) {
            allMethods.add(methodInfo);
            allMethods.addAll(methodInfo.getAllMethods());
        }
        for (FullClassInfo classInfo : this.classes) {
            allMethods.addAll(classInfo.getAllMethods());
        }
        return allMethods;
    }

    @Override
    @NotNull
    public List<? extends StatementInfo> getStatements() {
        return new ArrayList<FullStatementInfo>(this.statements);
    }

    public void addClass(FullClassInfo classInfo) {
        this.classes.add(classInfo);
    }

    public void addMethod(FullMethodInfo meth) {
        this.methods.add(meth);
        this.testClass |= meth.isTest();
    }

    public void addStatement(FullStatementInfo statement) {
        this.statements.add(statement);
    }

    public void addTestCase(TestCaseInfo tci) {
        TestCaseInfoLookup lookup = this.tciLookup;
        if (lookup != null) {
            lookup.add(tci);
        }
        this.testClass = true;
    }

    private String calcTCILookupName() {
        return "class@" + this.getDataIndex() + ":" + this.getQualifiedName();
    }

    public Collection<TestCaseInfo> getTestCases() {
        TestCaseInfoLookup lookup = this.tciLookup;
        if (lookup != null) {
            return lookup.getTestCaseInfos();
        }
        return Collections.emptySet();
    }

    public TestCaseInfo getTestCase(Integer id) {
        TestCaseInfoLookup lookup = this.tciLookup;
        if (lookup != null) {
            return lookup.getBy(id);
        }
        return null;
    }

    public TestCaseInfo getTestCase(String testname) {
        TestCaseInfoLookup lookup = this.tciLookup;
        if (lookup != null) {
            return lookup.getBy(testname);
        }
        return null;
    }

    @Override
    public void setDataProvider(CoverageDataProvider data) {
        this.data = data;
        this.tciLookup = data instanceof TCILookupStore ? ((TCILookupStore)((Object)data)).namedTCILookupFor(this.calcTCILookupName()) : null;
        for (FullMethodInfo methodInfo : this.methods) {
            methodInfo.setDataProvider(data);
        }
        for (FullClassInfo classInfo : this.classes) {
            classInfo.setDataProvider(data);
        }
        this.rawMetrics = null;
        this.metrics = null;
    }

    @Override
    public CoverageDataProvider getDataProvider() {
        return this.data;
    }

    @Override
    public int getDataIndex() {
        return ((FullFileInfo)this.containingFile).dataIndex + this.relativeDataIndex;
    }

    public int getRelativeDataIndex() {
        return this.relativeDataIndex;
    }

    @Override
    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int length) {
        this.dataLength = length;
    }

    @Override
    public int getAggregatedStatementCount() {
        return this.aggregatedStatementCount;
    }

    @Override
    public void setAggregatedStatementCount(int aggregatedStatements) {
        this.aggregatedStatementCount = aggregatedStatements;
    }

    public void increaseAggregatedStatements(int increment) {
        this.aggregatedStatementCount += increment;
    }

    @Override
    public int getAggregatedComplexity() {
        return this.aggregatedComplexity;
    }

    @Override
    public void setAggregatedComplexity(int aggregatedComplexity) {
        this.aggregatedComplexity = aggregatedComplexity;
    }

    public void increaseAggregatedComplexity(int increment) {
        this.aggregatedComplexity += increment;
    }

    @Override
    @Nullable
    public MethodInfo getContainingMethod() {
        return this.parent.getContainingMethod();
    }

    @Override
    @Nullable
    public ClassInfo getContainingClass() {
        return this.parent.getContainingClass();
    }

    @Override
    @Nullable
    public FileInfo getContainingFile() {
        return this.parent.getContainingFile();
    }

    @Override
    public EntityContainer getParent() {
        return this.parent.getParentEntity();
    }

    public void gatherSourceRegions(Set<SourceInfo> regions) {
        regions.add(this);
        for (FullMethodInfo methodInfo : this.methods) {
            methodInfo.gatherSourceRegions(regions);
        }
    }

    public void visitElements(FileElementVisitor visitor) {
        visitor.visitClass(this);
        for (FullClassInfo classInfo : this.classes) {
            classInfo.visitElements(visitor);
        }
        for (FullMethodInfo methodInfo : this.methods) {
            methodInfo.visit(visitor);
        }
        for (FullStatementInfo statementInfo : this.statements) {
            visitor.visitStatement(statementInfo);
        }
    }

    @Override
    public String getChildType() {
        return "method";
    }

    @Override
    public int getNumChildren() {
        return this.methods.size();
    }

    @Override
    public HasMetricsNode getChild(int i) {
        return this.methods.get(i);
    }

    @Override
    public int getIndexOfChild(HasMetricsNode child) {
        return this.methods.indexOf(child);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void setComparator(Comparator cmp) {
        if (cmp != null) {
            Collections.sort(this.methods, cmp);
        } else {
            Collections.sort(this.methods, FixedSourceRegion.SOURCE_ORDER_COMP);
        }
    }

    @Override
    public BlockMetrics getMetrics() {
        if (this.metrics == null || this.getPackage().getContextFilter() != this.contextFilter) {
            this.contextFilter = this.getContainingFile().getContextFilter();
            this.metrics = this.calcMetrics(this.contextFilter, true);
        }
        return this.metrics;
    }

    @Override
    public BlockMetrics getRawMetrics() {
        if (this.rawMetrics == null) {
            this.rawMetrics = this.calcMetrics(null, false);
        }
        return this.rawMetrics;
    }

    private ClassMetrics calcMetrics(ContextSet filter, boolean isFiltered) {
        ClassMetrics classMetrics = new ClassMetrics(this);
        this.calcAndAddMethodMetrics(classMetrics, filter, isFiltered);
        this.calcAndAddClassMetrics(classMetrics, isFiltered);
        this.calcAndAddBranchMetrics(classMetrics, filter);
        this.calcAndAddStatementMetrics(classMetrics, filter);
        this.calcAndAddTestCaseMetrics(classMetrics);
        return classMetrics;
    }

    private void calcAndAddMethodMetrics(ClassMetrics classMetrics, ContextSet filter, boolean isFiltered) {
        int covered = 0;
        int numMethods = 0;
        int numTestMethods = 0;
        for (FullMethodInfo methodInfo : this.methods) {
            if (methodInfo.isFiltered(filter)) continue;
            if (!isFiltered) {
                classMetrics.add(methodInfo.getRawMetrics());
            } else {
                classMetrics.add(methodInfo.getMetrics());
            }
            for (MethodInfo methodInfo2 : methodInfo.getAllMethods()) {
                if (methodInfo2.getHitCount() <= 0) continue;
                ++covered;
            }
            if (methodInfo.getHitCount() > 0) {
                ++covered;
            }
            if (methodInfo.isTest()) {
                ++numTestMethods;
            }
            numMethods += 1 + methodInfo.getAllMethods().size();
        }
        classMetrics.addNumMethods(numMethods);
        classMetrics.addNumCoveredMethods(covered);
        classMetrics.addNumTestMethods(numTestMethods);
    }

    private void calcAndAddClassMetrics(ClassMetrics classMetrics, boolean isFiltered) {
        for (FullClassInfo classInfo : this.classes) {
            if (!isFiltered) {
                classMetrics.add(classInfo.getRawMetrics());
                continue;
            }
            classMetrics.add(classInfo.getMetrics());
        }
    }

    private void calcAndAddBranchMetrics(ClassMetrics classMetrics, ContextSet contextSet) {
        int covered = 0;
        int numBranches = 0;
        int complexity = 0;
        for (FullBranchInfo branchInfo : this.branches) {
            if (branchInfo.isFiltered(contextSet)) continue;
            if (branchInfo.getTrueHitCount() > 0) {
                ++covered;
            }
            if (branchInfo.getFalseHitCount() > 0) {
                ++covered;
            }
            complexity += branchInfo.getComplexity();
            numBranches += 2;
        }
        classMetrics.addNumCoveredBranches(covered);
        classMetrics.addNumBranches(numBranches);
        classMetrics.addComplexity(complexity);
    }

    private void calcAndAddStatementMetrics(ClassMetrics classMetrics, ContextSet contextSet) {
        int covered = 0;
        int numStatements = 0;
        int complexity = 0;
        for (FullStatementInfo statementInfo : this.statements) {
            if (statementInfo.isFiltered(contextSet)) continue;
            if (statementInfo.getHitCount() > 0) {
                ++covered;
            }
            complexity += statementInfo.getComplexity();
            ++numStatements;
        }
        classMetrics.addNumCoveredStatements(covered);
        classMetrics.addNumStatements(numStatements);
        classMetrics.addComplexity(complexity);
    }

    private void calcAndAddTestCaseMetrics(ClassMetrics classMetrics) {
        TestCaseInfoLookup lookup = this.tciLookup;
        if (lookup != null) {
            int numTests = 0;
            int numPasses = 0;
            int numFailures = 0;
            int numErrors = 0;
            float executionTime = 0.0f;
            for (TestCaseInfo test : lookup.getTestCaseInfos()) {
                if (!test.isHasResult()) continue;
                ++numTests;
                if (test.isSuccess()) {
                    ++numPasses;
                } else if (test.isError()) {
                    ++numErrors;
                } else {
                    ++numFailures;
                }
                executionTime += test.getTime();
            }
            classMetrics.setNumTests(numTests);
            classMetrics.setNumTestPasses(numPasses);
            classMetrics.setNumTestFailures(numFailures);
            classMetrics.setNumTestErrors(numErrors);
            classMetrics.setTestExecutionTime(executionTime);
        }
    }

    public FullClassInfo copy(FullFileInfo newParent, HasMetricsFilter filter) {
        FullClassInfo newClass = new FullClassInfo((FullPackageInfo)newParent.getContainingPackage(), newParent, this.relativeDataIndex, this.name, (SourceInfo)this, this.modifiers, this.typeInterface, this.typeEnum, this.typeAnnotation);
        newClass.setDataProvider(this.getDataProvider());
        newClass.setDataLength(this.getDataLength());
        for (FullClassInfo classInfo : this.classes) {
            if (!filter.accept(classInfo)) continue;
            newClass.addClass(classInfo);
        }
        for (FullMethodInfo methodInfo : this.methods) {
            if (!filter.accept(methodInfo)) continue;
            newClass.addMethod(methodInfo.copy(newClass));
        }
        for (FullStatementInfo statementInfo : this.statements) {
            newClass.addStatement(statementInfo.copy(newClass));
        }
        return newClass;
    }

    public FullMethodInfo getTestMethodDeclaration(String methodname) {
        for (FullMethodInfo methodInfo : this.methods) {
            if (!methodInfo.getSimpleName().equals(methodname) || !methodInfo.isPublic()) continue;
            return methodInfo;
        }
        return null;
    }

    public int getNumMethods() {
        return this.methods.size();
    }

    public void setRegionEnd(int endLine, int endCol) {
        this.region = new FixedSourceRegion(this.region.getStartLine(), this.region.getStartColumn(), endLine, endCol);
    }

    public void setContainingMethod(FullMethodInfo containingMethod) {
        this.parent = new ParentEntity(containingMethod);
    }

    public void setContainingClass(FullClassInfo containingClass) {
        this.parent = new ParentEntity(containingClass);
    }

    public void setContainingFile(FullFileInfo fileInfo) {
        this.containingFile = fileInfo;
        if (this.parent == null) {
            this.parent = new ParentEntity(fileInfo);
        } else {
            this.parent.setContainingFile(fileInfo);
        }
    }

    @Override
    public void write(TaggedDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.qualifiedName);
        out.writeInt(this.relativeDataIndex);
        out.writeInt(this.dataLength);
        out.writeInt(this.aggregatedComplexity);
        out.writeInt(this.aggregatedStatementCount);
        out.writeBoolean(this.typeAnnotation);
        out.writeBoolean(this.typeEnum);
        out.writeBoolean(this.typeInterface);
        out.writeBoolean(this.testClass);
        FixedSourceRegion.writeRaw(this, out);
        out.write(Modifiers.class, this.modifiers);
        out.writeList(FullClassInfo.class, this.classes);
        out.writeList(FullMethodInfo.class, this.methods);
        out.writeList(FullStatementInfo.class, this.statements);
    }

    public static FullClassInfo read(TaggedDataInput in) throws IOException {
        String name = in.readUTF();
        String qualifiedName = in.readUTF();
        int index = in.readInt();
        int length = in.readInt();
        int aggregatedComplexity = in.readInt();
        int aggregatedStatements = in.readInt();
        boolean typeAnnotation = in.readBoolean();
        boolean typeEnum = in.readBoolean();
        boolean typeInterface = in.readBoolean();
        boolean isTest = in.readBoolean();
        FixedSourceRegion region = FixedSourceRegion.read(in);
        Modifiers modifiers = in.read(Modifiers.class);
        List<FullClassInfo> classes = in.readList(FullClassInfo.class);
        List<FullMethodInfo> methods = in.readList(FullMethodInfo.class);
        List<FullStatementInfo> statements = in.readList(FullStatementInfo.class);
        FullClassInfo classInfo = new FullClassInfo(name, qualifiedName, index, length, typeInterface, typeEnum, typeAnnotation, isTest, region, modifiers, methods, classes, statements);
        classInfo.setAggregatedStatementCount(aggregatedStatements);
        classInfo.setAggregatedComplexity(aggregatedComplexity);
        for (FullClassInfo cls : classes) {
            cls.setContainingClass(classInfo);
        }
        for (FullMethodInfo method : methods) {
            method.setContainingClass(classInfo);
        }
        for (FullStatementInfo statement : statements) {
            statement.setContainingClass(classInfo);
        }
        return classInfo;
    }
}

