/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.recorder;

import com.atlassian.clover.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class FOSFactory {
    private static final boolean USE_SYNCHRONOUS_IO;
    static final Class[] REQUIRED_CLASSES;

    public static FileOutputStream newFOS(File file) throws FileNotFoundException {
        if (USE_SYNCHRONOUS_IO) {
            return new SyncingFileOutputStream(file);
        }
        return new FileOutputStream(file);
    }

    static {
        REQUIRED_CLASSES = new Class[]{SyncingFileOutputStream.class};
        Boolean useSyncIO = Boolean.FALSE;
        try {
            useSyncIO = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return new Boolean(System.getProperty("clover.synchronous.io"));
                }
            });
        }
        catch (SecurityException e) {
            Logger.getInstance().info("Unable to determine Clover IO mode", e);
        }
        USE_SYNCHRONOUS_IO = useSyncIO != null ? useSyncIO : false;
    }

    private static class SyncingFileOutputStream
    extends FileOutputStream {
        private SyncingFileOutputStream(File name) throws FileNotFoundException {
            super(name);
        }

        public void flush() throws IOException {
            super.flush();
            this.getFD().sync();
        }
    }
}

