/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.tests.naming;

import clover.com.google.common.collect.Lists;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.instr.tests.naming.JUnitParameterizedTestExtractor;
import com.atlassian.clover.instr.tests.naming.NullNameExtractor;
import com.atlassian.clover.instr.tests.naming.SpockFeatureNameExtractor;
import com.atlassian.clover.instr.tests.naming.TestNameExtractor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultTestNameExtractor
implements TestNameExtractor {
    public static final TestNameExtractor INSTANCE = new DefaultTestNameExtractor();
    private static final List<TestNameExtractor> TEST_EXTRACTORS = Lists.newArrayList(new JUnitParameterizedTestExtractor(), new SpockFeatureNameExtractor(), new NullNameExtractor());

    @Nullable
    public String getTestNameForMethod(@NotNull MethodInfo methodInfo) {
        for (TestNameExtractor extractor : TEST_EXTRACTORS) {
            String testName = extractor.getTestNameForMethod(methodInfo);
            if (testName == null) continue;
            return testName;
        }
        return null;
    }
}

