/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.cfg.instr;

import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.cfg.instr.StatementContextDef;

public class MethodContextDef
extends StatementContextDef {
    private int maxComplexity = Integer.MAX_VALUE;
    private int maxStatements = Integer.MAX_VALUE;
    private int maxAggregatedComplexity = Integer.MAX_VALUE;
    private int maxAggregatedStatements = Integer.MAX_VALUE;

    public int getMaxComplexity() {
        return this.maxComplexity;
    }

    public void setMaxComplexity(int maxComplexity) {
        this.maxComplexity = maxComplexity;
    }

    public int getMaxStatements() {
        return this.maxStatements;
    }

    public void setMaxStatements(int maxStatements) {
        this.maxStatements = maxStatements;
    }

    public int getMaxAggregatedComplexity() {
        return this.maxAggregatedComplexity;
    }

    public void setMaxAggregatedComplexity(int maxAggregatedComplexity) {
        this.maxAggregatedComplexity = maxAggregatedComplexity;
    }

    public int getMaxAggregatedStatements() {
        return this.maxAggregatedStatements;
    }

    public void setMaxAggregatedStatements(int maxAggregatedStatements) {
        this.maxAggregatedStatements = maxAggregatedStatements;
    }

    public void validate() throws CloverException {
        if (this.maxComplexity < 0) {
            throw new CloverException("maxComplexity must be greater than 0");
        }
        if (this.maxComplexity == 0) {
            throw new CloverException("maxComplexity must be greater than 0 because methods have a minimum complexity of 1");
        }
        if (this.maxStatements < 0) {
            throw new CloverException("maxStatements must be >= 0");
        }
        if (this.maxAggregatedComplexity < 0) {
            throw new CloverException("maxAggregatedComplexity must be >= 0");
        }
        if (this.maxAggregatedStatements < 0) {
            throw new CloverException("maxAggregatedStatements must be >= 0");
        }
        if (this.getRegexp() == null || this.getRegexp().trim().length() == 0) {
            this.setRegexp(".*");
        }
        super.validate();
    }
}

