/*
 * Decompiled with CFR 0.152.
 */
package clover.org.apache.velocity.runtime.resource;

import clover.org.apache.commons.collections.ExtendedProperties;
import clover.org.apache.velocity.exception.ParseErrorException;
import clover.org.apache.velocity.exception.ResourceNotFoundException;
import clover.org.apache.velocity.runtime.RuntimeServices;
import clover.org.apache.velocity.runtime.log.Log;
import clover.org.apache.velocity.runtime.resource.Resource;
import clover.org.apache.velocity.runtime.resource.ResourceCache;
import clover.org.apache.velocity.runtime.resource.ResourceCacheImpl;
import clover.org.apache.velocity.runtime.resource.ResourceFactory;
import clover.org.apache.velocity.runtime.resource.ResourceManager;
import clover.org.apache.velocity.runtime.resource.loader.ResourceLoader;
import clover.org.apache.velocity.runtime.resource.loader.ResourceLoaderFactory;
import clover.org.apache.velocity.util.ClassUtils;
import clover.org.apache.velocity.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ResourceManagerImpl
implements ResourceManager {
    public static final int RESOURCE_TEMPLATE = 1;
    public static final int RESOURCE_CONTENT = 2;
    private static final String RESOURCE_LOADER_IDENTIFIER = "_RESOURCE_LOADER_IDENTIFIER_";
    protected ResourceCache globalCache = null;
    protected final List resourceLoaders = new ArrayList();
    private final List sourceInitializerList = new ArrayList();
    private boolean isInit = false;
    private boolean logWhenFound = true;
    protected RuntimeServices rsvc = null;
    protected Log log = null;
    static /* synthetic */ Class class$org$apache$velocity$runtime$resource$ResourceCache;

    public synchronized void initialize(RuntimeServices rsvc) throws Exception {
        if (this.isInit) {
            this.log.warn("Re-initialization of ResourceLoader attempted!");
            return;
        }
        ResourceLoader resourceLoader = null;
        this.rsvc = rsvc;
        this.log = rsvc.getLog();
        this.log.debug("Default ResourceManager initializing. (" + this.getClass() + ")");
        this.assembleResourceLoaderInitializers();
        Iterator it = this.sourceInitializerList.iterator();
        while (it.hasNext()) {
            ExtendedProperties configuration = (ExtendedProperties)it.next();
            String loaderClass = StringUtils.nullTrim(configuration.getString("class"));
            ResourceLoader loaderInstance = (ResourceLoader)configuration.get("instance");
            if (loaderInstance != null) {
                resourceLoader = loaderInstance;
            } else if (loaderClass != null) {
                resourceLoader = ResourceLoaderFactory.getLoader(rsvc, loaderClass);
            } else {
                this.log.error("Unable to find '" + configuration.getString(RESOURCE_LOADER_IDENTIFIER) + ".resource.loader.class' specification in configuration." + " This is a critical value.  Please adjust configuration.");
                continue;
            }
            resourceLoader.commonInit(rsvc, configuration);
            resourceLoader.init(configuration);
            this.resourceLoaders.add(resourceLoader);
        }
        this.logWhenFound = rsvc.getBoolean("resource.manager.logwhenfound", true);
        String cacheClassName = rsvc.getString("resource.manager.cache.class");
        Object cacheObject = null;
        if (clover.org.apache.commons.lang.StringUtils.isNotEmpty(cacheClassName)) {
            try {
                cacheObject = ClassUtils.getNewInstance(cacheClassName);
            }
            catch (ClassNotFoundException cnfe) {
                this.log.error("The specified class for ResourceCache (" + cacheClassName + ") does not exist or is not accessible to the current classloader.");
                cacheObject = null;
            }
            if (!(cacheObject instanceof ResourceCache)) {
                this.log.error("The specified class for ResourceCache (" + cacheClassName + ") does not implement " + (class$org$apache$velocity$runtime$resource$ResourceCache == null ? (class$org$apache$velocity$runtime$resource$ResourceCache = ResourceManagerImpl.class$("clover.org.apache.velocity.runtime.resource.ResourceCache")) : class$org$apache$velocity$runtime$resource$ResourceCache).getName() + " ResourceManager. Using default ResourceCache implementation.");
                cacheObject = null;
            }
        }
        if (cacheObject == null) {
            cacheObject = new ResourceCacheImpl();
        }
        this.globalCache = (ResourceCache)cacheObject;
        this.globalCache.initialize(rsvc);
        this.log.trace("Default ResourceManager initialization complete.");
    }

    private void assembleResourceLoaderInitializers() {
        Vector resourceLoaderNames = this.rsvc.getConfiguration().getVector("resource.loader");
        StringUtils.trimStrings(resourceLoaderNames);
        Iterator it = resourceLoaderNames.iterator();
        while (it.hasNext()) {
            String loaderName = (String)it.next();
            StringBuffer loaderID = new StringBuffer(loaderName);
            loaderID.append(".").append("resource.loader");
            ExtendedProperties loaderConfiguration = this.rsvc.getConfiguration().subset(loaderID.toString());
            if (loaderConfiguration == null) {
                this.log.warn("ResourceManager : No configuration information for resource loader named '" + loaderName + "'. Skipping.");
                continue;
            }
            loaderConfiguration.setProperty(RESOURCE_LOADER_IDENTIFIER, loaderName);
            this.sourceInitializerList.add(loaderConfiguration);
        }
    }

    public synchronized Resource getResource(String resourceName, int resourceType, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        String resourceKey = resourceType + resourceName;
        Resource resource = this.globalCache.get(resourceKey);
        if (resource != null) {
            try {
                this.refreshResource(resource, encoding);
            }
            catch (ResourceNotFoundException rnfe) {
                this.globalCache.remove(resourceKey);
                return this.getResource(resourceName, resourceType, encoding);
            }
            catch (ParseErrorException pee) {
                this.log.error("ResourceManager.getResource() exception", pee);
                throw pee;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                this.log.error("ResourceManager.getResource() exception", e);
                throw e;
            }
        }
        try {
            resource = this.loadResource(resourceName, resourceType, encoding);
            if (resource.getResourceLoader().isCachingOn()) {
                this.globalCache.put(resourceKey, resource);
            }
        }
        catch (ResourceNotFoundException rnfe) {
            this.log.error("ResourceManager : unable to find resource '" + resourceName + "' in any resource loader.");
            throw rnfe;
        }
        catch (ParseErrorException pee) {
            this.log.error("ResourceManager.getResource() parse exception", pee);
            throw pee;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            this.log.error("ResourceManager.getResource() exception new", e);
            throw e;
        }
        return resource;
    }

    protected Resource loadResource(String resourceName, int resourceType, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        Resource resource = ResourceFactory.getResource(resourceName, resourceType);
        resource.setRuntimeServices(this.rsvc);
        resource.setName(resourceName);
        resource.setEncoding(encoding);
        long howOldItWas = 0L;
        Iterator it = this.resourceLoaders.iterator();
        while (it.hasNext()) {
            ResourceLoader resourceLoader = (ResourceLoader)it.next();
            resource.setResourceLoader(resourceLoader);
            try {
                if (!resource.process()) continue;
                if (this.logWhenFound && this.log.isDebugEnabled()) {
                    this.log.debug("ResourceManager : found " + resourceName + " with loader " + resourceLoader.getClassName());
                }
                howOldItWas = resourceLoader.getLastModified(resource);
                break;
            }
            catch (ResourceNotFoundException rnfe) {
            }
        }
        if (resource.getData() == null) {
            throw new ResourceNotFoundException("Unable to find resource '" + resourceName + "'");
        }
        resource.setLastModified(howOldItWas);
        resource.setModificationCheckInterval(resource.getResourceLoader().getModificationCheckInterval());
        resource.touch();
        return resource;
    }

    protected void refreshResource(Resource resource, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        if (resource.requiresChecking()) {
            resource.touch();
            if (resource.isSourceModified()) {
                if (!clover.org.apache.commons.lang.StringUtils.equals(resource.getEncoding(), encoding)) {
                    this.log.warn("Declared encoding for template '" + resource.getName() + "' is different on reload. Old = '" + resource.getEncoding() + "' New = '" + encoding);
                    resource.setEncoding(encoding);
                }
                long howOldItWas = resource.getResourceLoader().getLastModified(resource);
                resource.process();
                resource.setLastModified(howOldItWas);
            }
        }
    }

    public Resource getResource(String resourceName, int resourceType) throws ResourceNotFoundException, ParseErrorException, Exception {
        return this.getResource(resourceName, resourceType, "ISO-8859-1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLoaderNameForResource(String resourceName) {
        it = this.resourceLoaders.iterator();
        while (it.hasNext() != false) {
            block11: {
                resourceLoader = (ResourceLoader)it.next();
                is = null;
                try {
                    try {
                        is = resourceLoader.getResourceStream(resourceName);
                        if (is == null) break block11;
                        var5_6 = resourceLoader.getClass().toString();
                        var7_7 = null;
                        if (is == null) return var5_6;
                    }
                    catch (ResourceNotFoundException rnfe) {
                        var7_7 = null;
                        if (is == null) continue;
                        try {
                            is.close();
                        }
                        catch (IOException supressed) {}
                        continue;
                    }
                }
                catch (Throwable var6_9) {
                    var7_7 = null;
                    if (is == null) throw var6_9;
                    ** try [egrp 2[TRYBLOCK] [5 : 88->96)] { 
lbl28:
                    // 1 sources

                    is.close();
                    throw var6_9;
lbl30:
                    // 1 sources

                    catch (IOException supressed) {
                        // empty catch block
                    }
                    throw var6_9;
                }
                try {}
                catch (IOException supressed) {
                    // empty catch block
                    return var5_6;
                }
                is.close();
                return var5_6;
            }
            var7_7 = null;
            if (is == null) continue;
            try {}
            catch (IOException supressed) {}
            is.close();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

