/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags;

import info.bliki.wiki.filter.Encoder;
import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.model.Reference;
import info.bliki.wiki.tags.HTMLTag;
import java.io.IOException;
import java.util.List;

public class ReferencesTag
extends HTMLTag {
    public ReferencesTag() {
        super("references");
    }

    public void renderHTML(ITextConverter converter, Appendable writer, IWikiModel model) throws IOException {
        List<Reference> list = model.getReferences();
        if (list != null) {
            writer.append("<ol class=\"references\">\n");
            for (int i = 0; i < list.size(); ++i) {
                Reference ref = list.get(i);
                int counter = ref.getCounter();
                writer.append("<li id=\"_note-");
                String nameAttribute = Encoder.encodeDotUrl(ref.getAttribute());
                if (counter == 0) {
                    if (nameAttribute.length() == 0) {
                        String i1 = Integer.toString(i + 1);
                        writer.append(i1);
                        writer.append("\"><b><a href=\"#_ref-");
                        writer.append(i1);
                    } else {
                        writer.append(nameAttribute);
                        writer.append("\"><b><a href=\"#_ref-");
                        writer.append(nameAttribute);
                    }
                    writer.append("\" title=\"\">&#8593;</a></b> ");
                } else {
                    writer.append(nameAttribute);
                    writer.append("\">&#8593; ");
                    for (int j = 0; j <= counter; ++j) {
                        char ch = j >= "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRTSUVWXYZ".length() ? (char)'Z' : (char)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRTSUVWXYZ".charAt(j);
                        String note = j != 0 ? nameAttribute + '_' + ch : nameAttribute;
                        writer.append("<a href=\"#_ref-");
                        writer.append(note);
                        writer.append("\" title=\"\"><sup><i><b>" + ch + "</b></i></sup></a> ");
                    }
                }
                writer.append(ref.getRefString());
                writer.append("</li>");
            }
            writer.append("</ol>");
        }
    }

    public boolean isReduceTokenStack() {
        return false;
    }

    public String getParents() {
        return "|applet|snippet|blockquote|body|button|center|dd|del|div|fieldset|form|iframe|ins|li|map|noframes|noscript|object|td|th|";
    }
}

