/*
 * Decompiled with CFR 0.152.
 */
package de.superx.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrashMap
extends HashMap {
    private static Logger logger = LoggerFactory.getLogger(TrashMap.class);
    private static String KEY = "MAN_DEFAULT_REPORT";
    private static int NOT_AVAILABLE = 0;
    private static int VALUE_NULL = 1;
    private static int KEY_IN_MAP = 2;
    private String entry = "";
    private static final long serialVersionUID = 1L;

    public TrashMap(Map m) {
        super(m);
    }

    protected void refreshEntry() {
        Object mapEntry = !this.containsKey(KEY) ? "" : (this.get(KEY) == null ? KEY + "=null" : KEY + "='" + String.valueOf(this.get(KEY)) + "'");
        if (!this.entry.equals(mapEntry)) {
            this.entry = mapEntry;
            logger.warn("TrashMap changed: " + this.entry);
            String st = ExceptionUtils.getFullStackTrace((Throwable)new Throwable());
            logger.warn(st.toString());
        }
    }

    @Override
    public Object put(Object key, Object value) {
        Object result = super.put(key, value);
        this.refreshEntry();
        return result;
    }

    @Override
    public void putAll(Map m) {
        super.putAll(m);
        this.refreshEntry();
    }

    @Override
    public Object remove(Object key) {
        Object result = super.remove(key);
        this.refreshEntry();
        return result;
    }

    @Override
    public boolean remove(Object key, Object value) {
        boolean result = super.remove(key, value);
        this.refreshEntry();
        return result;
    }

    @Override
    public Object replace(Object key, Object value) {
        Object result = super.replace(key, value);
        this.refreshEntry();
        return result;
    }

    @Override
    public boolean replace(Object key, Object oldvalue, Object newvalue) {
        boolean result = super.replace(key, oldvalue, newvalue);
        this.refreshEntry();
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        this.refreshEntry();
    }
}

