/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import de.superx.bianalysis.metadata.Identifier;
import de.superx.common.InvalidEntityException;
import de.superx.jdbc.entity.Entity;
import de.superx.jdbc.entity.Systeminfo;
import de.superx.jdbc.entity.TableMetadata;
import de.superx.jdbc.model.DynamicFieldType;
import de.superx.jdbc.model.NonEditable;
import de.superx.jdbc.model.RepositoryMetadata;
import de.superx.jdbc.repository.BiaAdminCrudRepository;
import de.superx.jdbc.repository.SysteminfoRepository;
import de.superx.jdbc.repository.TableMetadataRepository;
import de.superx.rest.model.FieldType;
import de.superx.rest.model.HisDynamicFieldConfig;
import de.superx.rest.model.Item;
import de.superx.rest.model.RestMessageWrapperException;
import de.superx.rest.model.Row;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.annotation.Id;
import org.springframework.data.relational.core.mapping.Table;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.core.support.AnnotationRepositoryMetadata;
import org.springframework.stereotype.Service;

@Service
public class BiaRepositoryService {
    static Logger logger = Logger.getLogger(BiaRepositoryService.class);
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    DataSource dataSource;
    @Autowired
    TableMetadataRepository tableMetadataRepo;
    @Autowired
    SysteminfoRepository systemInfoRepo;

    public Entity saveEntity(String entityTableName, Map<String, String> fields) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        BiaAdminCrudRepository<Entity> repository = this.findBiaAdminCrudRepositoryFor(entityTableName);
        Entity entity = this.createEntity(repository, fields);
        return (Entity)repository.save(entity);
    }

    public void deleteEntity(String entityTableName, String id) throws RestMessageWrapperException {
        BiaAdminCrudRepository<Entity> repository = this.findBiaAdminCrudRepositoryFor(entityTableName);
        Object oid = this.stringToType(id, this.getIdTypeFor(repository));
        try {
            Optional entity = repository.findById(oid);
            if (entity.isPresent() && ((Entity)entity.get()).isReadOnly()) {
                throw new InvalidEntityException("Entity is read-only");
            }
            repository.deleteById(oid);
        }
        catch (IncorrectResultSizeDataAccessException ex) {
            String messageKey = "cs.bia.admin.editRelation.ambiguousResultErrorMessage";
            String descriptionKey = "cs.bia.admin.editRelation.ambiguousResultErrorDescription";
            List<String> parameters = Arrays.asList(this.getIdField(repository).getName(), id.toString(), String.valueOf(ex.getActualSize()));
            throw new RestMessageWrapperException(messageKey, descriptionKey, parameters);
        }
    }

    public BiaAdminCrudRepository<Entity> findBiaAdminCrudRepositoryFor(String tableName) {
        Map repositoryBeans = this.applicationContext.getBeansOfType(BiaAdminCrudRepository.class);
        for (BiaAdminCrudRepository repo : repositoryBeans.values()) {
            Class<Entity> domainClass = this.getDomainClassFor(repo);
            Table table = domainClass.getAnnotation(Table.class);
            Object fullName = "";
            fullName = table.schema() != null && !table.schema().isBlank() ? table.schema() + "." + table.value() : table.value();
            if (!((String)fullName).equals(tableName)) continue;
            return repo;
        }
        return null;
    }

    public CrudRepository<Entity, Object> findCrudRepositoryFor(String schemaName, String tableName) {
        Map repositoryBeans = this.applicationContext.getBeansOfType(CrudRepository.class);
        for (CrudRepository repo : repositoryBeans.values()) {
            boolean schemaMatch;
            Class<Entity> domainClass = this.getDomainClassFor((CrudRepository<Entity, Object>)repo);
            Table table = domainClass.getAnnotation(Table.class);
            boolean tableMatch = table.value().equals(tableName);
            boolean bl = schemaMatch = (schemaName == null || schemaName.isEmpty()) && table.schema().isEmpty() || schemaName != null && schemaName.equals(table.schema()) || schemaName != null && schemaName.equals("public") && table.schema().isEmpty();
            if (!tableMatch || !schemaMatch) continue;
            return repo;
        }
        return null;
    }

    public BiaAdminCrudRepository<Entity> findBiaAdminCrudRepositoryFor(Entity entity) {
        Map repositoryBeans = this.applicationContext.getBeansOfType(BiaAdminCrudRepository.class);
        for (BiaAdminCrudRepository repo : repositoryBeans.values()) {
            boolean schemaMatch;
            Class<Entity> domainClass = this.getDomainClassFor(repo);
            Table table = domainClass.getAnnotation(Table.class);
            Table entityTable = entity.getClass().getAnnotation(Table.class);
            boolean tableMatch = table.value().equals(entityTable.value());
            boolean bl = schemaMatch = table.schema().isEmpty() && entityTable.schema().isEmpty() || table.schema().equals(entityTable.schema()) || table.schema().equals("public") && entityTable.schema().isEmpty() || table.schema().isEmpty() && entityTable.schema().equals("public");
            if (!tableMatch || !schemaMatch) continue;
            return repo;
        }
        return null;
    }

    public List<Row> getAllEditableTables() {
        ArrayList<Row> rows = new ArrayList<Row>();
        Map repositoryBeans = this.applicationContext.getBeansOfType(BiaAdminCrudRepository.class);
        for (BiaAdminCrudRepository repo : repositoryBeans.values()) {
            boolean nonEditable;
            boolean bl = nonEditable = repo.getClass().getInterfaces()[0].getAnnotation(NonEditable.class) != null;
            if (nonEditable) continue;
            HashMap<String, Object> cells = new HashMap<String, Object>();
            Class<Entity> domainClass = this.getDomainClassFor(repo);
            Object tableName = domainClass.getAnnotation(Table.class).value();
            String schema = domainClass.getAnnotation(Table.class).schema();
            if (schema != null && !schema.isBlank()) {
                tableName = schema + "." + (String)tableName;
            }
            cells.put("table_name", tableName);
            TableMetadata tableMetadata = this.getTableMetadata((String)tableName);
            if (tableMetadata == null) continue;
            Optional systemInfoRow = this.systemInfoRepo.findById(tableMetadata.systeminfoId);
            if (systemInfoRow.isPresent()) {
                String name = ((Systeminfo)systemInfoRow.get()).name;
                cells.put("bi_component", name);
            }
            cells.put("caption", tableMetadata.caption);
            cells.put("description", tableMetadata.description);
            rows.add(new Row(cells));
        }
        return rows;
    }

    private TableMetadata getTableMetadata(String tableName) {
        List<TableMetadata> tableMetadataArr = this.tableMetadataRepo.findByName(tableName);
        if (!tableMetadataArr.isEmpty()) {
            return tableMetadataArr.get(0);
        }
        return null;
    }

    public HisDynamicFieldConfig getAdminDialogConfig(String entityTableName, String id) throws IllegalArgumentException, IllegalAccessException, InstantiationException, SQLException, InvocationTargetException, NoSuchMethodException, SecurityException, RestMessageWrapperException {
        BiaAdminCrudRepository<Entity> repository = this.findBiaAdminCrudRepositoryFor(entityTableName);
        Field idField = this.getIdField(repository);
        Object realId = this.stringToType(id, idField.getClass());
        try {
            return repository.getEditConfig(realId, this);
        }
        catch (IncorrectResultSizeDataAccessException ex) {
            String messageKey = "cs.bia.admin.editRelation.ambiguousResultErrorMessage";
            String descriptionKey = "cs.bia.admin.editRelation.ambiguousResultErrorDescription";
            List<String> parameters = Arrays.asList(idField.getName(), id.toString(), String.valueOf(ex.getActualSize()));
            throw new RestMessageWrapperException(messageKey, descriptionKey, parameters);
        }
    }

    public HisDynamicFieldConfig getAdminFilterConfig(String entityTableName) throws IllegalArgumentException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, SecurityException {
        BiaAdminCrudRepository<Entity> repository = this.findBiaAdminCrudRepositoryFor(entityTableName);
        return repository.getFilterConfig(this);
    }

    public Class<Entity> getDomainClassFor(CrudRepository<Entity, Object> repository) {
        AnnotationRepositoryMetadata arm = new AnnotationRepositoryMetadata(repository.getClass().getInterfaces()[0]);
        return arm.getDomainType();
    }

    private Class<?> getIdTypeFor(BiaAdminCrudRepository<Entity> repository) {
        AnnotationRepositoryMetadata arm = new AnnotationRepositoryMetadata(repository.getClass().getInterfaces()[0]);
        return arm.getIdType();
    }

    private Map<String, Field> fieldMapFromFields(Field[] fields) {
        HashMap<String, Field> result = new HashMap<String, Field>();
        for (Field field : fields) {
            result.put(field.getName(), field);
        }
        return result;
    }

    private void setEntityFields(Map<String, String> params, Object entity) {
        Field[] entityFields = entity.getClass().getFields();
        Map<String, Field> fieldMap = this.fieldMapFromFields(entityFields);
        fieldMap.forEach((key, field) -> {
            String value = (String)params.get(key);
            if (value != null) {
                this.setEntityField(entity, (Field)field, this.convertValue((Field)field, value));
            } else {
                try {
                    Object currentValue = field.get(entity);
                    if (currentValue != null && !currentValue.toString().trim().isEmpty()) {
                        field.set(entity, null);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    logger.error((Object)"Couldn't set field", (Throwable)e);
                    throw new RuntimeException("Couldn't set field", e);
                }
            }
        });
    }

    private void setEntityField(Object entity, Field field, String value) {
        Class<?> type = field.getType();
        field.setAccessible(true);
        try {
            field.set(entity, this.stringToType(value, type));
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            logger.error((Object)e);
        }
    }

    private Object stringToType(String value, Class<?> type) {
        Object convertedValue = null;
        if (value != null) {
            if (type == Integer.class) {
                convertedValue = Integer.valueOf(value);
            } else if (type == Long.class) {
                convertedValue = Long.valueOf(value);
            } else if (type == Double.class) {
                convertedValue = Double.valueOf(value);
            } else if (type == Boolean.class) {
                convertedValue = Boolean.valueOf(value);
            } else if (type == Identifier.class) {
                convertedValue = new Identifier(value);
            } else if (type == ArrayNode.class) {
                ObjectMapper mapper = new ObjectMapper();
                try {
                    JsonNode node = mapper.readTree(value);
                    convertedValue = node.isArray() ? (ArrayNode)node : mapper.createArrayNode();
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
                System.out.println("yup");
            } else if (type == Date.class) {
                try {
                    convertedValue = DATE_FORMAT.parse(value);
                }
                catch (ParseException e) {
                    logger.error((Object)e);
                }
            } else {
                convertedValue = value;
            }
        }
        return convertedValue;
    }

    private String convertValue(Field field, String value) {
        String result = value;
        DynamicFieldType type = field.getAnnotation(DynamicFieldType.class);
        if (type != null && value != null && type.editControlType() == FieldType.Checkbox) {
            if ("false".equals(value.trim().toLowerCase())) {
                result = "0";
            } else if ("true".equals(value.trim().toLowerCase())) {
                result = "1";
            }
        }
        return result;
    }

    public Field getIdField(CrudRepository<Entity, Object> repository) {
        Field[] fields;
        Class<Entity> domainClass = this.getDomainClassFor(repository);
        for (Field field : fields = domainClass.getDeclaredFields()) {
            Id id = field.getAnnotation(Id.class);
            if (id == null) continue;
            return field;
        }
        return null;
    }

    public String getTableName(CrudRepository<Entity, Object> repository) {
        Class<Entity> domainClass = this.getDomainClassFor(repository);
        Table table = domainClass.getAnnotation(Table.class);
        return table.value();
    }

    private Entity createEntity(BiaAdminCrudRepository<Entity> repository, Map<String, String> entityFields) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Object id;
        Optional optionalEntity;
        Class<Entity> domainClass = this.getDomainClassFor(repository);
        Field idField = this.getIdField(repository);
        Entity entity = null;
        if (entityFields.containsKey(idField.getName()) && (optionalEntity = repository.findById(id = this.stringToType(entityFields.get(idField.getName()), idField.getType()))).isPresent()) {
            entity = (Entity)optionalEntity.get();
        }
        if (entity == null) {
            entity = domainClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        this.setEntityFields(entityFields, entity);
        return entity;
    }

    public List<Item> getItemsFromKeytable(String schemaName, String tableName, String labelField, String keyField) throws IllegalArgumentException, IllegalAccessException {
        ArrayList<Item> items = new ArrayList<Item>();
        CrudRepository<Entity, Object> repository = this.findCrudRepositoryFor(schemaName, tableName);
        Iterable allValues = repository.findAll();
        for (Entity value : allValues) {
            Item item = this.createItem(value, labelField, keyField);
            items.add(item);
        }
        Collections.sort(items);
        return items;
    }

    private Item createItem(Entity entity, String labelField, String keyField) throws IllegalArgumentException, IllegalAccessException {
        Field[] allFields;
        String itemLabel = "";
        String itemKey = "";
        for (Field field : allFields = entity.getClass().getDeclaredFields()) {
            String fieldName = field.getName();
            if (fieldName.equals(labelField)) {
                itemLabel = String.valueOf(field.get(entity)).trim();
            }
            if (!fieldName.equals(keyField)) continue;
            itemKey = String.valueOf(field.get(entity));
        }
        return new Item(itemLabel, itemKey);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public RepositoryMetadata getRepositoryMetadata(String relation) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        TableMetadata tableMetadata = this.getTableMetadata(relation);
        BiaAdminCrudRepository<Entity> repository = this.findBiaAdminCrudRepositoryFor(relation);
        Entity entity = this.createEntity(repository, new HashMap<String, String>());
        if (tableMetadata != null) {
            return new RepositoryMetadata(entity, tableMetadata);
        }
        return new RepositoryMetadata(entity);
    }
}

