/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.batch.tasklet;

import de.superx.bianalysis.metadata.MetadataImporter;
import de.superx.spring.batch.tasklet.ExecuteDbtTasklet;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;

public class UpdateMetadataTasklet
implements Tasklet {
    static Logger logger = LoggerFactory.getLogger(ExecuteDbtTasklet.class);
    private DataSource dataSource;
    private String dbtProject;

    public UpdateMetadataTasklet(String dbtProject, DataSource dataSource) {
        this.dbtProject = dbtProject;
        this.dataSource = dataSource;
    }

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        MetadataImporter importer = new MetadataImporter();
        try {
            importer.updateMetadataSchema(this.dbtProject, this.dataSource);
            if (!importer.errorMessages.isEmpty()) {
                ExitStatus exitStatus = ExitStatus.FAILED;
                exitStatus = exitStatus.addExitDescription(importer.getPrintableErrorMessages());
                contribution.setExitStatus(exitStatus);
                logger.error(importer.getPrintableErrorMessages());
            }
        }
        catch (Exception e) {
            ExitStatus exitStatus = ExitStatus.FAILED;
            String errorMsg = e.getMessage();
            exitStatus = exitStatus.addExitDescription(errorMsg);
            contribution.setExitStatus(exitStatus);
            logger.error(importer.getPrintableErrorMessages());
        }
        return RepeatStatus.FINISHED;
    }
}

