/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.batch.tasklet;

import de.superx.bin.FMParser;
import de.superx.common.DatenblattFields;
import de.superx.common.DatenblattTables;
import de.superx.common.FieldContainer;
import de.superx.common.TableFieldExists;
import de.superx.servlet.SxPool;
import de.superx.servlet.SxPools;
import de.superx.servlet.SxSQL_Server;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ExecutionContext;

public class CommonSqlTasklet
implements StepExecutionListener {
    public static final String FREEMARKER_REPOSITORY_READ = "FREEMARKER_REPOSITORY_READ";
    Logger logger = LoggerFactory.getLogger(this.getClass());
    protected DataSource dataSource;
    protected DataSource sqlVarDataSource;
    protected String currentWorkMem;

    protected String checkFreemarker(String sql) {
        String result = sql;
        if (StringUtils.containsIgnoreCase((CharSequence)sql, (CharSequence)"freemarker template")) {
            FieldContainer individualFields = new FieldContainer();
            HashMap<String, Object> hmap = new HashMap<String, Object>();
            hmap.putAll(individualFields.getFormular());
            hmap.put("DatenblattTables", new DatenblattTables(SxSQL_Server.DEFAULT_MANDANTEN_ID));
            hmap.put("DatenblattFields", new DatenblattFields());
            hmap.put("TableFieldExists", new TableFieldExists(SxSQL_Server.DEFAULT_MANDANTEN_ID));
            try (Connection con = this.sqlVarDataSource.getConnection();){
                SxPool sxPool = SxPools.get(SxSQL_Server.DEFAULT_MANDANTEN_ID);
                hmap.putAll(sxPool.getRepository());
                FMParser fmParser = new FMParser(SxSQL_Server.DEFAULT_MANDANTEN_ID, con);
                fmParser.setTemplates(sxPool.getTemplateProcessor().rawFmTemplates);
                result = fmParser.process("FM Template", sql, hmap, "Postgres");
            }
            catch (TemplateException | IOException | SQLException e) {
                this.logger.error("ERROR parsing freemarker template", e);
                throw new RuntimeException(e);
            }
        }
        return result.trim();
    }

    public void beforeStep(StepExecution stepExecution) {
        ExecutionContext executionContext = stepExecution.getJobExecution().getExecutionContext();
        Object freeMarkerRepoRead = executionContext.get(FREEMARKER_REPOSITORY_READ);
        if (freeMarkerRepoRead == null || freeMarkerRepoRead == Boolean.FALSE) {
            CommonSqlTasklet.readFreemarkerVariables();
            executionContext.put(FREEMARKER_REPOSITORY_READ, (Object)Boolean.TRUE);
        }
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return null;
    }

    private static void readFreemarkerVariables() {
        SxPool sxPool = SxPools.get(SxSQL_Server.DEFAULT_MANDANTEN_ID);
        Optional<Throwable> initResult = sxPool.initRepository();
        if (initResult.isPresent()) {
            throw new RuntimeException("Could not init pool repository for " + SxSQL_Server.DEFAULT_MANDANTEN_ID, initResult.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setWorkMem(Connection con, int mBytes) throws SQLException {
        if (mBytes <= 0) {
            return;
        }
        String mem = mBytes + "MB";
        try (Statement st = con.createStatement();
             ResultSet rs = st.executeQuery("show work_mem");){
            rs.next();
            this.currentWorkMem = rs.getString(1);
            st.execute("SET work_mem = '" + mem + "'");
            this.logger.info("Successfully set work_mem from " + this.currentWorkMem + " to " + mem);
        }
    }

    protected void resetWorkMem(Connection con) throws SQLException {
        if (this.currentWorkMem != null && !this.currentWorkMem.isEmpty()) {
            try (Statement st = con.createStatement();){
                st.execute("SET work_mem = '" + this.currentWorkMem + "'");
            }
        }
    }
}

