/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.db.NichtAngemeldetException;
import de.memtext.util.StringUtils;
import de.memtext.util.TimeUtils;
import de.superx.common.Field;
import de.superx.common.InvalidDataTypeException;
import de.superx.common.InvalidKeyException;
import de.superx.common.Maske;
import de.superx.common.SelectableItem;
import de.superx.servlet.RequestParameter;
import de.superx.servlet.SessionAttribute;
import de.superx.servlet.SuperXManager;
import de.superx.util.SqlStringUtils;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipOutputStream;

public class ServletBasics {
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected String sessiontype;

    public static String getParameter(HttpServletRequest request, RequestParameter name) {
        return ServletBasics.getParameterString((ServletRequest)request, name.toString());
    }

    public static String getParameterString(ServletRequest request2, String name) {
        if (request2 == null) {
            return null;
        }
        String p = request2.getParameter(name);
        if (name.indexOf("passwort") == -1 && p != null && StringUtils.containsTags(p)) {
            throw new IllegalArgumentException("Parameter " + name + " enth\u00e4lt unerlaubte Tags");
        }
        return p;
    }

    public ServletBasics(HttpServletRequest request, HttpServletResponse response, String sessiontype) {
        this.request = request;
        this.response = response;
        this.sessiontype = sessiontype;
    }

    protected void checkSessionType() throws NichtAngemeldetException {
        HttpSession session = this.request.getSession();
        if (session == null) {
            throw new NichtAngemeldetException("keine Session gefunden");
        }
        Object test = session.getAttribute(SessionAttribute.sessiontype.toString());
        if (test == null || !test.toString().equals(this.sessiontype)) {
            throw new NichtAngemeldetException("falscher sessiontype, erwartet:" + this.sessiontype + " gefunden:" + String.valueOf(test));
        }
        String usera = (String)session.getAttribute("User-A");
        if (usera == null || !usera.equals("nocheck") && !usera.equals(this.request.getHeader("User-Agent"))) {
            System.out.println("Achtung, Browsertyp hat sich w\u00e4hrend der Session ge\u00e4ndert von " + this.request.getRemoteAddr() + " erwartet" + usera + " gefunden:" + this.request.getHeader("User-Agent"));
        }
    }

    protected String getBrowser() {
        String browser = this.request.getHeader("User-Agent");
        if (browser == null) {
            browser = "";
        }
        return browser;
    }

    public Locale getDesiredLocale() {
        String locale_param;
        Locale desiredLocale = this.request.getLocale();
        if (this.request.getSession() != null && this.request.getSession().getAttribute(SessionAttribute.locale.toString()) != null) {
            desiredLocale = new Locale((String)this.request.getSession().getAttribute(SessionAttribute.locale.toString()));
        }
        if ((locale_param = this.request.getParameter("locale")) != null) {
            desiredLocale = new Locale(locale_param);
        }
        return desiredLocale;
    }

    protected void sendBack(String txt) throws IOException {
        this.sendBack(txt, null);
    }

    protected void sendBack(String txt, String contenttype) throws IOException {
        Object out = null;
        TimeUtils t = new TimeUtils();
        t.start();
        byte[] stuff = txt.getBytes(SqlStringUtils.getEncoding());
        String encoding = this.request.getHeader("Accept-Encoding");
        if (!SuperXManager.isResponseCompressionWanted) {
            encoding = "none";
        }
        if (encoding != null && encoding.indexOf("gzip") != -1) {
            this.response.setHeader("Content-Encoding", "gzip");
            out = new GZIPOutputStream((OutputStream)this.response.getOutputStream());
        } else if (encoding != null && encoding.indexOf("compress") != -1) {
            this.response.setHeader("Content-Encoding", "compress");
            out = new ZipOutputStream((OutputStream)this.response.getOutputStream());
        } else {
            this.response.setContentLength(stuff.length);
            out = this.response.getOutputStream();
        }
        if (contenttype != null) {
            this.response.setContentType(contenttype);
        }
        ((OutputStream)out).write(stuff);
        ((OutputStream)out).close();
    }

    public void sendBackHtml(String txt) throws IOException {
        this.sendBack(txt, "text/html; charset=" + SqlStringUtils.getEncoding());
    }

    protected void setExpires(int secs) {
        this.response.setHeader("Expires", "" + secs);
    }

    protected void turnCacheOff() {
        this.response.setHeader("Cache-Control", "no-cache");
        this.response.setHeader("Cache-Control", "no-store");
        this.response.setHeader("Pragma", "no-cache");
        this.response.setHeader("Expires", "0");
    }

    public static String getParamChecked(HttpServletRequest request, Maske maske, String param) throws InvalidKeyException, InvalidDataTypeException {
        Field f;
        String result = ServletBasics.getParameterString((ServletRequest)request, param);
        if (result == null) {
            result = "";
        }
        if ((f = maske.getFieldOrNull(param)) != null && (!result.equals("") || f.isHidden())) {
            if (f.isHidden()) {
                SelectableItem defaultValue = f.getOriginalDefaultValue();
                if (defaultValue != null) {
                    if (result.isEmpty()) {
                        result = defaultValue.getId().toString();
                    }
                    if (!result.equals(defaultValue.getId().toString())) {
                        throw new IllegalArgumentException("Ung\u00fctiger Parameter (" + result + ") f\u00fcr " + f.getName() + " nur " + defaultValue.getId().toString() + " erlaubt");
                    }
                }
            } else {
                f.setSelectedKey(result);
            }
            result = result.replace(';', '^');
        }
        return result;
    }
}

