/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;

public class LogInit
extends HttpServlet {
    public void init() throws ServletException {
        String prefix = this.getServletContext().getRealPath("/");
        String file = this.getInitParameter("log4j-init-file");
        if (file != null) {
            File propertiesFile = new File(prefix + file);
            String logDir = prefix + "WEB-INF" + File.separator + "logs";
            LogInit.initLog4J(propertiesFile, logDir);
        }
    }

    public static boolean initLog4J(File propertiesFile, String logDir) {
        boolean success = false;
        if (propertiesFile.canRead()) {
            Properties props = new Properties();
            try (FileInputStream in = new FileInputStream(propertiesFile);){
                props.load(in);
            }
            catch (FileNotFoundException e) {
                System.err.println("Couldn't find log4j properties: " + propertiesFile.getAbsolutePath());
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                System.err.println("Couldn't read log4j properties: " + propertiesFile.getAbsolutePath());
                throw new RuntimeException(e);
            }
            for (Object key : props.keySet()) {
                if (!key.toString().endsWith(".File")) continue;
                props.setProperty((String)key, logDir + File.separator + props.getProperty((String)key));
            }
            PropertyConfigurator.configure((Properties)props);
            success = true;
        }
        return success;
    }

    public static boolean reloadLog4J(File propertiesFile, String logDir) {
        LogManager.resetConfiguration();
        return LogInit.initLog4J(propertiesFile, logDir);
    }
}

